/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.course;

import com.neuedu.educloud.tools.core.LoggerDialog;
import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.course.ImagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CoursePlayer {
    private JFrame player;
    private Resource res;
    private ImagePanel viewPanel;
    private JButton playerBtn;
    private JSlider progress;
    private Timer timer;
    private JLabel times;
    private long[] points;
    private int imagePosition = 0;
    private Clip clip;
    private boolean playing = false;
    private int audioLength;
    private int audioPosition = 0;

    public CoursePlayer(Resource res) {
        this.res = res;
        this.player = new JFrame();
        this.player.setTitle(res.getName());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.player.setSize(dimension.width / 2, dimension.height / 2);
        this.player.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                CoursePlayer.this.viewPanel.scaleImage();
            }
        });
        this.player.setLocation(dimension.width / 4, dimension.height / 4);
        this.player.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    CoursePlayer.this.stop();
                }
                catch (Exception ee) {
                    LoggerDialog.logger(ee, null);
                }
                CoursePlayer.this.player.setVisible(false);
                CoursePlayer.this.player.dispose();
            }
        });
        try {
            this.init();
        }
        catch (Exception e) {
            JPanel rootPanel = (JPanel)this.player.getContentPane();
            JLabel label = new JLabel();
            label.setText("Error:" + e.getMessage());
            rootPanel.add(label);
            LoggerDialog.logger(e, null);
        }
        this.player.setVisible(true);
    }

    private void init() throws Exception {
        File f = new File("works/" + this.res.getId() + "/audio.wav");
        File tf = new File("works/" + this.res.getId() + "/time.txt");
        DataInputStream reader = null;
        AudioInputStream ain = null;
        try {
            reader = new DataInputStream(new FileInputStream(tf));
            String tt = reader.readLine();
            String[] tps = tt.split(",");
            this.points = new long[tps.length];
            int i = 0;
            while (i < tps.length) {
                this.points[i] = Long.valueOf(tps[i]);
                ++i;
            }
            ain = AudioSystem.getAudioInputStream(f);
            DataLine.Info info = new DataLine.Info(Clip.class, ain.getFormat());
            this.clip = (Clip)AudioSystem.getLine(info);
            this.clip.open(ain);
        }
        finally {
            try {
                if (ain != null) {
                    ain.close();
                }
            }
            catch (Exception e) {
                LoggerDialog.logger(e, null);
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                LoggerDialog.logger(e, null);
            }
        }
        this.audioLength = (int)(this.clip.getMicrosecondLength() / 1000L);
        JPanel rootPanel = (JPanel)this.player.getContentPane();
        rootPanel.setLayout(new BorderLayout());
        this.viewPanel = new ImagePanel();
        rootPanel.add((Component)this.viewPanel, "Center");
        this.splashImage();
        JPanel ctrlPanel = new JPanel();
        ctrlPanel.setLayout(new BorderLayout());
        this.playerBtn = new JButton();
        this.playerBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/rec_play.png")));
        this.playerBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoursePlayer.this.playing) {
                    CoursePlayer.this.stop();
                } else {
                    CoursePlayer.this.play();
                }
            }
        });
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoursePlayer.this.tick();
            }
        });
        this.times = new JLabel();
        this.times.setText("0.0");
        this.progress = new JSlider();
        this.progress.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = CoursePlayer.this.progress.getValue();
                CoursePlayer.this.times.setText(String.valueOf(value / 1000) + "." + value % 1000 / 100);
                if (value != CoursePlayer.this.audioPosition) {
                    CoursePlayer.this.skip(value);
                }
            }
        });
        this.progress.setMinimum(0);
        this.progress.setValue(0);
        this.progress.setMaximum(this.audioLength);
        ctrlPanel.add((Component)this.playerBtn, "Before");
        ctrlPanel.add((Component)this.progress, "Center");
        ctrlPanel.add((Component)this.times, "After");
        rootPanel.add((Component)ctrlPanel, "South");
    }

    public void play() {
        this.clip.start();
        this.timer.start();
        this.playerBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/rec_pause.png")));
        this.playing = true;
    }

    public void stop() {
        this.timer.stop();
        this.clip.stop();
        this.playerBtn.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/rec_play.png")));
        this.playing = false;
    }

    public void reset() {
        this.stop();
        this.clip.setMicrosecondPosition(0L);
        this.audioPosition = 0;
        this.splashImage();
        this.progress.setValue(0);
    }

    public void skip(int position) {
        if (position < 0 || position > this.audioLength) {
            return;
        }
        this.audioPosition = position;
        this.clip.setMicrosecondPosition(position * 1000);
        this.progress.setValue(position);
        this.resetImagePosition();
    }

    void tick() {
        if (this.clip.isActive()) {
            this.audioPosition = (int)(this.clip.getMicrosecondPosition() / 1000L);
            this.progress.setValue(this.audioPosition);
            this.playImages();
        } else {
            this.reset();
        }
    }

    private void splashImage() {
        try {
            this.imagePosition = 0;
            this.viewPanel.loadImage("works/" + this.res.getId() + "/1.jpg");
            this.viewPanel.updateUI();
        }
        catch (Exception e) {
            LoggerDialog.logger(e, null);
        }
    }

    private void playImages() {
        try {
            if (this.imagePosition + 1 >= this.points.length) {
                return;
            }
            long nextPoint = this.points[this.imagePosition + 1];
            if (Math.abs(nextPoint - (long)this.audioPosition) <= 100L) {
                ++this.imagePosition;
                this.viewPanel.loadImage("works/" + this.res.getId() + "/" + (this.imagePosition + 1) + ".jpg");
                this.viewPanel.updateUI();
            }
        }
        catch (Exception e) {
            LoggerDialog.logger(e, null);
        }
    }

    private void resetImagePosition() {
        try {
            int inx = Arrays.binarySearch(this.points, (long)this.audioPosition);
            this.imagePosition = inx < 0 ? -1 * inx - 2 : inx;
            this.viewPanel.loadImage("works/" + this.res.getId() + "/" + (this.imagePosition + 1) + ".jpg");
            this.viewPanel.updateUI();
        }
        catch (Exception e) {
            LoggerDialog.logger(e, null);
        }
    }
}

