/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.course;

import com.neuedu.educloud.tools.core.LoggerDialog;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.TargetDataLine;

public class AudioRecorder
extends Thread {
    private String outputRoot = null;
    private TargetDataLine m_line;
    private AudioFileFormat.Type m_targetType;
    private AudioInputStream m_audioInputStream;
    private File m_outputFile;

    public AudioRecorder(String outputRoot) {
        this.outputRoot = outputRoot;
        try {
            float sampleRate = 8000.0f;
            int sampleSizeInBits = 16;
            int channels = 2;
            int frameSize = sampleSizeInBits / 8 * channels;
            float frameRate = sampleRate;
            AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, false);
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
            this.m_line = (TargetDataLine)AudioSystem.getLine(info);
            this.m_line.open(audioFormat);
            this.m_targetType = AudioFileFormat.Type.WAVE;
            this.m_audioInputStream = new AudioInputStream(this.m_line);
        }
        catch (Exception e) {
            LoggerDialog.logger(e, null);
        }
    }

    public void startRecording(int num) {
        try {
            this.m_outputFile = new File(String.valueOf(this.outputRoot) + "/" + num + ".wav");
            this.m_line.start();
            this.start();
        }
        catch (Exception e) {
            LoggerDialog.logger(e, null);
        }
    }

    public void stopRecording() {
        this.m_line.stop();
        this.m_line.close();
    }

    @Override
    public void run() {
        try {
            AudioSystem.write(this.m_audioInputStream, this.m_targetType, this.m_outputFile);
        }
        catch (IOException e) {
            LoggerDialog.logger(e, null);
        }
    }
}

