/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.core;

import com.neuedu.educloud.tools.core.ExtFilter;
import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.course.AudioAppend;
import com.neuedu.educloud.tools.course.Wav2Mp3;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ResourceGenerater {
    private JDialog dialog = null;
    private Resource resource = null;
    private CardLayout card;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel descLabel;
    private JTextField descField;
    private JLabel orgLabel;
    private JComboBox orgBox;
    private Map<String, String> configs;
    JProgressBar cancelProgress;
    JLabel cancelLabel;
    JProgressBar generateProgress;
    JLabel generateLabel;

    public ResourceGenerater(JFrame frame) {
        this.dialog = new JDialog((Frame)frame, true);
        this.dialog.setSize(300, 200);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation(dimension.width / 2 - 150, dimension.height / 2 - 100);
        this.dialog.setDefaultCloseOperation(1);
        JPanel rootPanel = (JPanel)this.dialog.getContentPane();
        this.card = new CardLayout();
        rootPanel.setLayout(this.card);
        JPanel coursePanel = this.getConfigPanel();
        rootPanel.add((Component)coursePanel, "config");
        JPanel cancelPanel = this.getCancelPanel();
        rootPanel.add((Component)cancelPanel, "cancel");
        JPanel courseGeneraterPanel = this.getGeneraterPanel();
        rootPanel.add((Component)courseGeneraterPanel, "generate");
    }

    public void generate(Resource res, Map<String, String> configs) {
        this.resource = res;
        this.configs = configs;
        String orgNames = configs.get("org_names");
        orgNames = orgNames != null ? "\u516c\u5f00," + orgNames : "\u516c\u5f00";
        String[] names = orgNames.split(",");
        this.orgBox.setModel(new DefaultComboBoxModel<String>(names));
        this.orgBox.setSelectedIndex(0);
        if (res.getType() == Resource.COURSE_TYPE) {
            this.dialog.setTitle("\u8bfe\u7a0b\u751f\u6210");
        } else {
            this.dialog.setTitle("\u8bd5\u5377\u751f\u6210");
        }
        if (res != null) {
            String ss = res.getName();
            this.nameField.setText(ss);
            if (ss != null && !"".equals(ss)) {
                this.nameField.setEditable(false);
            } else {
                this.nameField.setEditable(true);
            }
        } else {
            this.nameField.setEditable(true);
        }
        if (res != null) {
            this.descField.setText(res.getDescription());
        }
        this.dialog.setVisible(true);
        this.card.show(this.dialog.getContentPane(), "config");
    }

    public void remove(String id) {
        File zipfile;
        File[] files;
        File resdir = new File("works/" + id);
        File[] fileArray = files = resdir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
        resdir.delete();
        File restdir = new File("templets/" + id);
        if (restdir.exists()) {
            File[] afiles;
            File[] fileArray2 = afiles = restdir.listFiles();
            int n3 = afiles.length;
            int n4 = 0;
            while (n4 < n3) {
                File file = fileArray2[n4];
                file.delete();
                ++n4;
            }
            restdir.delete();
        }
        if ((zipfile = new File("works/" + id + ".zip")).exists()) {
            zipfile.delete();
        }
    }

    private JPanel getConfigPanel() {
        JPanel panel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.descLabel = new JLabel();
        this.descField = new JTextField();
        this.orgLabel = new JLabel();
        this.orgBox = new JComboBox();
        this.orgBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int inx = ResourceGenerater.this.orgBox.getSelectedIndex();
                String orgId = null;
                if (inx > 0) {
                    String orgids = (String)ResourceGenerater.this.configs.get("org_ids");
                    String[] ids = orgids.split(",");
                    orgId = ids[inx - 1];
                }
                ResourceGenerater.this.resource.setOrgId(orgId);
            }
        });
        JButton cancelBtn = new JButton();
        JButton saveBtn = new JButton();
        panel.setMinimumSize(new Dimension(320, 80));
        panel.setPreferredSize(new Dimension(320, 80));
        this.nameLabel.setText("\u8d44\u6e90\u540d\u79f0");
        this.nameField.setMinimumSize(new Dimension(6, 22));
        this.nameField.setPreferredSize(new Dimension(72, 22));
        this.descLabel.setText("\u8d44\u6e90\u63cf\u8ff0");
        this.descField.setMinimumSize(new Dimension(6, 22));
        this.descField.setPreferredSize(new Dimension(72, 22));
        this.orgLabel.setText("\u53d1\u5e03\u8303\u56f4");
        this.orgLabel.setMinimumSize(new Dimension(6, 22));
        this.orgLabel.setPreferredSize(new Dimension(72, 22));
        cancelBtn.setText("\u53d6\u6d88");
        cancelBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ResourceGenerater.this.resource.setName(null);
                ResourceGenerater.this.card.show(ResourceGenerater.this.dialog.getContentPane(), "cancel");
                ResourceGenerater.this.dialog.getContentPane().validate();
                ResourceGenerater.this.cancelResource();
            }
        });
        saveBtn.setText("\u786e\u5b9a");
        saveBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String nn = ResourceGenerater.this.nameField.getText();
                if ("".equals(nn.trim())) {
                    ResourceGenerater.this.nameField.requestFocus();
                    ResourceGenerater.this.nameLabel.setForeground(Color.red);
                    return;
                }
                ResourceGenerater.this.card.show(ResourceGenerater.this.dialog.getContentPane(), "generate");
                ResourceGenerater.this.dialog.getContentPane().validate();
                ResourceGenerater.this.resource.setName(ResourceGenerater.this.nameField.getText());
                ResourceGenerater.this.resource.setDescription(ResourceGenerater.this.descField.getText());
                if (ResourceGenerater.this.resource.getType() == Resource.COURSE_TYPE) {
                    ResourceGenerater.this.saveCourse();
                } else {
                    ResourceGenerater.this.savePaper();
                }
            }
        });
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(cancelBtn).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(saveBtn)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addGap(12, 12, 12).addComponent(this.nameField, -2, 206, -2)).addGroup(layout.createSequentialGroup().addComponent(this.descLabel).addGap(12, 12, 12).addComponent(this.descField, -2, 206, -2)).addGroup(layout.createSequentialGroup().addComponent(this.orgLabel).addGap(12, 12, 12).addComponent(this.orgBox, -2, 206, -2)))).addContainerGap(22, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.descLabel).addComponent(this.descField, -2, -1, -2)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.orgLabel).addComponent(this.orgBox, -2, -1, -2)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(cancelBtn).addComponent(saveBtn)).addContainerGap(54, Short.MAX_VALUE)));
        return panel;
    }

    private void cancelResource() {
        File tempDir = new File("works/temp");
        File[] files = tempDir.listFiles();
        if (files.length > 0) {
            this.cancelProgress.setMinimum(0);
            this.cancelProgress.setMaximum(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                int val = this.cancelProgress.getValue();
                int nval = val + 1;
                this.cancelProgress.setValue(nval);
                this.cancelProgress.setString(String.valueOf(nval) + "/" + files.length);
                ++n2;
            }
        }
        this.dialog.setVisible(false);
    }

    private JPanel getCancelPanel() {
        JPanel panel = new JPanel();
        this.cancelProgress = new JProgressBar();
        this.cancelProgress.setStringPainted(true);
        this.cancelLabel = new JLabel();
        panel.setMinimumSize(new Dimension(300, 60));
        panel.setPreferredSize(new Dimension(300, 60));
        this.cancelLabel.setText("\u6b63\u5728\u5220\u9664\u4e34\u65f6\u6587\u4ef6,\u8bf7\u7b49\u5f85");
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cancelProgress, -1, 276, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.cancelLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.cancelLabel).addGap(18, 18, 18).addComponent(this.cancelProgress, -2, -1, -2).addContainerGap(75, Short.MAX_VALUE)));
        return panel;
    }

    private JPanel getGeneraterPanel() {
        JPanel panel = new JPanel();
        this.generateProgress = new JProgressBar();
        this.generateProgress.setStringPainted(true);
        this.generateLabel = new JLabel();
        panel.setMinimumSize(new Dimension(300, 60));
        panel.setPreferredSize(new Dimension(300, 60));
        this.generateLabel.setText("\u6b63\u5728\u751f\u6210\u6587\u4ef6,\u8bf7\u7b49\u5f85");
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.generateProgress, -1, 276, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.generateLabel).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(36, 36, 36).addComponent(this.generateLabel).addGap(18, 18, 18).addComponent(this.generateProgress, -2, -1, -2).addContainerGap(75, Short.MAX_VALUE)));
        return panel;
    }

    private void saveCourse() {
        try {
            this.generateProgress.setMinimum(0);
            String outdir = "works/" + this.resource.getId();
            File dir = new File(outdir);
            boolean noimage = false;
            File tmpdir = new File("works/temp");
            String[] filenames = tmpdir.list(new ExtFilter("jpg"));
            if (filenames.length > 0) {
                dir.mkdirs();
                this.generateLabel.setText("[1/3]\u6b63\u5728\u590d\u5236\u6587\u4ef6,\u8bf7\u7b49\u5f85");
                this.generateProgress.setMaximum(filenames.length + 15);
                int[] times = new int[filenames.length];
                int i = 0;
                while (i < times.length) {
                    times[i] = Integer.valueOf(filenames[i].substring(0, filenames[i].length() - 4));
                    ++i;
                }
                Arrays.sort(times);
                this.generateProgress.setValue(3);
                StringBuffer timeBuffer = new StringBuffer();
                timeBuffer.append(times[0]);
                int i2 = 1;
                while (i2 < times.length) {
                    timeBuffer.append(',').append(times[i2]);
                    ++i2;
                }
                this.generateProgress.setValue(5);
                FileOutputStream fos_time = null;
                try {
                    File timeFile = new File(String.valueOf(outdir) + "/time.txt");
                    fos_time = new FileOutputStream(timeFile);
                    fos_time.write(timeBuffer.toString().getBytes("utf-8"));
                    fos_time.flush();
                }
                finally {
                    if (fos_time != null) {
                        try {
                            fos_time.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.generateProgress.setValue(10);
                int i3 = 1;
                while (i3 <= times.length) {
                    File src = new File("works/temp/" + times[i3 - 1] + ".jpg");
                    src.renameTo(new File(String.valueOf(outdir) + "/" + i3 + ".jpg"));
                    int oldval = this.generateProgress.getValue();
                    this.generateProgress.setValue(1 + oldval);
                    ++i3;
                }
                this.generateProgress.setValue(this.generateProgress.getMaximum());
                this.generateLabel.setText("[2/3]\u6b63\u5728\u5408\u6210\u8bed\u97f3\u6587\u4ef6,\u8bf7\u7b49\u5f85");
                this.generateProgress.setMaximum(3);
                this.generateProgress.setValue(1);
                File[] wavs = tmpdir.listFiles(new ExtFilter("wav"));
                if (wavs.length > 1) {
                    AudioAppend.append(String.valueOf(outdir) + "/audio.wav", wavs);
                } else {
                    wavs[0].renameTo(new File(String.valueOf(outdir) + "/audio.wav"));
                }
                this.generateProgress.setValue(2);
                Wav2Mp3.writeFile(String.valueOf(outdir) + "/audio.wav", String.valueOf(outdir) + "/audio.mp3");
                this.generateProgress.setValue(3);
                this.generateLabel.setText("[3/3] \u6b63\u5728\u6e05\u7406\u4e34\u65f6\u6587\u4ef6,\u8bf7\u7b49\u5f85");
            } else {
                this.resource.setName(null);
                noimage = true;
                this.generateLabel.setText("[\u9519\u8bef] \u6b63\u5728\u6e05\u7406\u4e34\u65f6\u6587\u4ef6,\u8bf7\u7b49\u5f85");
            }
            File tempDir = new File("works/temp");
            File[] files = tempDir.listFiles();
            this.generateProgress.setMaximum(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                int val = this.generateProgress.getValue();
                int nval = val + 1;
                this.generateProgress.setValue(nval);
                this.generateProgress.setString(String.valueOf(nval) + "/" + files.length);
                ++n2;
            }
            if (!noimage) {
                this.generateLabel.setText("\u5b8c\u6210");
                this.dialog.setVisible(false);
            } else {
                this.generateLabel.setText("[\u9519\u8bef] \u6ca1\u6709\u56fe\u50cf\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            this.generateLabel.setText("[\u9519\u8bef]" + e.getMessage());
        }
    }

    private void savePaper() {
        try {
            this.generateProgress.setMinimum(0);
            String outdir = "works/" + this.resource.getId();
            File dir = new File(outdir);
            boolean noimage = false;
            File tmpdir = new File("works/temp");
            String[] filenames = tmpdir.list();
            if (filenames.length > 0) {
                dir.mkdirs();
                this.generateLabel.setText("[1/2]\u6b63\u5728\u590d\u5236\u6587\u4ef6,\u8bf7\u7b49\u5f85");
                this.generateProgress.setMaximum(filenames.length);
                String[] stringArray = filenames;
                int n = filenames.length;
                int n2 = 0;
                while (n2 < n) {
                    String filename = stringArray[n2];
                    File src = new File("works/temp/" + filename);
                    src.renameTo(new File(String.valueOf(outdir) + "/" + filename));
                    int oldval = this.generateProgress.getValue();
                    this.generateProgress.setValue(1 + oldval);
                    ++n2;
                }
                File welImage = new File(String.valueOf(outdir) + "/1.jpg");
                if (!welImage.exists()) {
                    BufferedImage im = new BufferedImage(800, 600, 1);
                    Graphics g = im.getGraphics();
                    BufferedImage imgicon = ImageIO.read(this.getClass().getResource("/com/neuedu/educloud/tools/images/paper_bg.png"));
                    g.drawImage(imgicon, 0, 0, null);
                    g.setColor(Color.BLACK);
                    g.drawString("\u8bd5\u5377" + this.resource.getId(), 20, 20);
                    g.setFont(new Font("\u5b8b\u4f53", 1, 32));
                    String res_name = this.resource.getName();
                    int length = res_name.length();
                    int left = (800 - length * 32) / 2;
                    if (left < 0) {
                        left = 5;
                    }
                    g.drawString(res_name, left, 500);
                    ImageIO.write((RenderedImage)im, "jpg", welImage);
                }
                this.generateProgress.setValue(this.generateProgress.getMaximum());
                this.generateLabel.setText("[2/2] \u6b63\u5728\u6e05\u7406\u4e34\u65f6\u6587\u4ef6,\u8bf7\u7b49\u5f85");
            } else {
                this.resource.setName(null);
                noimage = true;
                this.generateLabel.setText("[\u9519\u8bef] \u6b63\u5728\u6e05\u7406\u4e34\u65f6\u6587\u4ef6,\u8bf7\u7b49\u5f85");
            }
            File tempDir = new File("works/temp");
            File[] files = tempDir.listFiles();
            this.generateProgress.setMaximum(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File file = fileArray[n3];
                file.delete();
                int val = this.generateProgress.getValue();
                int nval = val + 1;
                this.generateProgress.setValue(nval);
                this.generateProgress.setString(String.valueOf(nval) + "/" + files.length);
                ++n3;
            }
            if (!noimage) {
                this.generateLabel.setText("\u5b8c\u6210");
                this.dialog.setVisible(false);
            } else {
                this.generateLabel.setText("[\u9519\u8bef] \u6ca1\u6709\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            this.generateLabel.setText("[\u9519\u8bef]" + e.getMessage());
        }
    }
}

