/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.core;

import com.neuedu.educloud.tools.core.Resource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ResourceCellRenderer
implements ListCellRenderer {
    private static final Color HIGHLIGHT_COLOR = new Color(0, 0, 128);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Resource entry = (Resource)value;
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(204, 204, 204)));
        panel.setPreferredSize(new Dimension(270, 40));
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        panel.setToolTipText(entry.getName());
        JLabel iconLabel = new JLabel();
        JLabel nameLabel = new JLabel();
        JLabel timeLabel = new JLabel();
        JLabel statusLabel = new JLabel();
        iconLabel.setHorizontalAlignment(0);
        nameLabel.setFont(new Font("\u5b8b\u4f53", 0, 14));
        timeLabel.setFont(new Font("Times New Roman", 2, 12));
        timeLabel.setVerticalAlignment(1);
        statusLabel.setFont(new Font("\u5b8b\u4f53", 2, 12));
        statusLabel.setVerticalAlignment(1);
        iconLabel.setIcon(entry.getImage());
        nameLabel.setText(entry.getName());
        timeLabel.setText(entry.getCreateTime());
        if (entry.getStatus() == Resource.UPLOADING || entry.getStatus() == Resource.PAUSE) {
            statusLabel.setText(String.valueOf(entry.getStatusText()) + ":" + entry.getSended() + "/" + entry.getLength());
        } else if (entry.getStatus() == Resource.ERROR) {
            statusLabel.setText(String.valueOf(entry.getStatusText()) + ":" + entry.getMsg());
        } else {
            statusLabel.setText(entry.getStatusText());
        }
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(iconLabel, -2, 40, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(timeLabel, -2, 260, -2).addComponent(statusLabel, -1, 210, Short.MAX_VALUE)).addComponent(nameLabel, -2, 470, -2))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(iconLabel, -2, 40, -2).addGroup(layout.createSequentialGroup().addComponent(nameLabel, -2, 22, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusLabel, -2, 18, -2).addComponent(timeLabel, -2, 18, -2))));
        if (isSelected) {
            panel.setBackground(HIGHLIGHT_COLOR);
            nameLabel.setForeground(Color.white);
            timeLabel.setForeground(Color.white);
            statusLabel.setForeground(Color.white);
        } else {
            panel.setBackground(Color.white);
            nameLabel.setForeground(Color.black);
            timeLabel.setForeground(Color.black);
            statusLabel.setForeground(Color.black);
        }
        return panel;
    }
}

