/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.core;

import com.neuedu.educloud.tools.core.Resource;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class DataStorage {
    private static DataStorage data;
    private static Properties props;
    private Connection conn = null;

    static {
        props = new Properties();
    }

    private DataStorage() {
    }

    public static DataStorage getInstance() {
        if (data == null) {
            data = new DataStorage();
            try {
                props.load(DataStorage.class.getResourceAsStream("/services.properties"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public void open() {
        Statement stmt = null;
        try {
            try {
                Class.forName("org.h2.Driver");
                File root = new File("works");
                String workdir = root.getAbsolutePath();
                this.conn = DriverManager.getConnection("jdbc:h2:file:" + workdir + "/data", "sa", "");
                stmt = this.conn.createStatement();
                this.createTables(stmt);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6570\u636e\u6587\u4ef6\u6253\u5f00\u5931\u8d25", e);
            }
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void close() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception sqle) {
            sqle.printStackTrace();
        }
    }

    private void createTables(Statement stmt) throws SQLException {
        stmt.execute("create table if not exists resources(id varchar(255) PRIMARY KEY, name varchar(255),  type int, image varchar(1023),status int, sended int, length int, alltime int,quenum int, catalog1 varchar(255), catalog2 varchar(255) , msg varchar(255),resId varchar(255) , md5 varchar(255), description varchar(1023),createtime varchar(31) , orgId varchar(255))");
        stmt.execute("create table  if not exists config(key varchar(255) PRIMARY KEY,val varchar(255) )");
    }

    public Vector<Resource> loadResources() {
        Vector<Resource> vres = new Vector<Resource>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery("select * from resources");
                while (rs.next()) {
                    String id = rs.getString("id");
                    Resource res = new Resource(id);
                    String name = rs.getString("name");
                    int type2 = rs.getInt("type");
                    String image = rs.getString("image");
                    int status = rs.getInt("status");
                    int sended = rs.getInt("sended");
                    int length = rs.getInt("length");
                    long alltime = rs.getLong("alltime");
                    int quenum = rs.getInt("quenum");
                    String catalog1 = rs.getString("catalog1");
                    String catalog2 = rs.getString("catalog2");
                    String createtime = rs.getString("createtime");
                    String msg = rs.getString("msg");
                    String resId = rs.getString("resId");
                    String md5 = rs.getString("md5");
                    String orgId = rs.getString("orgId");
                    String description = rs.getString("description");
                    res.setName(name);
                    res.setType(type2);
                    res.setImagePath(image);
                    res.setStatus(status);
                    res.setSended(sended);
                    res.setLength(length);
                    res.setAlltime(alltime);
                    res.setQueNum(quenum);
                    res.setCatalog1(catalog1);
                    res.setCatalog2(catalog2);
                    res.setMsg(msg);
                    res.setCreateTime(createtime);
                    res.setResId(resId);
                    res.setMd5(md5);
                    res.setDescription(description);
                    res.setOrgId(orgId);
                    vres.add(res);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u6570\u636e\u52a0\u8f7d\u5931\u8d25", e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return vres;
    }

    public void updateResources(Resource resource) {
        block12: {
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("update resources set name=?,status=?,sended=?,length=?,catalog1=?, catalog2=?,msg=?,resId=?,md5=?,description=?,orgId=? where id=?");
                    stmt.setString(1, resource.getName());
                    stmt.setInt(2, resource.getStatus());
                    stmt.setInt(3, resource.getSended());
                    stmt.setInt(4, resource.getLength());
                    stmt.setString(5, resource.getCatalog1());
                    stmt.setString(6, resource.getCatalog2());
                    stmt.setString(7, resource.getMsg());
                    stmt.setString(8, resource.getResId());
                    stmt.setString(9, resource.getMd5());
                    stmt.setString(10, resource.getDescription());
                    stmt.setString(11, resource.getOrgId());
                    stmt.setString(12, resource.getId());
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (stmt == null) break block12;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void insertResources(Resource resource) {
        block12: {
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("insert into resources(id,name,type,image,status,sended, length,alltime,quenum,catalog1, catalog2,msg,createtime,orgId ) values(?,?, ?,?,?,?,?,?,?,?,?,?,?,?)");
                    stmt.setString(1, resource.getId());
                    stmt.setString(2, resource.getName());
                    stmt.setInt(3, resource.getType());
                    stmt.setString(4, resource.getImagePath());
                    stmt.setInt(5, resource.getStatus());
                    stmt.setInt(6, resource.getSended());
                    stmt.setInt(7, resource.getLength());
                    stmt.setLong(8, resource.getAlltime());
                    stmt.setInt(9, resource.getQueNum());
                    stmt.setString(10, resource.getCatalog1());
                    stmt.setString(11, resource.getCatalog2());
                    stmt.setString(12, resource.getMsg());
                    stmt.setString(13, resource.getCreateTime());
                    stmt.setString(14, resource.getOrgId());
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (stmt == null) break block12;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void deleteResource(String id) {
        block12: {
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("delete from resources where id=?");
                    stmt.setString(1, id);
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (stmt == null) break block12;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void saveConfig(String key, String val) {
        block13: {
            if (val == null || "".equals(val.trim())) {
                return;
            }
            PreparedStatement stmt = null;
            try {
                try {
                    stmt = this.conn.prepareStatement("update config set val=? where key=?");
                    stmt.setString(1, val);
                    stmt.setString(2, key);
                    stmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (stmt == null) break block13;
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public Map<String, String> loadConfigs() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery("select * from config");
                while (rs.next()) {
                    String k = rs.getString("key");
                    String v = rs.getString("val");
                    attrs.put(k, v);
                }
                if (attrs.isEmpty()) {
                    this.setDefaultConfig(stmt, attrs, "dasUrl", "https://yun.neuedu.cn:80");
                    this.setDefaultConfig(stmt, attrs, "rssUrl", "http://xue.neuedu.cn:80");
                    this.setDefaultConfig(stmt, attrs, "user", "");
                    this.setDefaultConfig(stmt, attrs, "passwd", "");
                    this.setDefaultConfig(stmt, attrs, "course_record_keyboard_enable", "true");
                    this.setDefaultConfig(stmt, attrs, "course_record_start_key", "116");
                    this.setDefaultConfig(stmt, attrs, "course_record_stop_key", "27");
                }
                attrs.put("version", "1.3");
                String dasPointEnd = props.getProperty("neuedu.jianxue.das_pointend");
                if (!dasPointEnd.endsWith("/")) {
                    dasPointEnd = String.valueOf(dasPointEnd) + "/";
                }
                attrs.put("dasPointEnd", dasPointEnd);
                String rssPointEnd = props.getProperty("neuedu.jianxue.rss_pointend");
                if (!rssPointEnd.endsWith("/")) {
                    rssPointEnd = String.valueOf(rssPointEnd) + "/";
                }
                attrs.put("rssPointEnd", rssPointEnd);
                String dasKeystoreFile = props.getProperty("neuedu.jianxue.das_keystore_file");
                attrs.put("dasKeystoreFile", dasKeystoreFile);
                String dasKeystorePass = props.getProperty("neuedu.jianxue.das_keystore_pass");
                attrs.put("dasKeystorePass", dasKeystorePass);
            }
            catch (Exception e) {
                throw new RuntimeException("\u6570\u636e\u52a0\u8f7d\u5931\u8d25", e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return attrs;
    }

    public String[] loadCatalog1() {
        return new String[]{"\u5174\u8da3", "IT\u6280\u672f", "\u804c\u573a", "\u8bed\u8a00", "\u751f\u6d3b", "\u5065\u5eb7"};
    }

    public String[] loadCatalog2(String catalog1) {
        if ("IT\u6280\u672f".equals(catalog1)) {
            return new String[]{"Java", "C/C++", "Flash", "Andriod", "iOS", "\u5d4c\u5165\u5f0f", "\u4e92\u8054\u7f51", "\u4e2d\u95f4\u4ef6", "\u64cd\u4f5c\u7cfb\u7edf", "\u5176\u5b83"};
        }
        return null;
    }

    private void setDefaultConfig(Statement stmt, Map<String, String> attrs, String k, String v) throws SQLException {
        stmt.executeUpdate("insert into config values('" + k + "','" + v + "')");
        attrs.put(k, v);
    }
}

