/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools.core;

import com.neuedu.educloud.tools.core.DataStorage;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ConfigDialog {
    private JCheckBox kbCheckBox;
    private JPasswordField passwdField;
    private JComboBox startKeyComboBox;
    private JComboBox stopKeyComboBox;
    private JLabel stopLeyField;
    private JLabel startKeyField;
    private JTextField userField;
    private String[] keyLabels = new String[]{"[F1]", "[F2]", "[F3]", "[F4]", "[F5]", "[F6]", "[F7]", "[F8]", "[F9]", "[F10]", "[F11]", "[F12]", "[ESC]"};
    private String[] keyCodes = new String[]{"112", "113", "114", "115", "116", "117", "118", "119", "120", "121", "122", "123", "27"};
    private DataStorage storage = DataStorage.getInstance();
    private JDialog dialog;
    private Map<String, String> configs;

    public ConfigDialog(JFrame frame, Map<String, String> configs) {
        this.configs = configs;
        this.dialog = new JDialog((Frame)frame, true);
        this.dialog.setSize(300, 260);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation(dimension.width / 2 - 150, dimension.height / 2 - 130);
        this.dialog.setDefaultCloseOperation(2);
        this.initComponents();
        this.dialog.setVisible(true);
    }

    private void initComponents() {
        JPanel rootPanel = (JPanel)this.dialog.getContentPane();
        JLabel userLabel = new JLabel();
        this.userField = new JTextField();
        JLabel passwdLabel = new JLabel();
        this.kbCheckBox = new JCheckBox();
        JLabel startKeyLabel = new JLabel();
        this.startKeyComboBox = new JComboBox();
        this.startKeyField = new JLabel();
        JLabel stopKeyLabel = new JLabel();
        this.stopKeyComboBox = new JComboBox();
        this.stopLeyField = new JLabel();
        JButton okBtn = new JButton();
        JButton cancelBtn = new JButton();
        JLabel append1Label = new JLabel();
        JLabel append2Label = new JLabel();
        this.passwdField = new JPasswordField();
        userLabel.setText("\u5e10\u6237");
        passwdLabel.setText("\u5bc6\u7801");
        this.kbCheckBox.setText("\u4f7f\u7528\u952e\u76d8\u76d1\u542c\u8fdb\u884c\u8bfe\u7a0b\u5f55\u5236 ( \u9700\u8981\u91cd\u542f)");
        this.kbCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ConfigDialog.this.kbCheckBox.isSelected()) {
                    ConfigDialog.this.startKeyComboBox.setEnabled(true);
                    ConfigDialog.this.stopKeyComboBox.setEnabled(true);
                } else {
                    ConfigDialog.this.startKeyComboBox.setEnabled(false);
                    ConfigDialog.this.stopKeyComboBox.setEnabled(false);
                }
            }
        });
        startKeyLabel.setText("\u542f\u52a8Key");
        this.startKeyComboBox.setModel(new DefaultComboBoxModel<String>(this.keyLabels));
        stopKeyLabel.setText("\u505c\u6b62Key");
        this.stopKeyComboBox.setModel(new DefaultComboBoxModel<String>(this.keyLabels));
        this.userField.setText(this.configs.get("user"));
        this.passwdField.setText(this.configs.get("passwd"));
        this.kbCheckBox.setSelected("true".equals(this.configs.get("course_record_keyboard_enable")));
        String startKey = this.configs.get("course_record_start_key");
        String stopKey = this.configs.get("course_record_stop_key");
        this.cvtCode2UI(startKey, this.startKeyComboBox, this.startKeyField);
        this.cvtCode2UI(stopKey, this.stopKeyComboBox, this.stopLeyField);
        if (this.kbCheckBox.isSelected()) {
            this.startKeyComboBox.setEnabled(true);
            this.stopKeyComboBox.setEnabled(true);
        } else {
            this.startKeyComboBox.setEnabled(false);
            this.stopKeyComboBox.setEnabled(false);
        }
        okBtn.setText("\u786e\u5b9a");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.okBtnActionPerformed(evt);
            }
        });
        cancelBtn.setText("\u53d6\u6d88");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConfigDialog.this.dialog.dispose();
            }
        });
        append1Label.setText("");
        append2Label.setText("");
        GroupLayout layout = new GroupLayout(rootPanel);
        rootPanel.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(cancelBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(okBtn)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.kbCheckBox).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(startKeyLabel).addComponent(stopKeyLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.stopKeyComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.startKeyComboBox, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(append2Label).addComponent(append1Label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.stopLeyField, -2, 117, -2).addComponent(this.startKeyField, -2, 117, -2)))).addGap(0, 19, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(userLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.userField, -2, 139, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(passwdLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwdField))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(userLabel).addComponent(this.userField, -2, -1, -2).addComponent(passwdLabel).addComponent(this.passwdField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.kbCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(startKeyLabel).addComponent(this.startKeyComboBox, -2, -1, -2).addComponent(this.startKeyField, -2, -1, -2).addComponent(append1Label)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(stopKeyLabel).addComponent(this.stopKeyComboBox, -2, -1, -2).addComponent(this.stopLeyField, -2, -1, -2).addComponent(append2Label)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(okBtn).addComponent(cancelBtn)).addContainerGap(22, Short.MAX_VALUE)));
    }

    private void okBtnActionPerformed(ActionEvent evt) {
        this.storage.saveConfig("user", this.userField.getText());
        this.storage.saveConfig("passwd", this.passwdField.getText());
        this.storage.saveConfig("course_record_keyboard_enable", this.kbCheckBox.isSelected() ? "true" : "false");
        this.storage.saveConfig("course_record_start_key", this.cvtUI2Code(this.startKeyComboBox, this.startKeyField));
        this.storage.saveConfig("course_record_stop_key", this.cvtUI2Code(this.stopKeyComboBox, this.stopLeyField));
        this.dialog.dispose();
    }

    private void cvtCode2UI(String code, JComboBox comboBox, JLabel appendField) {
        int i = 0;
        while (i < this.keyCodes.length) {
            if (code.equals(this.keyCodes[i])) {
                comboBox.setSelectedItem(this.keyLabels[i]);
                appendField.setText(code);
            }
            ++i;
        }
    }

    private String cvtUI2Code(JComboBox comboBox, JLabel appendField) {
        String sel = (String)comboBox.getSelectedItem();
        String code = "27";
        int i = 0;
        while (i < this.keyCodes.length) {
            if (sel.equals(this.keyLabels[i])) {
                comboBox.setSelectedItem(this.keyLabels[i]);
                code = this.keyCodes[i];
                appendField.setText(code);
            }
            ++i;
        }
        return code;
    }
}

