/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.tools;

import com.neuedu.educloud.api.ApiException;
import com.neuedu.educloud.api.http.HttpRequestFactory;
import com.neuedu.educloud.api.http.UrlConnectionTransport;
import com.neuedu.educloud.api.oauth.AccessTokenRequest;
import com.neuedu.educloud.api.oauth.AccessTokenResponse;
import com.neuedu.educloud.api.oauth.OAuth2Params;
import com.neuedu.educloud.api.oauth.OAuth2URL;
import com.neuedu.educloud.tools.core.ConfigDialog;
import com.neuedu.educloud.tools.core.DataStorage;
import com.neuedu.educloud.tools.core.LoggerDialog;
import com.neuedu.educloud.tools.core.ResouceAttributes;
import com.neuedu.educloud.tools.core.Resource;
import com.neuedu.educloud.tools.core.ResourceCellRenderer;
import com.neuedu.educloud.tools.core.ResourceGenerater;
import com.neuedu.educloud.tools.core.SplashWindow;
import com.neuedu.educloud.tools.course.CoursePlayer;
import com.neuedu.educloud.tools.course.CourseRecorder;
import com.neuedu.educloud.tools.export.ScormExport;
import com.neuedu.educloud.tools.paper.PaperEditor;
import com.neuedu.educloud.tools.upload.Uploader;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ResourceMaker
extends JFrame {
    private static final long serialVersionUID = 1L;
    public static SplashWindow splash = null;
    public static final int WM_LBUTTONUP = 514;
    public static final int WM_LBUTTONDOWN = 513;
    private final User32 lib = User32.INSTANCE;
    private static WinUser.HHOOK keyboardhhk;
    private static WinUser.HHOOK mousehhk;
    private static WinUser.LowLevelKeyboardProc keyboardHook;
    private static LowLevelMouseProc mouseHook;
    private boolean offline = false;
    private JList resList;
    private Vector<Resource> resources;
    private Map<String, String> configs;
    private JPopupMenu popupMenu = new JPopupMenu("Popup");
    private Map<String, JMenuItem> items = new HashMap<String, JMenuItem>();
    private String[] itemNames = new String[]{"Attris", "Preview", "Delete", "Export"};
    private String[] itemTexts = new String[]{"\u5c5e\u6027", "\u7f16\u8f91", "\u5220\u9664", "\u5bfc\u51fa"};
    private String[] itemIcons = new String[]{"attris.png", "edit.png", "delete.png", "export.png"};
    private Map<String, JLabel> btns = new HashMap<String, JLabel>();
    private String[] btnNames = new String[]{"Course", "Paper", "Upload", "Pause", "Config", "About", "Exit"};
    private String[] btnTips = new String[]{"+\u8bfe\u7a0b", "+\u8bd5\u5377", "\u4e0a\u4f20", "\u6682\u505c", "\u8bbe\u7f6e", "\u5173\u4e8e", "\u9000\u51fa"};
    private String[] btnIcons = new String[]{"course.png", "paper.png", "upload.png", "pause.png", "config.png", "about.png", "exit.png"};
    private CourseRecorder courseRecorder = new CourseRecorder(this);
    private PaperEditor paperEditor = new PaperEditor(this);
    private ResourceGenerater resGenerater = new ResourceGenerater(this);
    private DataStorage storage = DataStorage.getInstance();
    private Map<String, Uploader> futures = new HashMap<String, Uploader>();
    private ExecutorService executor = Executors.newFixedThreadPool(3);

    static {
        keyboardHook = null;
    }

    public ResourceMaker() {
        try {
            this.storage.open();
            this.configs = this.storage.loadConfigs();
            this.resources = this.storage.loadResources();
            this.initComponents();
            this.autoUpload();
            Thread hook = new Thread(){

                @Override
                public void run() {
                    ResourceMaker.this.initHook();
                }
            };
            hook.setDaemon(true);
            hook.start();
            if (splash != null) {
                splash.setVisible(false);
                splash.dispose();
                splash = null;
            }
            String user = this.configs.get("user");
            String passwd = this.configs.get("passwd");
            int i = 3;
            boolean logined = false;
            do {
                try {
                    while (user == null || "".equals(user) || passwd == null || "".equals(passwd)) {
                        new ConfigDialog(this, this.configs);
                        this.configs = this.storage.loadConfigs();
                        user = this.configs.get("user");
                        passwd = this.configs.get("passwd");
                        if (--i > 0) continue;
                        String msg = "\u4f60\u5c1d\u8bd5\u4e863\u6b21, \u8f6f\u4ef6\u5207\u6362\u5230\u79bb\u7ebf\u6a21\u5f0f.";
                        JOptionPane.showMessageDialog(this, msg);
                        this.offline = true;
                        break;
                    }
                    if (this.offline) continue;
                    UrlConnectionTransport trans = new UrlConnectionTransport();
                    String keyFile = this.configs.get("dasKeystoreFile");
                    String keyPass = this.configs.get("dasKeystorePass");
                    String dasUrl = this.configs.get("dasPointEnd");
                    trans.setKeystore(keyFile, keyPass);
                    HttpRequestFactory factory = trans.createRequestFactory();
                    String dasEndPoint = String.valueOf(dasUrl) + "ecdas";
                    String client_id = "neuedu-cloud-resource-tools";
                    String callback_url = dasEndPoint;
                    String accessTokenUrl = OAuth2URL.getAccessTokenRequestUrl((String)dasEndPoint, (String)client_id, (String)callback_url);
                    String params = OAuth2Params.getParamsByPass((String)user, (String)passwd);
                    AccessTokenResponse tokenResponse = AccessTokenRequest.getAccessToken((HttpRequestFactory)factory, (String)accessTokenUrl, (String)params);
                    if (!tokenResponse.hasError) {
                        logined = true;
                        String org_ids = (String)tokenResponse.getProperty("org_ids");
                        String org_names = (String)tokenResponse.getProperty("org_names");
                        String last_version = (String)tokenResponse.getProperty("app_last_version");
                        if (last_version != null && !"".equals(last_version)) {
                            float iCV;
                            float iLV;
                            String version = this.configs.get("version");
                            if ("1.0.0".equals(version)) {
                                version = "1.0";
                            }
                            if ((iLV = Float.valueOf(last_version).floatValue()) > (iCV = Float.valueOf(version).floatValue())) {
                                JOptionPane.showMessageDialog(this, "\u53d1\u73b0\u6709\u6700\u65b0\u7248\u672c:v" + iLV + ", \u5177\u4f53\u8bf7\u67e5\u770bhttp://xue.neuedu.cn");
                            }
                        }
                        this.configs.put("org_ids", org_ids);
                        this.configs.put("org_names", org_names);
                        continue;
                    }
                    passwd = null;
                    logined = false;
                }
                catch (ApiException e) {
                    String msg = "\u65e0\u6cd5\u8fde\u63a5\u5230\u7b80\u5b66\u670d\u52a1, \u8f6f\u4ef6\u5207\u6362\u5230\u79bb\u7ebf\u6a21\u5f0f .";
                    JOptionPane.showMessageDialog(this, msg);
                    this.offline = true;
                }
            } while (!logined && !this.offline);
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public Map<String, String> getConfigs() {
        return this.configs;
    }

    private void autoUpload() {
        if (!this.offline) {
            for (Resource res : this.resources) {
                if (res.getStatus() != Resource.UPLOADING) continue;
                Uploader uploader = new Uploader(this.resList, this.configs, res);
                res.setStatus(Resource.WAINTING);
                this.resList.repaint();
                this.executor.submit(uploader);
                this.futures.put(res.getId(), uploader);
            }
        }
    }

    private void initHook() {
        int result;
        WinDef.HMODULE hMod = Kernel32.INSTANCE.GetModuleHandle(null);
        if ("true".equals(this.configs.get("course_record_keyboard_enable"))) {
            keyboardHook = new WinUser.LowLevelKeyboardProc(){

                public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, WinUser.KBDLLHOOKSTRUCT lParam) {
                    int w = wParam.intValue();
                    if (w == 257 || w == 261) {
                        if (lParam.vkCode == Integer.valueOf((String)ResourceMaker.this.configs.get("course_record_stop_key"))) {
                            new Thread(){

                                @Override
                                public void run() {
                                    ResourceMaker.this.courseRecorder.stopAudioRecord();
                                }
                            }.start();
                        } else if (lParam.vkCode == Integer.valueOf((String)ResourceMaker.this.configs.get("course_record_start_key"))) {
                            if (!ResourceMaker.this.paperEditor.isShow()) {
                                new Thread(){

                                    @Override
                                    public void run() {
                                        ResourceMaker.this.courseRecorder.show();
                                        ResourceMaker.this.courseRecorder.startOrPauseAudioRecord();
                                    }
                                }.start();
                            }
                        } else {
                            ResourceMaker.this.courseRecorder.captureScreenKeyUp();
                        }
                    } else if ((w == 256 || w == 260) && lParam.vkCode != Integer.valueOf((String)ResourceMaker.this.configs.get("course_record_stop_key")) && lParam.vkCode != Integer.valueOf((String)ResourceMaker.this.configs.get("course_record_start_key"))) {
                        ResourceMaker.this.courseRecorder.captureScreenKeyDown();
                    }
                    return ResourceMaker.this.lib.CallNextHookEx(keyboardhhk, nCode, wParam, lParam.getPointer());
                }
            };
            keyboardhhk = User32.INSTANCE.SetWindowsHookEx(13, (WinUser.HOOKPROC)keyboardHook, (WinDef.HINSTANCE)hMod, 0);
        }
        mouseHook = new LowLevelMouseProc(){

            @Override
            public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, WinUser.MOUSEINPUT lParam) {
                int point_x = lParam.dx.intValue();
                int point_y = lParam.dy.intValue();
                switch (wParam.intValue()) {
                    case 514: {
                        ResourceMaker.this.courseRecorder.captureScreenKeyUp(point_x, point_y);
                        break;
                    }
                    case 513: {
                        ResourceMaker.this.courseRecorder.captureScreenKeyDown(point_x, point_y);
                        break;
                    }
                }
                return User32.INSTANCE.CallNextHookEx(mousehhk, nCode, wParam, lParam.getPointer());
            }
        };
        mousehhk = User32.INSTANCE.SetWindowsHookEx(14, (WinUser.HOOKPROC)mouseHook, (WinDef.HINSTANCE)hMod, 0);
        WinUser.MSG msg = new WinUser.MSG();
        while ((result = this.lib.GetMessage(msg, null, 0, 0)) != 0) {
            LoggerDialog.logger(null, msg.toString());
            if (result == -1) break;
            this.lib.TranslateMessage(msg);
            this.lib.DispatchMessage(msg);
        }
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ResourceMaker.this.storage.close();
                ResourceMaker.this.lib.UnhookWindowsHookEx(mousehhk);
                if (keyboardhhk != null) {
                    ResourceMaker.this.lib.UnhookWindowsHookEx(keyboardhhk);
                }
                System.exit(0);
            }
        });
        this.setTitle("\u7b80\u5b66\u5fae\u8bfe\u5de5\u5177");
        this.setSize(640, 480);
        this.setResizable(false);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - 320, dimension.height / 2 - 240);
        ImageIcon imgicon = new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/logo.png"));
        this.setIconImage(imgicon.getImage());
        JScrollPane jScrollPane1 = new JScrollPane();
        this.resList = new JList<Resource>(this.resources);
        this.resList.setSelectionMode(0);
        this.resList.setCellRenderer(new ResourceCellRenderer());
        this.resList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ResourceMaker.this.onListValueChanged(evt);
            }
        });
        this.resList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    if (ResourceMaker.this.resList.getSelectedIndex() > -1) {
                        ((JMenuItem)ResourceMaker.this.items.get("Attris")).setEnabled(true);
                        ((JMenuItem)ResourceMaker.this.items.get("Preview")).setEnabled(true);
                        ((JMenuItem)ResourceMaker.this.items.get("Export")).setEnabled(true);
                        if (((Resource)ResourceMaker.this.resList.getSelectedValue()).deleteEnable()) {
                            ((JMenuItem)ResourceMaker.this.items.get("Delete")).setEnabled(true);
                        }
                    } else {
                        ((JMenuItem)ResourceMaker.this.items.get("Attris")).setEnabled(false);
                        ((JMenuItem)ResourceMaker.this.items.get("Preview")).setEnabled(false);
                        ((JMenuItem)ResourceMaker.this.items.get("Export")).setEnabled(false);
                        ((JMenuItem)ResourceMaker.this.items.get("Delete")).setEnabled(false);
                    }
                    ResourceMaker.this.popupMenu.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.isPopupTrigger()) {
                    if (ResourceMaker.this.resList.getSelectedIndex() > -1) {
                        ((JMenuItem)ResourceMaker.this.items.get("Attris")).setEnabled(true);
                        ((JMenuItem)ResourceMaker.this.items.get("Preview")).setEnabled(true);
                        ((JMenuItem)ResourceMaker.this.items.get("Export")).setEnabled(true);
                        if (((Resource)ResourceMaker.this.resList.getSelectedValue()).deleteEnable()) {
                            ((JMenuItem)ResourceMaker.this.items.get("Delete")).setEnabled(true);
                        }
                    } else {
                        ((JMenuItem)ResourceMaker.this.items.get("Attris")).setEnabled(false);
                        ((JMenuItem)ResourceMaker.this.items.get("Preview")).setEnabled(false);
                        ((JMenuItem)ResourceMaker.this.items.get("Delete")).setEnabled(false);
                        ((JMenuItem)ResourceMaker.this.items.get("Export")).setEnabled(false);
                    }
                    ResourceMaker.this.popupMenu.show(ev.getComponent(), ev.getX(), ev.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                int cc = ev.getClickCount();
                if (cc == 2) {
                    ResourceMaker.this.onListDoubleClicked(ev);
                }
            }
        });
        jScrollPane1.setViewportView(this.resList);
        this.getContentPane().add((Component)jScrollPane1, "Center");
        int i = 0;
        while (i < this.btnNames.length) {
            JLabel jbutton = new JLabel();
            jbutton.setPreferredSize(new Dimension(20, 20));
            jbutton.setSize(20, 20);
            jbutton.setFocusable(false);
            jbutton.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/" + this.btnIcons[i])));
            jbutton.setToolTipText(this.btnTips[i]);
            jbutton.setName(this.btnNames[i]);
            jbutton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    ResourceMaker.this.onButtonClicked(e);
                }
            });
            this.btns.put(this.btnNames[i], jbutton);
            ++i;
        }
        this.btns.get("Upload").setEnabled(false);
        this.btns.get("Pause").setEnabled(false);
        this.btns.get("Paper").setEnabled(false);
        JPanel cmdPanel = new JPanel();
        cmdPanel.setLayout(new BorderLayout());
        JPanel leftCmds = new JPanel();
        leftCmds.add(this.btns.get("Course"));
        leftCmds.add(this.btns.get("Paper"));
        cmdPanel.add((Component)leftCmds, "West");
        JPanel rightCmds = new JPanel();
        int i2 = 2;
        while (i2 < this.btnNames.length) {
            rightCmds.add(this.btns.get(this.btnNames[i2]));
            ++i2;
        }
        cmdPanel.add((Component)rightCmds, "East");
        this.getContentPane().add((Component)cmdPanel, "South");
        i2 = 0;
        while (i2 < this.itemNames.length) {
            JMenuItem item = new JMenuItem(this.itemTexts[i2]);
            item.setEnabled(false);
            item.setName(this.itemNames[i2]);
            item.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/" + this.itemIcons[i2])));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResourceMaker.this.onPopupItemClicked(e);
                }
            });
            this.items.put(this.itemNames[i2], item);
            this.popupMenu.add(item);
            ++i2;
        }
        JPanel right = new JPanel();
        right.setSize(100, 480);
        JLabel pLabel = new JLabel();
        pLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/neuedu/educloud/tools/images/jianxue.png")));
        right.add(pLabel);
        this.getContentPane().add((Component)right, "East");
        this.setExtendedState(0);
        this.setVisible(true);
    }

    private void onPopupItemClicked(ActionEvent evt) {
        JMenuItem item = (JMenuItem)evt.getSource();
        String name = item.getName();
        if (name.equals("Delete")) {
            Object obj = this.resList.getSelectedValue();
            Resource res = (Resource)obj;
            this.storage.deleteResource(res.getId());
            this.resGenerater.remove(res.getId());
            this.resources.remove(res);
            this.resList.clearSelection();
            this.resList.updateUI();
        } else if (name.equals("Attris")) {
            Object obj = this.resList.getSelectedValue();
            Resource res = (Resource)obj;
            this.editResource(res);
        } else if (name.equals("Preview")) {
            Object obj = this.resList.getSelectedValue();
            Resource res = (Resource)obj;
            if (Resource.COURSE_TYPE == res.getType()) {
                JOptionPane.showMessageDialog(this, "\u6682\u4e0d\u652f\u6301\u8bfe\u7a0b\u7f16\u8f91\u3002");
            } else {
                this.paperEditor.editPaper(res);
            }
        } else if (name.equals("Export")) {
            Object obj = this.resList.getSelectedValue();
            Resource res = (Resource)obj;
            new ScormExport(this, res);
        }
    }

    private void onListDoubleClicked(MouseEvent evt) {
        Object obj = this.resList.getSelectedValue();
        Resource res = (Resource)obj;
        if (Resource.COURSE_TYPE == res.getType()) {
            new CoursePlayer(res);
        } else {
            JOptionPane.showMessageDialog(this, "\u6682\u4e0d\u652f\u6301\u8bd5\u5377\u9884\u89c8\u3002");
        }
    }

    private void onButtonClicked(MouseEvent evt) {
        JLabel btn = (JLabel)evt.getSource();
        String name = btn.getName();
        if (name.equals("Upload") && !this.offline) {
            Resource res = (Resource)this.resList.getSelectedValue();
            this.btns.get("Upload").setEnabled(false);
            this.btns.get("Pause").setEnabled(true);
            Uploader uploader = new Uploader(this.resList, this.configs, res);
            res.setStatus(Resource.WAINTING);
            this.resList.repaint();
            this.executor.submit(uploader);
            this.futures.put(res.getId(), uploader);
        } else if (name.equals("Pause") && !this.offline) {
            Resource res = (Resource)this.resList.getSelectedValue();
            this.btns.get("Upload").setEnabled(true);
            this.btns.get("Pause").setEnabled(false);
            Uploader uploader = this.futures.get(res.getId());
            if (uploader != null) {
                uploader.pause();
                this.futures.remove(res.getId());
            }
            if (res.getSended() != res.getLength()) {
                res.setStatus(Resource.PAUSE);
                this.resList.repaint();
            }
            this.resList.repaint();
        } else if (name.equals("Course")) {
            this.courseRecorder.show();
        } else if (!name.equals("Paper")) {
            if (name.equals("Config")) {
                new ConfigDialog(this, this.configs);
                this.configs = this.storage.loadConfigs();
            } else if (name.equals("About")) {
                JOptionPane.showMessageDialog(this, "\u7b80\u5b66\u5fae\u8bfe\u5de5\u5177\uff0c \u7248\u672c" + this.configs.get("version"), "\u5173\u4e8e", 1);
            } else if (name.equals("Exit")) {
                this.storage.close();
                this.lib.UnhookWindowsHookEx(mousehhk);
                if (keyboardhhk != null) {
                    this.lib.UnhookWindowsHookEx(keyboardhhk);
                }
                System.exit(0);
            }
        }
    }

    private void onListValueChanged(ListSelectionEvent evt) {
        JList lst = (JList)evt.getSource();
        Resource res = (Resource)lst.getSelectedValue();
        if (res == null || this.offline) {
            this.btns.get("Upload").setEnabled(false);
            this.btns.get("Pause").setEnabled(false);
            return;
        }
        int status = res.getStatus();
        if (status == Resource.UPLOADING || status == Resource.PACKAGING || status == Resource.WAINTING) {
            this.btns.get("Upload").setEnabled(false);
            this.btns.get("Pause").setEnabled(true);
        } else if (status == Resource.PAUSE || status == Resource.ERROR) {
            this.btns.get("Upload").setEnabled(true);
            this.btns.get("Pause").setEnabled(false);
        } else if (status == Resource.SAVED) {
            this.btns.get("Upload").setEnabled(true);
            this.btns.get("Pause").setEnabled(false);
        } else if (status == Resource.UPLOADED) {
            this.btns.get("Upload").setEnabled(true);
            this.btns.get("Pause").setEnabled(false);
        }
    }

    public void generateResource(Resource res) {
        this.resGenerater.generate(res, this.configs);
        if (res.getName() != null) {
            this.storage.insertResources(res);
            this.resources.add(0, res);
            this.resList.updateUI();
        }
    }

    public void refreshResource(Resource res) {
        this.storage.updateResources(res);
        this.resList.updateUI();
    }

    public void editResource(Resource res) {
        new ResouceAttributes(this, res);
        if (res.getName() != null) {
            this.storage.updateResources(res);
            int index = this.resList.getSelectedIndex();
            this.resources.set(index, res);
            this.resList.updateUI();
        }
    }

    public static void main(String[] args) {
        try {
            BufferedImage image = ImageIO.read(ResourceMaker.class.getResourceAsStream("/com/neuedu/educloud/tools/images/welcome.png"));
            splash = new SplashWindow(image);
            splash.setVisible(true);
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ResourceMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(ResourceMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(ResourceMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(ResourceMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            Logger.getLogger(ResourceMaker.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ResourceMaker().setVisible(true);
            }
        });
    }

    static interface LowLevelMouseProc
    extends WinUser.HOOKPROC {
        public WinDef.LRESULT callback(int var1, WinDef.WPARAM var2, WinUser.MOUSEINPUT var3);
    }
}

