/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.codec.microcourse;

import com.neuedu.educloud.codec.CodecException;
import com.neuedu.educloud.codec.ResourceEncoder;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

public final class MCFileEncoder
implements ResourceEncoder {
    private RandomAccessFile mcf = null;
    private File audio = null;
    private File times = null;
    private List<File> images = new ArrayList<File>();
    private int status = -1;

    public MCFileEncoder(String filename) throws Exception {
        this(new File(filename));
    }

    public MCFileEncoder(File file) throws Exception {
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        this.mcf = new RandomAccessFile(file, "rw");
        this.status = 0;
    }

    @Override
    public void add(String filename) throws Exception {
        File file = new File(filename);
        this.add(file);
    }

    @Override
    public void add(File file) throws Exception {
        String fname = file.getName().toLowerCase();
        if (this.status != 0) {
            throw new CodecException("\u6587\u4ef6\u72b6\u6001\u9519\u8bef.");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(String.valueOf(fname) + ",\u8be5\u6587\u4ef6\u4e0d\u5b58\u5728.");
        }
        if (fname.equals("audio.mp3")) {
            this.audio = file;
        } else if (fname.equals("time.txt")) {
            this.times = file;
        } else if (fname.endsWith(".jpg")) {
            this.images.add(file);
        } else {
            throw new CodecException(String.valueOf(fname) + ",\u8be5\u6587\u4ef6\u4e0d\u7b26\u5408\u7f16\u7801\u8981\u6c42.");
        }
    }

    @Override
    public void encode() throws Exception {
        InputStream is_audio = null;
        InputStream is_image = null;
        try {
            if (this.status != 0) {
                throw new CodecException("\u6587\u4ef6\u72b6\u6001\u9519\u8bef.");
            }
            if (this.images.size() == 0) {
                throw new CodecException("\u7f3a\u5c11\u8d44\u6e90\u6587\u4ef6\u9519\u8bef.");
            }
            if (this.audio == null) {
                throw new CodecException("\u7f3a\u5c11\u97f3\u9891\u6587\u4ef6\u9519\u8bef.");
            }
            if (this.times == null) {
                throw new CodecException("\u7f3a\u5c11\u65f6\u95f4\u70b9\u6587\u4ef6\u9519\u8bef.");
            }
            this.status = 5;
            int imgNum = this.images.size();
            long index_sizes = 4 + imgNum * 4 + 4 + imgNum * 8;
            long audio_sizes = this.audio.length();
            long audio_off = 12L + index_sizes;
            long images_off = audio_off + audio_sizes;
            this.mcf.writeInt(-1177087);
            this.mcf.writeShort(1);
            this.mcf.writeShort(0);
            this.mcf.writeInt(imgNum);
            this.mcf.writeInt(-1176831);
            int[] ts = this.readTimes();
            if (ts.length != this.images.size()) {
                throw new CodecException("\u65f6\u95f4\u70b9\u6570\u91cf\u4e0e\u56fe\u7247\u6570\u91cf\u4e0d\u5339\u914d\u9519\u8bef.");
            }
            Object object = ts;
            int n = ts.length;
            int n2 = 0;
            while (n2 < n) {
                int t = object[n2];
                this.mcf.writeInt(t);
                ++n2;
            }
            this.mcf.writeInt(-1176831);
            long offsize = images_off;
            object = this.images.iterator();
            while (object.hasNext()) {
                File img = (File)object.next();
                this.mcf.writeLong(offsize);
                long filesize = img.length();
                offsize += filesize;
            }
            byte[] buf = new byte[4096];
            int r = 0;
            is_audio = new DataInputStream(new BufferedInputStream(new FileInputStream(this.audio)));
            while ((r = is_audio.read(buf)) > 0) {
                this.mcf.write(buf, 0, r);
            }
            is_audio.close();
            for (File img : this.images) {
                r = 0;
                is_image = new DataInputStream(new BufferedInputStream(new FileInputStream(img)));
                while ((r = is_image.read(buf)) > 0) {
                    this.mcf.write(buf, 0, r);
                }
                is_image.close();
            }
            this.status = 9;
        }
        finally {
            if (is_audio != null) {
                is_audio.close();
            }
            if (is_image != null) {
                is_image.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mcf != null) {
            this.mcf.close();
        }
    }

    private int[] readTimes() throws IOException {
        int[] times = null;
        FilterInputStream reader = null;
        try {
            reader = new DataInputStream(new FileInputStream(this.times));
            String tt = ((DataInputStream)reader).readLine();
            String[] tps = tt.split(",");
            times = new int[tps.length];
            int i = 0;
            while (i < tps.length) {
                times[i] = Integer.parseInt(tps[i]);
                ++i;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return times;
    }
}

