/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.codec.microcourse;

import com.neuedu.educloud.codec.CodecException;
import com.neuedu.educloud.codec.FileDescriptorInput;
import com.neuedu.educloud.codec.ResourceDecoder;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class MCFileDecoder
implements ResourceDecoder {
    private RandomAccessFile mcf = null;
    private File mcfile = null;
    private int status = -1;
    private int img_num;
    private int[] tps = null;
    private long[] imgs_offset = null;
    private long file_size = 0L;
    private long audio_offset;
    private long audio_length;

    public MCFileDecoder(String filename) throws Exception {
        this(new File(filename));
    }

    public MCFileDecoder(File file) throws Exception {
        if (!file.exists()) {
            throw new Exception("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.mcfile = file;
        this.file_size = this.mcfile.length();
        this.mcf = new RandomAccessFile(this.mcfile, "r");
        this.status = 0;
    }

    @Override
    public FileDescriptorInput get(String name) throws CodecException {
        if (this.status != 9) {
            throw new CodecException("\u6587\u4ef6\u72b6\u6001\u9519\u8bef.");
        }
        FileDescriptorInput fdi = null;
        if (name.equals("audio.mp3")) {
            fdi = new FileDescriptorInput(this.mcfile, this.audio_offset, this.audio_length);
        } else if (name.endsWith(".jpg")) {
            String seq = name.substring(0, name.indexOf(46));
            int img_seq = Integer.valueOf(seq);
            long img_offset = this.imgs_offset[img_seq - 1];
            long img_length = (img_seq >= this.imgs_offset.length ? this.file_size : this.imgs_offset[img_seq]) - img_offset;
            fdi = new FileDescriptorInput(this.mcfile, img_offset, img_length);
        } else {
            throw new CodecException("\u540d\u79f0\u4e0d\u5b58\u5728.");
        }
        return fdi;
    }

    @Override
    public String[] names() throws CodecException {
        if (this.status != 9) {
            throw new CodecException("\u6587\u4ef6\u72b6\u6001\u9519\u8bef.");
        }
        String[] nms = new String[this.img_num + 1];
        nms[0] = "audio.mp3";
        int i = 1;
        while (i < nms.length) {
            nms[i] = String.valueOf(i) + ".jpg";
            ++i;
        }
        return nms;
    }

    @Override
    public int[] times() throws CodecException {
        if (this.status != 9) {
            throw new CodecException("\u6587\u4ef6\u72b6\u6001\u9519\u8bef.");
        }
        return this.tps;
    }

    @Override
    public void decode() throws CodecException {
        try {
            if (this.status != 0) {
                throw new CodecException("\u6587\u4ef6\u72b6\u6001\u9519\u8bef.");
            }
            this.status = 5;
            int file_magic = this.mcf.readInt();
            short format_version = this.mcf.readShort();
            short format_sub_version = this.mcf.readShort();
            this.img_num = this.mcf.readInt();
            if (file_magic != -1177087 || format_version != 1) {
                throw new CodecException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef.");
            }
            int index_magic_1 = this.mcf.readInt();
            if (index_magic_1 != -1176831) {
                throw new CodecException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef.");
            }
            this.tps = new int[this.img_num];
            int i = 0;
            while (i < this.img_num) {
                this.tps[i] = this.mcf.readInt();
                ++i;
            }
            int index_magic_2 = this.mcf.readInt();
            if (index_magic_2 != -1176831) {
                throw new CodecException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef.");
            }
            this.imgs_offset = new long[this.img_num];
            int i2 = 0;
            while (i2 < this.img_num) {
                this.imgs_offset[i2] = this.mcf.readLong();
                ++i2;
            }
            long index_sizes = 4 + this.img_num * 4 + 4 + this.img_num * 8;
            this.audio_offset = 12L + index_sizes;
            this.audio_length = this.imgs_offset[0] - this.audio_offset;
            this.status = 9;
        }
        catch (Exception e) {
            throw new CodecException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mcf != null) {
            this.mcf.close();
        }
    }

    @Override
    public byte[] titlePage() throws CodecException {
        byte[] pageImg;
        block5: {
            pageImg = null;
            try {
                if (this.status == 9) {
                    FileDescriptorInput fdi = this.get("1.jpg");
                    pageImg = fdi.readAll();
                    break block5;
                }
                if (this.status == 0) {
                    int file_magic = this.mcf.readInt();
                    short format_version = this.mcf.readShort();
                    short format_sub_version = this.mcf.readShort();
                    int imgNum = this.mcf.readInt();
                    if (file_magic != -1177087 || format_version != 1) {
                        throw new CodecException("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef.");
                    }
                    this.mcf.skipBytes((imgNum + 1) * 4);
                    this.mcf.skipBytes(4);
                    long offset1 = this.mcf.readLong();
                    long offset2 = this.mcf.readLong();
                    FileDescriptorInput fdi = new FileDescriptorInput(this.mcfile, offset1, offset2 - offset1);
                    pageImg = fdi.readAll();
                    break block5;
                }
                throw new CodecException("\u6587\u4ef6\u72b6\u6001\u9519\u8bef.");
            }
            catch (IOException e) {
                throw new CodecException(e);
            }
        }
        return pageImg;
    }
}

