/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.codec.microcourse;

import com.neuedu.educloud.codec.FileDescriptorInput;
import com.neuedu.educloud.codec.microcourse.MCFileDecoder;
import com.neuedu.educloud.codec.microcourse.MCFileEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;

public final class MCFileBuilder {
    public static final void pack(String fromdir, String tofile) throws Exception {
        MCFileEncoder encoder = null;
        try {
            File dir = new File(fromdir);
            if (!dir.exists()) {
                throw new Exception(String.valueOf(fromdir) + "\uff0c\u8be5\u6587\u4ef6\u5939\u4e0d\u5b58\u5728.");
            }
            encoder = new MCFileEncoder(tofile);
            if (!fromdir.endsWith("/")) {
                fromdir = String.valueOf(fromdir) + "/";
            }
            File audiofile = new File(String.valueOf(fromdir) + "audio.mp3");
            File timefile = new File(String.valueOf(fromdir) + "time.txt");
            int imgNum = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jpg");
                }
            }).length;
            encoder.add(audiofile);
            encoder.add(timefile);
            int i = 1;
            while (i <= imgNum) {
                encoder.add(String.valueOf(fromdir) + i + ".jpg");
                ++i;
            }
            encoder.encode();
        }
        finally {
            if (encoder != null) {
                encoder.close();
            }
        }
    }

    public static final void unpack(String fromfile, String todir) throws Exception {
        MCFileDecoder decoder = null;
        FileOutputStream ftimesfos = null;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            String[] names;
            File ff = new File(fromfile);
            if (!ff.exists()) {
                throw new Exception(ff + "\uff0c\u8be5\u6587\u4ef6\u4e0d\u5b58\u5728.");
            }
            decoder = new MCFileDecoder(fromfile);
            if (!todir.endsWith("/")) {
                todir = String.valueOf(todir) + "/";
            }
            File dir = new File(todir);
            dir.mkdirs();
            decoder.decode();
            int[] times = decoder.times();
            StringBuffer sb = new StringBuffer();
            sb.append(times[0]);
            int i = 1;
            while (i < times.length) {
                sb.append(',').append(times[i]);
                ++i;
            }
            File ftimes = new File(String.valueOf(todir) + "/" + "time.txt");
            ftimes.createNewFile();
            ftimesfos = new FileOutputStream(ftimes);
            ftimesfos.write(sb.toString().getBytes("utf-8"));
            ftimesfos.flush();
            String[] stringArray = names = decoder.names();
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                FileDescriptorInput input = decoder.get(name);
                File f = new File(String.valueOf(todir) + "/" + name);
                f.createNewFile();
                fos = new FileOutputStream(f);
                fis = new FileInputStream(input.getFD());
                fis.skip(input.getOffset());
                byte[] buf = null;
                long lastw = input.getLength();
                while (lastw > 0L) {
                    buf = lastw > 4096L ? new byte[4096] : new byte[Long.valueOf(lastw).intValue()];
                    fis.read(buf);
                    fos.write(buf);
                    lastw -= (long)buf.length;
                    fos.flush();
                }
                fis.close();
                fis = null;
                fos.close();
                fos = null;
                ++n2;
            }
        }
        finally {
            if (ftimesfos != null) {
                ftimesfos.close();
            }
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (decoder != null) {
                decoder.close();
            }
        }
    }
}

