/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.codec;

import com.neuedu.educloud.codec.CodecInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileDescriptorInput {
    private File provider = null;
    private FileInputStream fdin = null;
    private long offset = 0L;
    private long length = 0L;

    public FileDescriptorInput(File provider, long offset, long length) {
        this.provider = provider;
        this.offset = offset;
        this.length = length;
    }

    public final FileDescriptor getFD() throws IOException {
        if (this.fdin == null) {
            this.fdin = new FileInputStream(this.provider);
        }
        return this.fdin.getFD();
    }

    public final InputStream getInputStream() throws Exception {
        CodecInputStream is = new CodecInputStream(this.provider, this.offset, this.length);
        return is;
    }

    public final long getOffset() {
        return this.offset;
    }

    public final long getLength() {
        return this.length;
    }

    public final void closeFD() throws IOException {
        if (this.fdin != null) {
            this.fdin.close();
        }
    }

    public final byte[] readAll() throws IOException {
        int len = Long.valueOf(this.length).intValue();
        byte[] buf = new byte[len];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.provider);
            fis.skip(this.offset);
            fis.read(buf);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return buf;
    }
}

