/*
 * Decompiled with CFR 0.152.
 */
package com.neuedu.educloud.codec;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CodecInputStream
extends InputStream {
    private FileInputStream fis = null;
    private long offset = 0L;
    private long length = 0L;
    private int last = 0;
    private long mark = -1L;

    public CodecInputStream(File provider, long offset, long length) throws Exception {
        this.fis = new FileInputStream(provider);
        this.fis.skip(offset);
        this.offset = offset;
        this.length = length;
        this.last = Long.valueOf(this.length).intValue();
    }

    @Override
    public int read() throws IOException {
        if (this.last <= 0) {
            return -1;
        }
        int i = this.fis.read();
        --this.last;
        return i;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.last <= 0) {
            return -1;
        }
        int r = this.fis.read(b);
        if (this.last > r) {
            this.last -= r;
        } else {
            r = this.last;
            this.last = 0;
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.last <= 0) {
            return -1;
        }
        int r = this.fis.read(b, off, len);
        if (this.last > r) {
            this.last -= r;
        } else {
            r = this.last;
            this.last = 0;
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }

    @Override
    public int available() throws IOException {
        return Long.valueOf(this.length).intValue();
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }
}

