/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis.vorbis_constants;

public class integer_constants {
    public static final int PACKETBLOBS = 15;
    public static final int NOISE_COMPAND_LEVELS = 40;
    public static final int P_BANDS = 17;
    public static final int P_LEVELS = 8;
    public static final int P_LEVEL_0 = 30;
    public static final int P_NOISECURVES = 3;
    public static final int VQ_FEXP = 10;
    public static final int VQ_FMAN = 21;
    public static final int VQ_FEXP_BIAS = 768;
    public static final int MAX_ATH = 88;
    public static final int EHMER_OFFSET = 16;
    public static final int EHMER_MAX = 56;
    public static final int VE_PRE = 16;
    public static final int VE_WIN = 4;
    public static final int VE_POST = 2;
    public static final int VE_AMP = 17;
    public static final int VE_BANDS = 7;
    public static final int VE_NEARDC = 15;
    public static final int VE_MINSTRETCH = 2;
    public static final int VE_MAXSTRETCH = 12;
    public static final int BLOCKTYPE_IMPULSE = 0;
    public static final int BLOCKTYPE_PADDING = 1;
    public static final int BLOCKTYPE_TRANSITION = 0;
    public static final int BLOCKTYPE_LONG = 1;
    public static final int WORD_ALIGN = 8;
    public static final int VIF_POSIT = 63;
    public static final int VIF_CLASS = 16;
    public static final int VIF_PARTS = 31;
    public static final int VI_TRANSFORMB = 1;
    public static final int VI_WINDOWB = 1;
    public static final int VI_TIMEB = 1;
    public static final int VI_FLOORB = 2;
    public static final int VI_RESB = 3;
    public static final int VI_MAPB = 1;
    public static final float cPI3_8 = 0.38268343f;
    public static final float cPI2_8 = 0.70710677f;
    public static final float cPI1_8 = 0.9238795f;
    public static final float M_PI = (float)Math.PI;
    public static final int BUFFER_INCREMENT = 256;
    public static final float NEGINF = -9999.0f;
    public static float[] stereo_threshholds = new float[]{0.0f, 0.5f, 1.0f, 1.5f, 2.5f, 4.5f, 8.5f, 16.5f, 9.0E10f};
    public static float[] stereo_threshholds_limited = new float[]{0.0f, 0.5f, 1.0f, 1.5f, 2.0f, 2.5f, 4.5f, 8.5f, 9.0E10f};
    public static final int OV_FALSE = -1;
    public static final int OV_EOF = -2;
    public static final int OV_HOLE = -3;
    public static final int OV_EREAD = -128;
    public static final int OV_EFAULT = -129;
    public static final int OV_EIMPL = -130;
    public static final int OV_EINVAL = -131;
    public static final int OV_ENOTVORBIS = -132;
    public static final int OV_EBADHEADER = -133;
    public static final int OV_EVERSION = -134;
    public static final int OV_ENOTAUDIO = -135;
    public static final int OV_EBADPACKET = -136;
    public static final int OV_EBADLINK = -137;
    public static final int OV_ENOSEEK = -138;
    public static final int OV_ECTL_RATEMANAGE_GET = 16;
    public static final int OV_ECTL_RATEMANAGE_SET = 17;
    public static final int OV_ECTL_RATEMANAGE_AVG = 18;
    public static final int OV_ECTL_RATEMANAGE_HARD = 19;
    public static final int OV_ECTL_RATEMANAGE2_GET = 20;
    public static final int OV_ECTL_RATEMANAGE2_SET = 21;
    public static final int OV_ECTL_LOWPASS_GET = 32;
    public static final int OV_ECTL_LOWPASS_SET = 33;
    public static final int OV_ECTL_IBLOCK_GET = 48;
    public static final int OV_ECTL_IBLOCK_SET = 49;
    public static float[] FLOOR1_fromdB_LOOKUP = new float[]{1.0649863E-7f, 1.1341951E-7f, 1.2079015E-7f, 1.2863978E-7f, 1.369995E-7f, 1.459025E-7f, 1.5538409E-7f, 1.6548181E-7f, 1.7623574E-7f, 1.8768856E-7f, 1.998856E-7f, 2.128753E-7f, 2.2670913E-7f, 2.4144197E-7f, 2.5713223E-7f, 2.7384212E-7f, 2.9163792E-7f, 3.1059022E-7f, 3.307741E-7f, 3.5226967E-7f, 3.7516213E-7f, 3.995423E-7f, 4.255068E-7f, 4.5315863E-7f, 4.8260745E-7f, 5.1397E-7f, 5.4737063E-7f, 5.829419E-7f, 6.208247E-7f, 6.611694E-7f, 7.041359E-7f, 7.4989464E-7f, 7.98627E-7f, 8.505263E-7f, 9.057983E-7f, 9.646621E-7f, 1.0273513E-6f, 1.0941144E-6f, 1.1652161E-6f, 1.2409384E-6f, 1.3215816E-6f, 1.4074654E-6f, 1.4989305E-6f, 1.5963394E-6f, 1.7000785E-6f, 1.8105592E-6f, 1.9282195E-6f, 2.053526E-6f, 2.1869757E-6f, 2.3290977E-6f, 2.4804558E-6f, 2.6416496E-6f, 2.813319E-6f, 2.9961443E-6f, 3.1908505E-6f, 3.39821E-6f, 3.619045E-6f, 3.8542307E-6f, 4.1047006E-6f, 4.371447E-6f, 4.6555283E-6f, 4.958071E-6f, 5.280274E-6f, 5.623416E-6f, 5.988857E-6f, 6.3780467E-6f, 6.7925284E-6f, 7.2339453E-6f, 7.704048E-6f, 8.2047E-6f, 8.737888E-6f, 9.305725E-6f, 9.910464E-6f, 1.0554501E-5f, 1.1240392E-5f, 1.1970856E-5f, 1.2748789E-5f, 1.3577278E-5f, 1.4459606E-5f, 1.5399271E-5f, 1.6400005E-5f, 1.7465769E-5f, 1.8600793E-5f, 1.9809577E-5f, 2.1096914E-5f, 2.2467912E-5f, 2.3928002E-5f, 2.5482977E-5f, 2.7139005E-5f, 2.890265E-5f, 3.078091E-5f, 3.2781227E-5f, 3.4911533E-5f, 3.718028E-5f, 3.9596467E-5f, 4.2169668E-5f, 4.491009E-5f, 4.7828602E-5f, 5.0936775E-5f, 5.424693E-5f, 5.7772202E-5f, 6.152657E-5f, 6.552491E-5f, 6.9783084E-5f, 7.4317984E-5f, 7.914758E-5f, 8.429104E-5f, 8.976875E-5f, 9.560242E-5f, 1.0181521E-4f, 1.0843174E-4f, 1.1547824E-4f, 1.2298267E-4f, 1.3097477E-4f, 1.3948625E-4f, 1.4855085E-4f, 1.5820454E-4f, 1.6848555E-4f, 1.7943469E-4f, 1.9109536E-4f, 2.0351382E-4f, 2.167393E-4f, 2.3082423E-4f, 2.4582449E-4f, 2.6179955E-4f, 2.7881275E-4f, 2.9693157E-4f, 3.1622787E-4f, 3.3677815E-4f, 3.5866388E-4f, 3.8197188E-4f, 4.0679457E-4f, 4.3323037E-4f, 4.613841E-4f, 4.913675E-4f, 5.2329927E-4f, 5.573062E-4f, 5.935231E-4f, 6.320936E-4f, 6.731706E-4f, 7.16917E-4f, 7.635063E-4f, 8.1312325E-4f, 8.6596457E-4f, 9.2223985E-4f, 9.821722E-4f, 0.0010459992f, 0.0011139743f, 0.0011863665f, 0.0012634633f, 0.0013455702f, 0.0014330129f, 0.0015261382f, 0.0016253153f, 0.0017309374f, 0.0018434235f, 0.0019632196f, 0.0020908006f, 0.0022266726f, 0.0023713743f, 0.0025254795f, 0.0026895993f, 0.0028643848f, 0.0030505287f, 0.003248769f, 0.0034598925f, 0.0036847359f, 0.0039241905f, 0.0041792067f, 0.004450795f, 0.004740033f, 0.005048067f, 0.0053761187f, 0.005725489f, 0.0060975635f, 0.0064938175f, 0.0069158226f, 0.0073652514f, 0.007843887f, 0.008353627f, 0.008896492f, 0.009474637f, 0.010090352f, 0.01074608f, 0.011444421f, 0.012188144f, 0.012980198f, 0.013823725f, 0.014722068f, 0.015678791f, 0.016697686f, 0.017782796f, 0.018938422f, 0.020169148f, 0.021479854f, 0.022875736f, 0.02436233f, 0.025945531f, 0.027631618f, 0.029427277f, 0.031339627f, 0.03337625f, 0.035545226f, 0.037855156f, 0.0403152f, 0.042935107f, 0.045725275f, 0.048696756f, 0.05186135f, 0.05523159f, 0.05882085f, 0.062643364f, 0.06671428f, 0.07104975f, 0.075666964f, 0.08058423f, 0.08582105f, 0.09139818f, 0.097337745f, 0.1036633f, 0.11039993f, 0.11757434f, 0.12521498f, 0.13335215f, 0.14201812f, 0.15124726f, 0.16107617f, 0.1715438f, 0.18269168f, 0.19456401f, 0.20720787f, 0.22067343f, 0.23501402f, 0.25028655f, 0.26655158f, 0.28387362f, 0.3023213f, 0.32196787f, 0.34289113f, 0.36517414f, 0.3889052f, 0.41417846f, 0.44109413f, 0.4697589f, 0.50028646f, 0.53279793f, 0.5674221f, 0.6042964f, 0.64356697f, 0.6853896f, 0.72993004f, 0.777365f, 0.8278826f, 0.88168305f, 0.9389798f, 1.0f};
    public static float[] FLOOR1_fromdB_INV_LOOKUP = new float[]{0.0f, 8816830.0f, 8278820.0f, 7773650.0f, 7299300.0f, 6853890.0f, 6435670.0f, 6042960.0f, 5674220.0f, 5327980.0f, 5002860.0f, 4697590.0f, 4410940.0f, 4141780.0f, 3889050.0f, 3651740.0f, 3428910.0f, 3219680.0f, 3023210.0f, 2838730.0f, 2665510.0f, 2502860.0f, 2350140.0f, 2206730.0f, 2072080.0f, 1945640.0f, 1826920.0f, 1715440.0f, 1610760.0f, 1512470.0f, 1420180.0f, 1333520.0f, 1252150.0f, 1175740.0f, 1104000.0f, 1036630.0f, 973377.0f, 913981.0f, 858210.0f, 805842.0f, 756669.0f, 710497.0f, 667142.0f, 626433.0f, 588208.0f, 552316.0f, 518613.0f, 486967.0f, 457252.0f, 429351.0f, 403152.0f, 378551.0f, 355452.0f, 333762.0f, 313396.0f, 294273.0f, 276316.0f, 259455.0f, 243623.0f, 228757.0f, 214798.0f, 201691.0f, 189384.0f, 177828.0f, 166977.0f, 156788.0f, 147221.0f, 138237.0f, 129802.0f, 121881.0f, 114444.0f, 107461.0f, 100903.0f, 94746.3f, 88964.9f, 83536.2f, 78438.8f, 73652.5f, 69158.2f, 64938.1f, 60975.6f, 57254.9f, 53761.2f, 50480.6f, 47400.3f, 44507.9f, 41792.0f, 39241.9f, 36847.3f, 34598.9f, 32487.7f, 30505.3f, 28643.8f, 26896.0f, 25254.8f, 23713.7f, 22266.7f, 20908.0f, 19632.2f, 18434.2f, 17309.4f, 16253.1f, 15261.4f, 14330.1f, 13455.7f, 12634.6f, 11863.7f, 11139.7f, 10460.0f, 9821.72f, 9222.39f, 8659.64f, 8131.23f, 7635.06f, 7169.17f, 6731.7f, 6320.93f, 5935.23f, 5573.06f, 5232.99f, 4913.67f, 4613.84f, 4332.3f, 4067.94f, 3819.72f, 3586.64f, 3367.78f, 3162.28f, 2969.31f, 2788.13f, 2617.99f, 2458.24f, 2308.24f, 2167.39f, 2035.14f, 1910.95f, 1794.35f, 1684.85f, 1582.04f, 1485.51f, 1394.86f, 1309.75f, 1229.83f, 1154.78f, 1084.32f, 1018.15f, 956.024f, 897.687f, 842.91f, 791.475f, 743.179f, 697.83f, 655.249f, 615.265f, 577.722f, 542.469f, 509.367f, 478.286f, 449.101f, 421.696f, 395.964f, 371.803f, 349.115f, 327.812f, 307.809f, 289.026f, 271.39f, 254.83f, 239.28f, 224.679f, 210.969f, 198.096f, 186.008f, 174.658f, 164.0f, 153.993f, 144.596f, 135.773f, 127.488f, 119.708f, 112.404f, 105.545f, 99.1046f, 93.0572f, 87.3788f, 82.0469f, 77.0404f, 72.3394f, 67.9252f, 63.7804f, 59.8885f, 56.2341f, 52.8027f, 49.5807f, 46.5553f, 43.7144f, 41.047f, 38.5423f, 36.1904f, 33.9821f, 31.9085f, 29.9614f, 28.1332f, 26.4165f, 24.8045f, 23.291f, 21.8697f, 20.5352f, 19.2822f, 18.1056f, 17.0008f, 15.9634f, 14.9893f, 14.0746f, 13.2158f, 12.4094f, 11.6522f, 10.9411f, 10.2735f, 9.64662f, 9.05798f, 8.50526f, 7.98626f, 7.49894f, 7.04135f, 6.61169f, 6.20824f, 5.82941f, 5.4737f, 5.1397f, 4.82607f, 4.53158f, 4.25507f, 3.99542f, 3.75162f, 3.52269f, 3.30774f, 3.1059f, 2.91638f, 2.73842f, 2.57132f, 2.41442f, 2.26709f, 2.12875f, 1.99885f, 1.87688f, 1.76236f, 1.65482f, 1.55384f, 1.45902f, 1.36999f, 1.2864f, 1.2079f, 1.13419f, 1.06499f, 1.0f};

    public static int ilog(int v) {
        int ret = 0;
        while (v > 0) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    public static int ilog2(int v) {
        int ret = 0;
        if (v > 0) {
            --v;
        }
        while (v > 0) {
            ++ret;
            v >>>= 1;
        }
        return ret;
    }

    public static int icount(int v) {
        int ret = 0;
        while (v > 0) {
            ret += v & 1;
            v >>>= 1;
        }
        return ret;
    }

    public static float unitnorm(float x) {
        int i = Float.floatToIntBits(x);
        int calc2 = i & Integer.MIN_VALUE | 0x3F800000;
        float calc = Float.intBitsToFloat(calc2);
        return calc;
    }

    public static float todB(float x) {
        int i = Float.floatToIntBits(x);
        float calc = (float)(i &= Integer.MAX_VALUE) * 7.1771143E-7f;
        return calc -= 764.6162f;
    }

    public static int render_point(int x0, int x1, int y0, int y1, int x) {
        int dy = (y1 &= Short.MAX_VALUE) - (y0 &= Short.MAX_VALUE);
        int adx = x1 - x0;
        int ady = Math.abs(dy);
        int err = ady * (x - x0);
        int off = err / adx;
        if (dy < 0) {
            return y0 - off;
        }
        return y0 + off;
    }

    public static int vorbis_dBquant(float x) {
        int i = new Float(x * 7.3142858f + 1023.5f).intValue();
        if (i > 1023) {
            return 1023;
        }
        if (i < 0) {
            return 0;
        }
        return i;
    }

    public static void render_line(int x0, int x1, int y0, int y1, float[] d) {
        int dy = y1 - y0;
        int adx = x1 - x0;
        int ady = Math.abs(dy);
        int base = dy / adx;
        int sy = dy < 0 ? base - 1 : base + 1;
        int x = x0;
        int y = y0;
        int err = 0;
        ady -= Math.abs(base * adx);
        int n = x;
        d[n] = d[n] * FLOOR1_fromdB_LOOKUP[y];
        while (++x < x1) {
            if ((err += ady) >= adx) {
                err -= adx;
                y += sy;
            } else {
                y += base;
            }
            int n2 = x;
            d[n2] = d[n2] * FLOOR1_fromdB_LOOKUP[y];
        }
    }

    public static void render_line0(int x0, int x1, int y0, int y1, int[] d) {
        int dy = y1 - y0;
        int adx = x1 - x0;
        int ady = Math.abs(dy);
        int base = dy / adx;
        int sy = dy < 0 ? base - 1 : base + 1;
        int x = x0;
        int y = y0;
        int err = 0;
        ady -= Math.abs(base * adx);
        d[x] = y;
        while (++x < x1) {
            if ((err += ady) >= adx) {
                err -= adx;
                y += sy;
            } else {
                y += base;
            }
            d[x] = y;
        }
    }
}

