/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

class mdct_lookup {
    int n;
    int log2n;
    float[] trig;
    int[] bitrev;
    float scale;

    public mdct_lookup() {
    }

    public mdct_lookup(int _n, int _log2n, float[] _trig, int[] _bitrev, float _scale) {
        this.n = _n;
        this.log2n = _log2n;
        this.trig = (float[])_trig.clone();
        this.bitrev = (int[])_bitrev.clone();
        this.scale = _scale;
    }

    public mdct_lookup(mdct_lookup src) {
        this(src.n, src.log2n, src.trig, src.bitrev, src.scale);
    }

    public void mdct_init(int _n) {
        this.n = _n;
        this.log2n = new Double(Math.rint(Math.log(new Integer(this.n).floatValue()) / Math.log(2.0))).intValue();
        this.trig = new float[this.n + this.n / 4];
        this.bitrev = new int[this.n / 4];
        int n2 = this.n >> 1;
        int i = 0;
        while (i < this.n / 4) {
            this.trig[i * 2] = new Double(Math.cos((float)Math.PI / (float)this.n * (float)(4 * i))).floatValue();
            this.trig[i * 2 + 1] = new Double(-Math.sin((float)Math.PI / (float)this.n * (float)(4 * i))).floatValue();
            this.trig[n2 + i * 2] = new Double(Math.cos((float)Math.PI / (float)(2 * this.n) * (float)(2 * i + 1))).floatValue();
            this.trig[n2 + i * 2 + 1] = new Double(Math.sin((float)Math.PI / (float)(2 * this.n) * (float)(2 * i + 1))).floatValue();
            ++i;
        }
        i = 0;
        while (i < this.n / 8) {
            this.trig[this.n + i * 2] = new Double(Math.cos((float)Math.PI / (float)this.n * (float)(4 * i + 2)) * 0.5).floatValue();
            this.trig[this.n + i * 2 + 1] = new Double(-Math.sin((float)Math.PI / (float)this.n * (float)(4 * i + 2)) * 0.5).floatValue();
            ++i;
        }
        int mask = (1 << this.log2n - 1) - 1;
        int msb = 1 << this.log2n - 2;
        i = 0;
        while (i < this.n / 8) {
            int acc = 0;
            int j = 0;
            while (msb >> j != 0) {
                if ((msb >> j & i) != 0) {
                    acc |= 1 << j;
                }
                ++j;
            }
            this.bitrev[i * 2] = (~acc & mask) - 1;
            this.bitrev[i * 2 + 1] = acc;
            ++i;
        }
        this.scale = 4.0f / (float)this.n;
    }

    private void mdct_butterfly_8(float[] x, int off) {
        float r0 = x[off + 6] + x[off + 2];
        float r1 = x[off + 6] - x[off + 2];
        float r2 = x[off + 4] + x[off + 0];
        float r3 = x[off + 4] - x[off + 0];
        x[off + 6] = r0 + r2;
        x[off + 4] = r0 - r2;
        r0 = x[off + 5] - x[off + 1];
        r2 = x[off + 7] - x[off + 3];
        x[off + 0] = r1 + r0;
        x[off + 2] = r1 - r0;
        r0 = x[off + 5] + x[off + 1];
        r1 = x[off + 7] + x[off + 3];
        x[off + 3] = r2 + r3;
        x[off + 1] = r2 - r3;
        x[off + 7] = r1 + r0;
        x[off + 5] = r1 - r0;
    }

    private void mdct_butterfly_16(float[] x, int off) {
        float r0 = x[off + 1] - x[off + 9];
        float r1 = x[off + 0] - x[off + 8];
        int n = off + 8;
        x[n] = x[n] + x[off + 0];
        int n2 = off + 9;
        x[n2] = x[n2] + x[off + 1];
        x[off + 0] = (r0 + r1) * 0.70710677f;
        x[off + 1] = (r0 - r1) * 0.70710677f;
        r0 = x[off + 3] - x[off + 11];
        r1 = x[off + 10] - x[off + 2];
        int n3 = off + 10;
        x[n3] = x[n3] + x[off + 2];
        int n4 = off + 11;
        x[n4] = x[n4] + x[off + 3];
        x[off + 2] = r0;
        x[off + 3] = r1;
        r0 = x[off + 12] - x[off + 4];
        r1 = x[off + 13] - x[off + 5];
        int n5 = off + 12;
        x[n5] = x[n5] + x[off + 4];
        int n6 = off + 13;
        x[n6] = x[n6] + x[off + 5];
        x[off + 4] = (r0 - r1) * 0.70710677f;
        x[off + 5] = (r0 + r1) * 0.70710677f;
        r0 = x[off + 14] - x[off + 6];
        r1 = x[off + 15] - x[off + 7];
        int n7 = off + 14;
        x[n7] = x[n7] + x[off + 6];
        int n8 = off + 15;
        x[n8] = x[n8] + x[off + 7];
        x[off + 6] = r0;
        x[off + 7] = r1;
        this.mdct_butterfly_8(x, 0 + off);
        this.mdct_butterfly_8(x, 8 + off);
    }

    private void mdct_butterfly_32(float[] x, int off) {
        float r0 = x[off + 30] - x[off + 14];
        float r1 = x[off + 31] - x[off + 15];
        int n = off + 30;
        x[n] = x[n] + x[off + 14];
        int n2 = off + 31;
        x[n2] = x[n2] + x[off + 15];
        x[off + 14] = r0;
        x[off + 15] = r1;
        r0 = x[off + 28] - x[off + 12];
        r1 = x[off + 29] - x[off + 13];
        int n3 = off + 28;
        x[n3] = x[n3] + x[off + 12];
        int n4 = off + 29;
        x[n4] = x[n4] + x[off + 13];
        x[off + 12] = r0 * 0.9238795f - r1 * 0.38268343f;
        x[off + 13] = r0 * 0.38268343f + r1 * 0.9238795f;
        r0 = x[off + 26] - x[off + 10];
        r1 = x[off + 27] - x[off + 11];
        int n5 = off + 26;
        x[n5] = x[n5] + x[off + 10];
        int n6 = off + 27;
        x[n6] = x[n6] + x[off + 11];
        x[off + 10] = (r0 - r1) * 0.70710677f;
        x[off + 11] = (r0 + r1) * 0.70710677f;
        r0 = x[off + 24] - x[off + 8];
        r1 = x[off + 25] - x[off + 9];
        int n7 = off + 24;
        x[n7] = x[n7] + x[off + 8];
        int n8 = off + 25;
        x[n8] = x[n8] + x[off + 9];
        x[off + 8] = r0 * 0.38268343f - r1 * 0.9238795f;
        x[off + 9] = r1 * 0.38268343f + r0 * 0.9238795f;
        r0 = x[off + 22] - x[off + 6];
        r1 = x[off + 7] - x[off + 23];
        int n9 = off + 22;
        x[n9] = x[n9] + x[off + 6];
        int n10 = off + 23;
        x[n10] = x[n10] + x[off + 7];
        x[off + 6] = r1;
        x[off + 7] = r0;
        r0 = x[off + 4] - x[off + 20];
        r1 = x[off + 5] - x[off + 21];
        int n11 = off + 20;
        x[n11] = x[n11] + x[off + 4];
        int n12 = off + 21;
        x[n12] = x[n12] + x[off + 5];
        x[off + 4] = r1 * 0.9238795f + r0 * 0.38268343f;
        x[off + 5] = r1 * 0.38268343f - r0 * 0.9238795f;
        r0 = x[off + 2] - x[off + 18];
        r1 = x[off + 3] - x[off + 19];
        int n13 = off + 18;
        x[n13] = x[n13] + x[off + 2];
        int n14 = off + 19;
        x[n14] = x[n14] + x[off + 3];
        x[off + 2] = (r1 + r0) * 0.70710677f;
        x[off + 3] = (r1 - r0) * 0.70710677f;
        r0 = x[off + 0] - x[off + 16];
        r1 = x[off + 1] - x[off + 17];
        int n15 = off + 16;
        x[n15] = x[n15] + x[off + 0];
        int n16 = off + 17;
        x[n16] = x[n16] + x[off + 1];
        x[off + 0] = r1 * 0.38268343f + r0 * 0.9238795f;
        x[off + 1] = r1 * 0.9238795f - r0 * 0.38268343f;
        this.mdct_butterfly_16(x, 0 + off);
        this.mdct_butterfly_16(x, 16 + off);
    }

    private void mdct_butterfly_first(float[] T, float[] x, int off, int points) {
        int x1 = off + points - 8;
        int x2 = off + (points >> 1) - 8;
        int t = 0;
        do {
            float r0 = x[x1 + 6] - x[x2 + 6];
            float r1 = x[x1 + 7] - x[x2 + 7];
            int n = x1 + 6;
            x[n] = x[n] + x[x2 + 6];
            int n2 = x1 + 7;
            x[n2] = x[n2] + x[x2 + 7];
            x[x2 + 6] = r1 * T[t + 1] + r0 * T[t + 0];
            x[x2 + 7] = r1 * T[t + 0] - r0 * T[t + 1];
            r0 = x[x1 + 4] - x[x2 + 4];
            r1 = x[x1 + 5] - x[x2 + 5];
            int n3 = x1 + 4;
            x[n3] = x[n3] + x[x2 + 4];
            int n4 = x1 + 5;
            x[n4] = x[n4] + x[x2 + 5];
            x[x2 + 4] = r1 * T[t + 5] + r0 * T[t + 4];
            x[x2 + 5] = r1 * T[t + 4] - r0 * T[t + 5];
            r0 = x[x1 + 2] - x[x2 + 2];
            r1 = x[x1 + 3] - x[x2 + 3];
            int n5 = x1 + 2;
            x[n5] = x[n5] + x[x2 + 2];
            int n6 = x1 + 3;
            x[n6] = x[n6] + x[x2 + 3];
            x[x2 + 2] = r1 * T[t + 9] + r0 * T[t + 8];
            x[x2 + 3] = r1 * T[t + 8] - r0 * T[t + 9];
            r0 = x[x1 + 0] - x[x2 + 0];
            r1 = x[x1 + 1] - x[x2 + 1];
            int n7 = x1 + 0;
            x[n7] = x[n7] + x[x2 + 0];
            int n8 = x1 + 1;
            x[n8] = x[n8] + x[x2 + 1];
            x[x2 + 0] = r1 * T[t + 13] + r0 * T[t + 12];
            x[x2 + 1] = r1 * T[t + 12] - r0 * T[t + 13];
            x1 -= 8;
            t += 16;
        } while ((x2 -= 8) >= off);
    }

    private void mdct_butterfly_generic(float[] T, float[] x, int off, int points, int trigint) {
        int x1 = off + points - 8;
        int x2 = off + (points >> 1) - 8;
        int t = 0;
        do {
            float r0 = x[x1 + 6] - x[x2 + 6];
            float r1 = x[x1 + 7] - x[x2 + 7];
            int n = x1 + 6;
            x[n] = x[n] + x[x2 + 6];
            int n2 = x1 + 7;
            x[n2] = x[n2] + x[x2 + 7];
            x[x2 + 6] = r1 * T[t + 1] + r0 * T[t + 0];
            x[x2 + 7] = r1 * T[t + 0] - r0 * T[t + 1];
            t += trigint;
            r0 = x[x1 + 4] - x[x2 + 4];
            r1 = x[x1 + 5] - x[x2 + 5];
            int n3 = x1 + 4;
            x[n3] = x[n3] + x[x2 + 4];
            int n4 = x1 + 5;
            x[n4] = x[n4] + x[x2 + 5];
            x[x2 + 4] = r1 * T[t + 1] + r0 * T[t + 0];
            x[x2 + 5] = r1 * T[t + 0] - r0 * T[t + 1];
            t += trigint;
            r0 = x[x1 + 2] - x[x2 + 2];
            r1 = x[x1 + 3] - x[x2 + 3];
            int n5 = x1 + 2;
            x[n5] = x[n5] + x[x2 + 2];
            int n6 = x1 + 3;
            x[n6] = x[n6] + x[x2 + 3];
            x[x2 + 2] = r1 * T[t + 1] + r0 * T[t + 0];
            x[x2 + 3] = r1 * T[t + 0] - r0 * T[t + 1];
            t += trigint;
            r0 = x[x1 + 0] - x[x2 + 0];
            r1 = x[x1 + 1] - x[x2 + 1];
            int n7 = x1 + 0;
            x[n7] = x[n7] + x[x2 + 0];
            int n8 = x1 + 1;
            x[n8] = x[n8] + x[x2 + 1];
            x[x2 + 0] = r1 * T[t + 1] + r0 * T[t + 0];
            x[x2 + 1] = r1 * T[t + 0] - r0 * T[t + 1];
            t += trigint;
            x1 -= 8;
        } while ((x2 -= 8) >= off);
    }

    private void mdct_butterflies(float[] x, int off, int points) {
        int j;
        float[] T = this.trig;
        int stages = this.log2n - 5;
        if (--stages > 0) {
            this.mdct_butterfly_first(T, x, off, points);
        }
        int i = 1;
        while (--stages > 0) {
            j = 0;
            while (j < 1 << i) {
                this.mdct_butterfly_generic(T, x, off + (points >> i) * j, points >> i, 4 << i);
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < points) {
            this.mdct_butterfly_32(x, off + j);
            j += 32;
        }
    }

    private void mdct_bitreverse(float[] x) {
        int bit = 0;
        int w0 = 0;
        int w1 = this.n >> 1;
        int xoff = this.n >> 1;
        int t = this.n;
        float[] T = this.trig;
        do {
            int x0 = xoff + this.bitrev[bit + 0];
            int x1 = xoff + this.bitrev[bit + 1];
            float r0 = x[x0 + 1] - x[x1 + 1];
            float r1 = x[x0 + 0] + x[x1 + 0];
            float r2 = r1 * T[t + 0] + r0 * T[t + 1];
            float r3 = r1 * T[t + 1] - r0 * T[t + 0];
            r0 = (x[x0 + 1] + x[x1 + 1]) * 0.5f;
            r1 = (x[x0 + 0] - x[x1 + 0]) * 0.5f;
            x[w0 + 0] = r0 + r2;
            x[(w1 -= 4) + 2] = r0 - r2;
            x[w0 + 1] = r1 + r3;
            x[w1 + 3] = r3 - r1;
            x0 = xoff + this.bitrev[bit + 2];
            x1 = xoff + this.bitrev[bit + 3];
            r0 = x[x0 + 1] - x[x1 + 1];
            r1 = x[x0 + 0] + x[x1 + 0];
            r2 = r1 * T[t + 2] + r0 * T[t + 3];
            r3 = r1 * T[t + 3] - r0 * T[t + 2];
            r0 = (x[x0 + 1] + x[x1 + 1]) * 0.5f;
            r1 = (x[x0 + 0] - x[x1 + 0]) * 0.5f;
            x[w0 + 2] = r0 + r2;
            x[w1 + 0] = r0 - r2;
            x[w0 + 3] = r1 + r3;
            x[w1 + 1] = r3 - r1;
            t += 4;
            bit += 4;
        } while ((w0 += 4) < w1);
    }

    public void mdct_backward(float[] in, float[] out) {
        int n2 = this.n >> 1;
        int n4 = this.n >> 2;
        float[] T = this.trig;
        int iX = n2 - 7;
        int oX = n2 + n4;
        int t = n4;
        do {
            out[(oX -= 4) + 0] = -in[iX + 2] * T[t + 3] - in[iX + 0] * T[t + 2];
            out[oX + 1] = in[iX + 0] * T[t + 3] - in[iX + 2] * T[t + 2];
            out[oX + 2] = -in[iX + 6] * T[t + 1] - in[iX + 4] * T[t + 0];
            out[oX + 3] = in[iX + 4] * T[t + 1] - in[iX + 6] * T[t + 0];
            t += 4;
        } while ((iX -= 8) >= 0);
        iX = n2 - 8;
        oX = n2 + n4;
        t = n4;
        do {
            out[oX + 0] = in[iX + 4] * T[(t -= 4) + 3] + in[iX + 6] * T[t + 2];
            out[oX + 1] = in[iX + 4] * T[t + 2] - in[iX + 6] * T[t + 3];
            out[oX + 2] = in[iX + 0] * T[t + 1] + in[iX + 2] * T[t + 0];
            out[oX + 3] = in[iX + 0] * T[t + 0] - in[iX + 2] * T[t + 1];
            oX += 4;
        } while ((iX -= 8) >= 0);
        this.mdct_butterflies(out, n2, n2);
        this.mdct_bitreverse(out);
        int oX1 = n2 + n4;
        int oX2 = n2 + n4;
        iX = 0;
        t = n2;
        do {
            out[(oX1 -= 4) + 3] = out[iX + 0] * T[t + 1] - out[iX + 1] * T[t + 0];
            out[oX2 + 0] = -(out[iX + 0] * T[t + 0] + out[iX + 1] * T[t + 1]);
            out[oX1 + 2] = out[iX + 2] * T[t + 3] - out[iX + 3] * T[t + 2];
            out[oX2 + 1] = -(out[iX + 2] * T[t + 2] + out[iX + 3] * T[t + 3]);
            out[oX1 + 1] = out[iX + 4] * T[t + 5] - out[iX + 5] * T[t + 4];
            out[oX2 + 2] = -(out[iX + 4] * T[t + 4] + out[iX + 5] * T[t + 5]);
            out[oX1 + 0] = out[iX + 6] * T[t + 7] - out[iX + 7] * T[t + 6];
            out[oX2 + 3] = -(out[iX + 6] * T[t + 6] + out[iX + 7] * T[t + 7]);
            oX2 += 4;
            t += 8;
        } while ((iX += 8) < oX1);
        iX = n2 + n4;
        oX2 = oX1 = n4;
        do {
            float f = out[(iX -= 4) + 3];
            out[(oX1 -= 4) + 3] = f;
            out[oX2 + 0] = -f;
            float f2 = out[iX + 2];
            out[oX1 + 2] = f2;
            out[oX2 + 1] = -f2;
            float f3 = out[iX + 1];
            out[oX1 + 1] = f3;
            out[oX2 + 2] = -f3;
            float f4 = out[iX + 0];
            out[oX1 + 0] = f4;
            out[oX2 + 3] = -f4;
        } while ((oX2 += 4) < iX);
        iX = n2 + n4;
        oX1 = n2 + n4;
        oX2 = n2;
        do {
            out[(oX1 -= 4) + 0] = out[iX + 3];
            out[oX1 + 1] = out[iX + 2];
            out[oX1 + 2] = out[iX + 1];
            out[oX1 + 3] = out[iX + 0];
            iX += 4;
        } while (oX1 > oX2);
    }

    public void mdct_forward(float[] in, float[] out) {
        float r1;
        float r0;
        int n2 = this.n >> 1;
        int n4 = this.n >> 2;
        int n8 = this.n >> 3;
        float[] T = this.trig;
        float[] w = new float[this.n];
        int w2 = n2;
        int x0 = n2 + n4;
        int x1 = x0 + 1;
        int t = n2;
        int i = 0;
        i = 0;
        while (i < n8) {
            r0 = in[(x0 -= 4) + 2] + in[x1 + 0];
            r1 = in[x0 + 0] + in[x1 + 2];
            w[w2 + i] = r1 * T[(t -= 2) + 1] + r0 * T[t + 0];
            w[w2 + i + 1] = r1 * T[t + 0] - r0 * T[t + 1];
            x1 += 4;
            i += 2;
        }
        x1 = 1;
        while (i < n2 - n8) {
            r0 = in[(x0 -= 4) + 2] - in[x1 + 0];
            r1 = in[x0 + 0] - in[x1 + 2];
            w[w2 + i] = r1 * T[(t -= 2) + 1] + r0 * T[t + 0];
            w[w2 + i + 1] = r1 * T[t + 0] - r0 * T[t + 1];
            x1 += 4;
            i += 2;
        }
        x0 = this.n;
        while (i < n2) {
            r0 = -in[(x0 -= 4) + 2] - in[x1 + 0];
            r1 = -in[x0 + 0] - in[x1 + 2];
            w[w2 + i] = r1 * T[(t -= 2) + 1] + r0 * T[t + 0];
            w[w2 + i + 1] = r1 * T[t + 0] - r0 * T[t + 1];
            x1 += 4;
            i += 2;
        }
        this.mdct_butterflies(w, n2, n2);
        this.mdct_bitreverse(w);
        t = n2;
        x0 = n2;
        int w1 = 0;
        i = 0;
        while (i < n4) {
            out[i] = (w[w1 + 0] * T[t + 0] + w[w1 + 1] * T[t + 1]) * this.scale;
            out[--x0 + 0] = (w[w1 + 0] * T[t + 1] - w[w1 + 1] * T[t + 0]) * this.scale;
            w1 += 2;
            t += 2;
            ++i;
        }
    }

    public void mdct_forward_offset(float[] in, int offset, float[] out, int out_offset) {
        float r1;
        float r0;
        int n2 = this.n >> 1;
        int n4 = this.n >> 2;
        int n8 = this.n >> 3;
        float[] T = this.trig;
        float[] w = new float[this.n];
        int w2 = n2;
        int x0 = n2 + n4;
        int x1 = x0 + 1;
        int t = n2;
        int i = 0;
        i = 0;
        while (i < n8) {
            r0 = in[offset + (x0 -= 4) + 2] + in[offset + x1 + 0];
            r1 = in[offset + x0 + 0] + in[offset + x1 + 2];
            w[w2 + i] = r1 * T[(t -= 2) + 1] + r0 * T[t + 0];
            w[w2 + i + 1] = r1 * T[t + 0] - r0 * T[t + 1];
            x1 += 4;
            i += 2;
        }
        x1 = 1;
        while (i < n2 - n8) {
            r0 = in[offset + (x0 -= 4) + 2] - in[offset + x1 + 0];
            r1 = in[offset + x0 + 0] - in[offset + x1 + 2];
            w[w2 + i] = r1 * T[(t -= 2) + 1] + r0 * T[t + 0];
            w[w2 + i + 1] = r1 * T[t + 0] - r0 * T[t + 1];
            x1 += 4;
            i += 2;
        }
        x0 = this.n;
        while (i < n2) {
            r0 = -in[offset + (x0 -= 4) + 2] - in[offset + x1 + 0];
            r1 = -in[offset + x0 + 0] - in[offset + x1 + 2];
            w[w2 + i] = r1 * T[(t -= 2) + 1] + r0 * T[t + 0];
            w[w2 + i + 1] = r1 * T[t + 0] - r0 * T[t + 1];
            x1 += 4;
            i += 2;
        }
        this.mdct_butterflies(w, n2, n2);
        this.mdct_bitreverse(w);
        t = n2;
        x0 = n2;
        int w1 = 0;
        i = 0;
        while (i < n4) {
            out[out_offset + i] = (w[w1 + 0] * T[t + 0] + w[w1 + 1] * T[t + 1]) * this.scale;
            out[out_offset + --x0 + 0] = (w[w1 + 0] * T[t + 1] - w[w1 + 1] * T[t + 0]) * this.scale;
            w1 += 2;
            t += 2;
            ++i;
        }
    }
}

