/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

import org.xiph.libvorbis.static_codebook;

public class codebook {
    int dim;
    int entries;
    int used_entries;
    static_codebook c;
    float[] valuelist;
    int[] codelist;
    int[] dec_index;
    char[] dec_codelengths;
    int[] dec_firsttable;
    int dec_firsttablen;
    int dec_maxlength;

    public void vorbis_book_init_encode(static_codebook s) {
        this.dim = s.dim;
        this.entries = s.entries;
        this.used_entries = s.entries;
        this.c = s;
        this.codelist = this._make_words(s.lengthlist, s.entries, 0);
        this.valuelist = this._book_unquantize(s, s.entries, null);
    }

    private int[] _make_words(int[] l, int n, int sparsecount) {
        int j;
        int count = 0;
        int[] r = sparsecount != 0 ? new int[sparsecount] : new int[n];
        int[] marker = new int[33];
        int i = 0;
        while (i < n) {
            int length = l[i];
            if (length > 0) {
                int entry = marker[length];
                if (length < 32 && entry >>> length != 0) {
                    return null;
                }
                r[count++] = entry;
                j = length;
                while (j > 0) {
                    if ((marker[j] & 1) != 0) {
                        if (j == 1) {
                            marker[1] = marker[1] + 1;
                            break;
                        }
                        marker[j] = marker[j - 1] << 1;
                        break;
                    }
                    int n2 = j--;
                    marker[n2] = marker[n2] + 1;
                }
                j = length + 1;
                while (j < 33) {
                    if (marker[j] >>> 1 == entry) {
                        entry = marker[j];
                        marker[j] = marker[j - 1] << 1;
                        ++j;
                        continue;
                    }
                    break;
                }
            } else if (sparsecount == 0) {
                ++count;
            }
            ++i;
        }
        i = 0;
        count = 0;
        while (i < n) {
            int temp = 0;
            j = 0;
            while (j < l[i]) {
                temp <<= 1;
                temp |= r[count] >>> j & 1;
                ++j;
            }
            if (sparsecount != 0) {
                if (l[i] != 0) {
                    r[count++] = temp;
                }
            } else {
                r[count++] = temp;
            }
            ++i;
        }
        return r;
    }

    private float ldexp(double value, long exp) {
        return new Double(value * Math.pow(2.0, new Long(exp).intValue())).floatValue();
    }

    private float _float32_unpack(int val) {
        double mant = val & 0x1FFFFF;
        int sign = val & Integer.MIN_VALUE;
        long exp = ((long)val & 0x7FE00000L) >>> 21;
        if (sign != 0) {
            mant = -mant;
        }
        return this.ldexp(mant, exp - 20L - 768L);
    }

    private float[] _book_unquantize(static_codebook b, int n, int[] sparsemap) {
        int count = 0;
        if (b.maptype == 1 || b.maptype == 2) {
            float mindel = this._float32_unpack(b.q_min);
            float delta = this._float32_unpack(b.q_delta);
            float[] r = new float[n * b.dim];
            switch (b.maptype) {
                case 1: {
                    int quantvals = b._book_maptype1_quantvals();
                    int j = 0;
                    while (j < b.entries) {
                        if (sparsemap != null && b.lengthlist[j] != 0 || sparsemap == null) {
                            float last = 0.0f;
                            int indexdiv = 1;
                            int k = 0;
                            while (k < b.dim) {
                                int index = j / indexdiv % quantvals;
                                float val = b.quantlist[index];
                                val = Math.abs(val) * delta + mindel + last;
                                if (b.q_sequencep != 0) {
                                    last = val;
                                }
                                if (sparsemap != null) {
                                    r[sparsemap[count] * b.dim + k] = val;
                                } else {
                                    r[count * b.dim + k] = val;
                                }
                                indexdiv *= quantvals;
                                ++k;
                            }
                            ++count;
                        }
                        ++j;
                    }
                    break;
                }
                case 2: {
                    int j = 0;
                    while (j < b.entries) {
                        if (sparsemap != null && b.lengthlist[j] != 0 || sparsemap == null) {
                            float last = 0.0f;
                            int k = 0;
                            while (k < b.dim) {
                                float val = b.quantlist[j * b.dim + k];
                                val = Math.abs(val) * delta + mindel + last;
                                if (b.q_sequencep != 0) {
                                    last = val;
                                }
                                if (sparsemap != null) {
                                    r[sparsemap[count] * b.dim + k] = val;
                                } else {
                                    r[count * b.dim + k] = val;
                                }
                                ++k;
                            }
                            ++count;
                        }
                        ++j;
                    }
                    break;
                }
            }
            return r;
        }
        return null;
    }
}

