/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.libvorbis;

import org.xiph.libvorbis.bitrate_manager_info;
import org.xiph.libvorbis.codec_setup_info;
import org.xiph.libvorbis.vorbis_block;
import org.xiph.libvorbis.vorbis_info;

class bitrate_manager_state {
    int managed;
    int avg_reservoir;
    int minmax_reservoir;
    int avg_bitsper;
    int min_bitsper;
    int max_bitsper;
    int short_per_long;
    float avgfloat;
    vorbis_block vb;
    int choice;

    public bitrate_manager_state(vorbis_info vi) {
        codec_setup_info ci = vi.codec_setup;
        bitrate_manager_info bi = ci.bi;
        if (bi.reservoir_bits > 0) {
            int desired_fill;
            int ratesamples = vi.rate;
            int halfsamples = ci.blocksizes[0] >> 1;
            this.short_per_long = ci.blocksizes[1] / ci.blocksizes[0];
            this.managed = 1;
            this.avg_bitsper = new Double(Math.rint(1.0 * (double)bi.avg_rate * (double)halfsamples / (double)ratesamples)).intValue();
            this.min_bitsper = new Double(Math.rint(1.0 * (double)bi.min_rate * (double)halfsamples / (double)ratesamples)).intValue();
            this.max_bitsper = new Double(Math.rint(1.0 * (double)bi.max_rate * (double)halfsamples / (double)ratesamples)).intValue();
            this.avgfloat = 7.0f;
            this.minmax_reservoir = desired_fill = new Float((float)bi.reservoir_bits * bi.reservoir_bias).intValue();
            this.avg_reservoir = desired_fill;
        }
    }
}

