/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file.mpeg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class MpegAudioFileReader
extends TAudioFileReader {
    private static final int SYNC = -2097152;
    private static final AudioFormat.Encoding[][] sm_aEncodings = new AudioFormat.Encoding[][]{{new AudioFormat.Encoding("MPEG2DOT5L3"), new AudioFormat.Encoding("MPEG2DOT5L2"), new AudioFormat.Encoding("MPEG2DOT5L1")}, {null, null, null}, {new AudioFormat.Encoding("MPEG2L3"), new AudioFormat.Encoding("MPEG2L2"), new AudioFormat.Encoding("MPEG2L1")}, {new AudioFormat.Encoding("MPEG1L3"), new AudioFormat.Encoding("MPEG1L2"), new AudioFormat.Encoding("MPEG1L1")}};
    private static final float[][] sm_afSamplingRates = new float[][]{{11025.0f, 12000.0f, 8000.0f}, {0.0f, 0.0f, 0.0f}, {22050.0f, 24000.0f, 16000.0f}, {44100.0f, 48000.0f, 32000.0f}};
    private static final int MARK_LIMIT = 4;

    public MpegAudioFileReader() {
        super(4, true);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long lFileSizeInBytes) throws UnsupportedAudioFileException, IOException {
        int b3;
        int b2;
        int b1;
        int b0;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(): begin");
        }
        if (((b0 = inputStream.read()) | (b1 = inputStream.read()) | (b2 = inputStream.read()) | (b3 = inputStream.read())) < 0) {
            throw new EOFException();
        }
        int nHeader = (b0 << 24) + (b1 << 16) + (b2 << 8) + (b3 << 0);
        if ((nHeader & 0xFFE00000) != -2097152) {
            throw new UnsupportedAudioFileException("not a MPEG stream: no sync bits");
        }
        int nVersion = nHeader >> 19 & 3;
        if (nVersion == 1) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong version");
        }
        int nLayer = nHeader >> 17 & 3;
        if (nLayer == 0) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong layer");
        }
        AudioFormat.Encoding encoding = sm_aEncodings[nVersion][nLayer - 1];
        int nSFIndex = nHeader >> 10 & 3;
        if (nSFIndex == 3) {
            throw new UnsupportedAudioFileException("not a MPEG stream: wrong sampling rate");
        }
        float fSamplingRate = sm_afSamplingRates[nVersion][nSFIndex];
        int nMode = nHeader >> 6 & 3;
        int nChannels = nMode == 3 ? 1 : 2;
        AudioFormat format = new AudioFormat(encoding, fSamplingRate, -1, nChannels, -1, -1.0f, true);
        AudioFileFormat.Type type = new AudioFileFormat.Type("MPEG", "mpeg");
        if (encoding.equals(new AudioFormat.Encoding("MPEG1L3"))) {
            type = new AudioFileFormat.Type("MP3", "mp3");
        }
        int nByteSize = -1;
        int nFrameSize = -1;
        if (lFileSizeInBytes != -1L && lFileSizeInBytes <= Integer.MAX_VALUE) {
            nByteSize = (int)lFileSizeInBytes;
        }
        TAudioFileFormat audioFileFormat = new TAudioFileFormat(type, format, nFrameSize, nByteSize);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out((String)"MpegAudioFileReader.getAudioFileFormat(): end");
        }
        return audioFileFormat;
    }
}

