-- This library function allows us to use a file in a specified location.
-- Allows use to call global environment variables without initializing them in our files.
modimport("libs/env.lua")

-- Actions Initialization.
use "data/actions/init"

-- Component Initialization.
use "data/components/init"

PrefabFiles = {
	"saitama", "saitama_none",  "genos_ghost", "genos_ghost_flower"
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/saitama.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/saitama.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/saitama.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/saitama.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/saitama_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/saitama_silho.xml" ),

    Asset( "IMAGE", "bigportraits/saitama.tex" ),
    Asset( "ATLAS", "bigportraits/saitama.xml" ),
	
	Asset( "IMAGE", "images/map_icons/saitama.tex" ),
	Asset( "ATLAS", "images/map_icons/saitama.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_saitama.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_saitama.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_saitama.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_saitama.xml" ),

        Asset( "IMAGE", "images/inventoryimages/abigailflower.tex" ),
	Asset( "ATLAS", "images/inventoryimages/abigailflower.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/abigailflower2.tex" ),
	Asset( "ATLAS", "images/inventoryimages/abigailflower2.xml" ),
	
	Asset( "IMAGE", "images/inventoryimages/abigailflowerhaunted.tex" ),
	Asset( "ATLAS", "images/inventoryimages/abigailflowerhaunted.xml" ), 

Asset( "IMAGE", "bigportraits/saitama_none.tex" ),
    Asset( "ATLAS", "bigportraits/saitama_none.xml" ),
	
	Asset( "IMAGE", "images/names_saitama.tex" ),
    Asset( "ATLAS", "images/names_saitama.xml" )
}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

GLOBAL.STRINGS.NAMES.GENOS_GHOST = "Genos"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENOS_GHOST = "Oh! Genos...How are you?"

GLOBAL.STRINGS.NAMES.GENOS_GHOST_FLOWER = "Genos's Token"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GENOS_GHOST_FLOWER = "W...WAIT!Don't..."

AddBrainPostInit("abigailbrain", function(self)
	local _atfn = self.inst.components.aura.auratestfn
	self.inst.components.aura.auratestfn = function(inst, target)
		if inst.cowardmode then
			return false
		end
		return _atfn(inst, target)
	end
	local _caav = self.bt.root.children[1].Visit
	self.bt.root.children[1].Visit = function(self)
		_caav(self)
		if self.status == GLOBAL.RUNNING then
			local leader = self.inst.components.follower.leader
			if leader and not self.inst:IsNear(leader, 15) then
				self.inst.cowardmode = true
				self.status = GLOBAL.FAILED
				self.inst.components.combat:GiveUp()
				self.inst.components.locomotor:Stop()
				return
			else
				self.inst.cowardmode = nil
			end
		end
	end
	local _offn = self.bt.root.children[2].Visit
	self.bt.root.children[2].Visit = function(self)
		_offn(self)
		if self.status == GLOBAL.SUCCESS then
			self.inst.cowardmode = nil
			return
		end
	end
end)

local function MakeNeutral(inst)
    if GLOBAL.TheWorld.ismastersim then
        local _CanTarget = inst.components.combat.CanTarget
        inst.components.combat.CanTarget = function(self, target)
            local ret = _CanTarget(self, target)
            if ret and target:HasTag("saitama") then
                local playertarget = target.components.combat.target
                local shadowtarget = playertarget and playertarget:HasTag("shadowcreature")
                if not shadowtarget then
                    return false
                end
            end
            return ret
        end
    end
end

local comb_rep = GLOBAL.require "components/combat_replica"
local old_IsAlly = comb_rep.IsAlly
function comb_rep:IsAlly(guy,...)
	if guy:HasTag("genosghost") then
		return true
	end
	return old_IsAlly(self,guy,...)
end

AddPrefabPostInit("crawlinghorror", MakeNeutral)
AddPrefabPostInit("terrorbeak", MakeNeutral)
AddPrefabPostInit("nightmarebeak", MakeNeutral)
AddPrefabPostInit("crawlingnightmare", MakeNeutral)

-- The character select screen lines
STRINGS.CHARACTER_TITLES.saitama = "The Caped Baldy"
STRINGS.CHARACTER_NAMES.saitama = "Saitama"
STRINGS.CHARACTER_DESCRIPTIONS.saitama = "*ONE\n*PUNCH\n*MAN"
STRINGS.CHARACTER_QUOTES.saitama = "\"Having an overwhelming power is boring as hell.\""

-- Custom speech strings
STRINGS.CHARACTERS.SAITAMA = require "speech_saitama"

-- The character's name as appears in-game 
STRINGS.NAMES.SAITAMA = "Saitama"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SAITAMA = 
{
	GENERIC = "It's Saitama!",
	ATTACKER = "That Saitama looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Saitama, friend of ghosts.",
	GHOST = "Saitama could use a heart.",
}

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "saitama")


AddMinimapAtlas("images/map_icons/saitama.xml")
AddModCharacter("saitama")