/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.Annotation;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.asm.LdcOptimizeAdapter;
import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.LocalRemove;
import com.googlecode.dex2jar.ir.ts.LocalSplit;
import com.googlecode.dex2jar.ir.ts.LocalType;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.v3.Dex2AsmAnnotationAdapter;
import com.googlecode.dex2jar.v3.EndRemover;
import com.googlecode.dex2jar.v3.ExceptionHandlerCurrect;
import com.googlecode.dex2jar.v3.IrMethod2AsmMethod;
import com.googlecode.dex2jar.v3.LocalCurrect;
import com.googlecode.dex2jar.v3.V3AnnAdapter;
import com.googlecode.dex2jar.v3.V3CodeAdapter;
import com.googlecode.dex2jar.visitors.DexAnnotationAble;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3MethodAdapter
implements DexMethodVisitor,
Opcodes {
    private static Transformer endremove = new EndRemover();
    private static final Logger log = LoggerFactory.getLogger(V3MethodAdapter.class);
    private static Transformer[] tses = new Transformer[]{new ExceptionHandlerCurrect(), new LocalSplit(), new LocalRemove(), new LocalType(), new LocalCurrect()};
    protected final Method method;
    protected final MethodNode methodNode = new MethodNode();
    protected final int accessFlags;
    Map<Method, Exception> exceptions;
    Annotation throwsAnnotation;
    Annotation signatureAnnotation;
    IrMethod irMethod;

    public static void indexLabelStmt4Debug(StmtList list) {
        int labelIndex = 0;
        for (Stmt stmt : list) {
            if (stmt.st != Stmt.ST.LABEL) continue;
            ((LabelStmt)stmt).displayName = "L" + labelIndex++;
        }
    }

    public V3MethodAdapter(int accessFlags, Method method, Map<Method, Exception> exceptions) {
        this.method = method;
        this.accessFlags = accessFlags;
        this.exceptions = exceptions;
        this.methodNode.desc = method.getDesc();
    }

    private void build() {
        Annotation values;
        ArrayList<String> exceptions = new ArrayList<String>();
        String signature = null;
        if (this.throwsAnnotation != null) {
            for (Annotation.Item item : this.throwsAnnotation.items) {
                if (!item.name.equals("value")) continue;
                values = (Annotation)item.value;
                for (Annotation.Item i : values.items) {
                    exceptions.add(((Type)i.value).getInternalName());
                }
            }
        }
        if (this.signatureAnnotation != null) {
            for (Annotation.Item item : this.signatureAnnotation.items) {
                if (!item.name.equals("value")) continue;
                values = (Annotation)item.value;
                StringBuilder sb = new StringBuilder();
                for (Annotation.Item i : values.items) {
                    sb.append(i.value.toString());
                }
                signature = sb.toString();
            }
        }
        MethodNode methodNode = this.methodNode;
        methodNode.access = this.accessFlags;
        methodNode.name = this.method.getName();
        methodNode.desc = this.method.getDesc();
        methodNode.signature = signature;
        methodNode.exceptions = exceptions;
        methodNode.tryCatchBlocks = new ArrayList();
    }

    void dump(MethodNode methodNode) {
        TraceMethodVisitor tmv = new TraceMethodVisitor();
        methodNode.instructions.accept((MethodVisitor)tmv);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object o : tmv.text) {
            sb.append(i++).append(o);
        }
        System.out.println(sb);
    }

    public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
        if (name.equals("Ldalvik/annotation/Signature;")) {
            this.signatureAnnotation = new Annotation(name, visible);
            return new V3AnnAdapter(this.signatureAnnotation);
        }
        if (name.equals("Ldalvik/annotation/Throws;")) {
            this.throwsAnnotation = new Annotation(name, visible);
            return new V3AnnAdapter(this.throwsAnnotation);
        }
        AnnotationVisitor av = this.methodNode.visitAnnotation(name, visible);
        if (av != null) {
            return new Dex2AsmAnnotationAdapter(av);
        }
        return null;
    }

    public DexCodeVisitor visitCode() {
        IrMethod irMethod = new IrMethod();
        irMethod.access = this.accessFlags;
        irMethod.args = Type.getArgumentTypes((String)this.method.getDesc());
        irMethod.ret = Type.getType((String)this.method.getReturnType());
        irMethod.owner = Type.getType((String)this.method.getOwner());
        irMethod.name = this.method.getName();
        this.irMethod = irMethod;
        return new V3CodeAdapter(this.accessFlags, irMethod);
    }

    public void visitEnd() {
        this.build();
        if (this.irMethod != null) {
            try {
                if (this.irMethod.stmts.getSize() > 1) {
                    endremove.transform(this.irMethod);
                    for (Transformer ts : tses) {
                        ts.transform(this.irMethod);
                    }
                }
                new IrMethod2AsmMethod().convert(this.irMethod, (MethodVisitor)new LdcOptimizeAdapter((MethodVisitor)this.methodNode));
            }
            catch (Exception e) {
                if (this.exceptions == null) {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                }
                this.exceptions.put(this.method, e);
                StringWriter s = new StringWriter();
                e.printStackTrace(new PrintWriter(s));
                String msg = s.toString();
                this.methodNode.instructions.clear();
                this.methodNode.tryCatchBlocks.clear();
                this.irMethod.traps.clear();
                this.irMethod.stmts.clear();
                this.irMethod.stmts.add((Stmt)Stmts.nThrow((Value)Exprs.nInvokeNew((Value[])new Value[]{Constant.nString((String)("Generated by Dex2jar, and Some Exception Caught :" + msg))}, (Type[])new Type[]{Type.getType(String.class)}, (Type)Type.getType(RuntimeException.class))));
                new IrMethod2AsmMethod().convert(this.irMethod, (MethodVisitor)this.methodNode);
            }
        }
    }

    public DexAnnotationAble visitParameterAnnotation(final int index) {
        return new DexAnnotationAble(){

            public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
                AnnotationVisitor av = V3MethodAdapter.this.methodNode.visitParameterAnnotation(index, name, visible);
                if (av != null) {
                    return new Dex2AsmAnnotationAdapter(av);
                }
                return null;
            }
        };
    }

    static {
        log.debug("InsnList.check=false");
        InsnList.check = false;
    }
}

