/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodes;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.ir.Constant;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import java.util.Arrays;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class V3CodeAdapter
implements DexCodeVisitor,
Opcodes,
DexOpcodes {
    protected IrMethod irMethod;
    private StmtList list;
    private Local[] locals;
    private int tmp_reg;

    private static LabelStmt toLabelStmt(DexLabel label) {
        LabelStmt ls = (LabelStmt)label.info;
        if (ls == null) {
            ls = new LabelStmt(new Label());
            label.info = ls;
        }
        return ls;
    }

    public V3CodeAdapter(int accessFlags, IrMethod irMethod) {
        this.list = irMethod.stmts;
        this.irMethod = irMethod;
    }

    public void visitArguments(int total, int[] args) {
        Local[] locals = new Local[total + 1];
        this.locals = locals;
        this.tmp_reg = total;
        int i = 0;
        if ((this.irMethod.access & 8) == 0) {
            Local _this = Exprs.nLocal((String)"this", (Type)this.irMethod.owner);
            this.list.add((Stmt)Stmts.nIdentity((Value)_this, (Value)Exprs.nThisRef((Type)this.irMethod.owner)));
            locals[args[i]] = _this;
            ++i;
        }
        int j = 0;
        while (i < args.length) {
            Local _arg = Exprs.nLocal((String)("arg_" + args[i]), (Type)this.irMethod.args[j]);
            this.list.add((Stmt)Stmts.nIdentity((Value)_arg, (Value)Exprs.nParameterRef((Type)this.irMethod.args[j], (int)j)));
            locals[args[i]] = _arg;
            ++i;
            ++j;
        }
        for (i = 0; i < locals.length; ++i) {
            if (locals[i] != null) continue;
            locals[i] = Exprs.nLocal((String)("a" + i), null);
        }
    }

    public void visitArrayStmt(int opcode, int formOrToReg, int arrayReg, int indexReg) {
        switch (opcode) {
            case 75: {
                this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)this.locals[arrayReg], (Value)this.locals[indexReg]), (Value)this.locals[formOrToReg]));
                break;
            }
            case 68: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[formOrToReg], (Value)Exprs.nArray((Value)this.locals[arrayReg], (Value)this.locals[indexReg])));
            }
        }
    }

    public void visitBinopLitXStmt(int opcode, int distReg, int srcReg, int constant) {
        Local dist = this.locals[distReg];
        Local a = this.locals[srcReg];
        Constant b = Constant.nInt((int)constant);
        switch (opcode) {
            case 16711896: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nAdd((Value)a, (Value)b)));
                break;
            }
            case 16711897: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nSub((Value)b, (Value)a)));
                break;
            }
            case 16711898: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nMul((Value)a, (Value)b)));
                break;
            }
            case 16711899: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nDiv((Value)a, (Value)b)));
                break;
            }
            case 16711900: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nRem((Value)a, (Value)b)));
                break;
            }
            case 0xFF00DD: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nAnd((Value)a, (Value)b)));
                break;
            }
            case 16711902: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nOr((Value)a, (Value)b)));
                break;
            }
            case 0xFF00DF: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nXor((Value)a, (Value)b)));
                break;
            }
            case 0xFF00E0: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nShl((Value)a, (Value)b)));
                break;
            }
            case 16711905: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nShr((Value)a, (Value)b)));
                break;
            }
            case 16711906: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nUshr((Value)a, (Value)b)));
            }
        }
    }

    public void visitBinopStmt(int opcode, int toReg, int r1, int r2) {
        Local dist = this.locals[toReg];
        Local a = this.locals[r1];
        Local b = this.locals[r2];
        switch (opcode) {
            case 144: 
            case 155: 
            case 166: 
            case 171: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nAdd((Value)a, (Value)b)));
                break;
            }
            case 145: 
            case 156: 
            case 167: 
            case 172: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nSub((Value)a, (Value)b)));
                break;
            }
            case 146: 
            case 157: 
            case 168: 
            case 173: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nMul((Value)a, (Value)b)));
                break;
            }
            case 147: 
            case 158: 
            case 169: 
            case 174: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nDiv((Value)a, (Value)b)));
                break;
            }
            case 148: 
            case 159: 
            case 170: 
            case 175: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nRem((Value)a, (Value)b)));
                break;
            }
            case 149: 
            case 160: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nAnd((Value)a, (Value)b)));
                break;
            }
            case 150: 
            case 161: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nOr((Value)a, (Value)b)));
                break;
            }
            case 151: 
            case 162: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nXor((Value)a, (Value)b)));
                break;
            }
            case 152: 
            case 163: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nShl((Value)a, (Value)b)));
                break;
            }
            case 153: 
            case 164: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nShr((Value)a, (Value)b)));
                break;
            }
            case 154: 
            case 165: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nUshr((Value)a, (Value)b)));
            }
        }
    }

    public void visitClassStmt(int opcode, int a, int b, String type) {
        switch (opcode) {
            case 32: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nInstanceOf((Value)this.locals[b], (Type)Type.getType((String)type))));
                break;
            }
            case 35: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[a], (Value)Exprs.nNewArray((Type)Type.getType((String)type.substring(1)), (Value)this.locals[b])));
            }
        }
    }

    public void visitClassStmt(int opcode, int saveTo, String type) {
        switch (opcode) {
            case 31: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[saveTo], (Value)Exprs.nCheckCast((Value)this.locals[saveTo], (Type)Type.getType((String)type))));
                break;
            }
            case 34: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[saveTo], (Value)Exprs.nNew((Type)Type.getType((String)type))));
            }
        }
    }

    public void visitCmpStmt(int opcode, int distReg, int bB, int cC) {
        Local dist = this.locals[distReg];
        Local a = this.locals[bB];
        Local b = this.locals[cC];
        switch (opcode) {
            case 45: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nFCmpl((Value)a, (Value)b)));
                break;
            }
            case 47: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nDCmpl((Value)a, (Value)b)));
                break;
            }
            case 46: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nFCmpg((Value)a, (Value)b)));
                break;
            }
            case 48: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nDCmpg((Value)a, (Value)b)));
                break;
            }
            case 49: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nLCmp((Value)a, (Value)b)));
            }
        }
    }

    public void visitConstStmt(int opcode, int toReg, Object value) {
        switch (opcode) {
            case 20: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Constant.nInt((int)((Integer)value))));
                break;
            }
            case 24: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Constant.nLong((long)((Long)value))));
                break;
            }
            case 26: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Constant.nString((String)((String)value))));
                break;
            }
            case 28: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)Constant.nClass((Type)Type.getType((String)((String)value)))));
            }
        }
    }

    public void visitEnd() {
        this.irMethod.locals.addAll(Arrays.asList(this.locals));
        this.locals = null;
    }

    public void visitFieldStmt(int opcode, int fromOrToReg, Field field) {
        switch (opcode) {
            case 96: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[fromOrToReg], (Value)Exprs.nStaticField((Type)Type.getType((String)field.getOwner()), (String)field.getName(), (Type)Type.getType((String)field.getType()))));
                break;
            }
            case 103: {
                this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nStaticField((Type)Type.getType((String)field.getOwner()), (String)field.getName(), (Type)Type.getType((String)field.getType())), (Value)this.locals[fromOrToReg]));
            }
        }
    }

    public void visitFieldStmt(int opcode, int fromOrToReg, int objReg, Field field) {
        switch (opcode) {
            case 82: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[fromOrToReg], (Value)Exprs.nField((Value)this.locals[objReg], (Type)Type.getType((String)field.getOwner()), (String)field.getName(), (Type)Type.getType((String)field.getType()))));
                break;
            }
            case 89: {
                this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nField((Value)this.locals[objReg], (Type)Type.getType((String)field.getOwner()), (String)field.getName(), (Type)Type.getType((String)field.getType())), (Value)this.locals[fromOrToReg]));
            }
        }
    }

    public void visitFillArrayStmt(int opcode, int aA, int elemWidth, int initLength, Object[] values) {
        Local array = this.locals[aA];
        Type type = null;
        switch (elemWidth) {
            case 1: {
                type = Type.BYTE_TYPE;
                break;
            }
            case 2: {
                type = Type.SHORT_TYPE;
                break;
            }
            case 4: {
                type = Type.INT_TYPE;
                break;
            }
            case 8: {
                type = Type.LONG_TYPE;
            }
        }
        for (int i = 0; i < initLength; ++i) {
            this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)array, (Value)Constant.nInt((int)i)), (Value)Constant.n((Type)type, (Object)values[i])));
        }
    }

    public void visitFilledNewArrayStmt(int opcode, int[] args, String type) {
        Local array = this.locals[this.tmp_reg];
        Type elem = Type.getType((String)type).getElementType();
        this.list.add((Stmt)Stmts.nAssign((Value)array, (Value)Exprs.nNewArray((Type)elem, (Value)Constant.nInt((int)args.length))));
        for (int i = 0; i < args.length; ++i) {
            this.list.add((Stmt)Stmts.nAssign((Value)Exprs.nArray((Value)array, (Value)Constant.nInt((int)i)), (Value)this.locals[args[i]]));
        }
    }

    public void visitJumpStmt(int opcode, int r1, int r2, DexLabel label) {
        Local a = this.locals[r1];
        Local b = this.locals[r2];
        LabelStmt ls = V3CodeAdapter.toLabelStmt(label);
        switch (opcode) {
            case 50: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nEq((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 51: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nNe((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 52: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nLt((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 53: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nGe((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 54: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nGt((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 55: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nLe((Value)a, (Value)b), (LabelStmt)ls));
            }
        }
    }

    public void visitJumpStmt(int opcode, int reg, DexLabel label) {
        Local a = this.locals[reg];
        Constant b = Constant.nInt((int)0);
        LabelStmt ls = V3CodeAdapter.toLabelStmt(label);
        switch (opcode) {
            case 56: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nEq((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 57: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nNe((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 58: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nLt((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 59: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nGe((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 60: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nGt((Value)a, (Value)b), (LabelStmt)ls));
                break;
            }
            case 61: {
                this.list.add((Stmt)Stmts.nIf((Value)Exprs.nLe((Value)a, (Value)b), (LabelStmt)ls));
            }
        }
    }

    public void visitJumpStmt(int opcode, DexLabel label) {
        this.list.add((Stmt)Stmts.nGoto((LabelStmt)V3CodeAdapter.toLabelStmt(label)));
    }

    public void visitLabel(DexLabel label) {
        this.list.add((Stmt)V3CodeAdapter.toLabelStmt(label));
    }

    public void visitLookupSwitchStmt(int opcode, int aA, DexLabel label, int[] cases, DexLabel[] labels) {
        LabelStmt[] lss = new LabelStmt[cases.length];
        for (int i = 0; i < cases.length; ++i) {
            lss[i] = V3CodeAdapter.toLabelStmt(labels[i]);
        }
        this.list.add((Stmt)Stmts.nLookupSwitch((Value)this.locals[aA], (int[])cases, (LabelStmt[])lss, (LabelStmt)V3CodeAdapter.toLabelStmt(label)));
    }

    public void visitMethodStmt(int opcode, int[] args, Method method) {
        Value[] vs = new Value[args.length];
        for (int j = 0; j < vs.length; ++j) {
            vs[j] = this.locals[args[j]];
        }
        Local saveTo = this.locals[this.tmp_reg];
        InvokeExpr invoke = null;
        switch (opcode) {
            case 110: {
                invoke = Exprs.nInvokeVirtual((Value[])vs, (Type)Type.getType((String)method.getOwner()), (String)method.getName(), (Type[])Type.getArgumentTypes((String)method.getDesc()), (Type)Type.getType((String)method.getReturnType()));
                break;
            }
            case 111: 
            case 112: {
                invoke = Exprs.nInvokeSpecial((Value[])vs, (Type)Type.getType((String)method.getOwner()), (String)method.getName(), (Type[])Type.getArgumentTypes((String)method.getDesc()), (Type)Type.getType((String)method.getReturnType()));
                break;
            }
            case 113: {
                invoke = Exprs.nInvokeStatic((Value[])vs, (Type)Type.getType((String)method.getOwner()), (String)method.getName(), (Type[])Type.getArgumentTypes((String)method.getDesc()), (Type)Type.getType((String)method.getReturnType()));
                break;
            }
            case 114: {
                invoke = Exprs.nInvokeInterface((Value[])vs, (Type)Type.getType((String)method.getOwner()), (String)method.getName(), (Type[])Type.getArgumentTypes((String)method.getDesc()), (Type)Type.getType((String)method.getReturnType()));
            }
        }
        this.list.add((Stmt)Stmts.nAssign((Value)saveTo, invoke));
    }

    public void visitMonitorStmt(int opcode, int reg) {
        switch (opcode) {
            case 29: {
                this.list.add((Stmt)Stmts.nLock((Value)this.locals[reg]));
                break;
            }
            case 30: {
                this.list.add((Stmt)Stmts.nUnLock((Value)this.locals[reg]));
            }
        }
    }

    public void visitMoveStmt(int opcode, int toReg) {
        switch (opcode) {
            case 10: 
            case 11: 
            case 12: {
                this.list.add((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)this.locals[this.tmp_reg]));
                break;
            }
            case 13: {
                this.list.add((Stmt)Stmts.nIdentity((Value)this.locals[toReg], (Value)Exprs.nExceptionRef((Type)Type.getType(Throwable.class))));
            }
        }
    }

    public void visitMoveStmt(int opcode, int toReg, int fromReg) {
        this.list.add((Stmt)Stmts.nAssign((Value)this.locals[toReg], (Value)this.locals[fromReg]));
    }

    public void visitReturnStmt(int opcode) {
        this.list.add((Stmt)Stmts.nReturnVoid());
    }

    public void visitReturnStmt(int opcode, int reg) {
        switch (opcode) {
            case 39: {
                this.list.add((Stmt)Stmts.nThrow((Value)this.locals[reg]));
                break;
            }
            case 15: {
                this.list.add((Stmt)Stmts.nReturn((Value)this.locals[reg]));
            }
        }
    }

    public void visitTableSwitchStmt(int opcode, int aA, DexLabel label, int first_case, int last_case, DexLabel[] labels) {
        LabelStmt[] lss = new LabelStmt[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            lss[i] = V3CodeAdapter.toLabelStmt(labels[i]);
        }
        this.list.add((Stmt)Stmts.nTableSwitch((Value)this.locals[aA], (int)first_case, (int)last_case, (LabelStmt[])lss, (LabelStmt)V3CodeAdapter.toLabelStmt(label)));
    }

    public void visitTryCatch(DexLabel start, DexLabel end, DexLabel handler, String type) {
        this.irMethod.traps.add(new Trap(V3CodeAdapter.toLabelStmt(start), V3CodeAdapter.toLabelStmt(end), V3CodeAdapter.toLabelStmt(handler), type == null ? null : Type.getType((String)type)));
    }

    public void visitUnopStmt(int opcode, int toReg, int fromReg) {
        Local dist = this.locals[toReg];
        Local src = this.locals[fromReg];
        switch (opcode) {
            case 33: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nLength((Value)src)));
                break;
            }
            case 123: 
            case 125: 
            case 127: 
            case 128: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nNeg((Value)src)));
                break;
            }
            case 124: 
            case 126: {
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nNot((Value)src)));
                break;
            }
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                Type to;
                Type from;
                switch (opcode) {
                    case 129: 
                    case 130: 
                    case 131: 
                    case 141: 
                    case 142: 
                    case 143: {
                        from = Type.INT_TYPE;
                        break;
                    }
                    case 135: 
                    case 136: 
                    case 137: {
                        from = Type.FLOAT_TYPE;
                        break;
                    }
                    case 138: 
                    case 139: 
                    case 140: {
                        from = Type.DOUBLE_TYPE;
                        break;
                    }
                    case 132: 
                    case 133: 
                    case 134: {
                        from = Type.LONG_TYPE;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                switch (opcode) {
                    case 129: 
                    case 136: 
                    case 139: {
                        to = Type.LONG_TYPE;
                        break;
                    }
                    case 130: 
                    case 133: 
                    case 140: {
                        to = Type.FLOAT_TYPE;
                        break;
                    }
                    case 131: 
                    case 134: 
                    case 137: {
                        to = Type.DOUBLE_TYPE;
                        break;
                    }
                    case 132: 
                    case 135: 
                    case 138: {
                        to = Type.INT_TYPE;
                        break;
                    }
                    case 141: {
                        to = Type.BYTE_TYPE;
                        break;
                    }
                    case 142: {
                        to = Type.CHAR_TYPE;
                        break;
                    }
                    case 143: {
                        to = Type.SHORT_TYPE;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                this.list.add((Stmt)Stmts.nAssign((Value)dist, (Value)Exprs.nCast((Value)src, (Type)from, (Type)to)));
            }
        }
    }

    public void visitLineNumber(int line, DexLabel label) {
    }

    public void visitLocalVariable(String name, String type, String signature, DexLabel start, DexLabel end, int reg) {
    }
}

