/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.Annotation;
import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.v3.V3AnnAdapter;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexFieldVisitor;
import com.googlecode.dex2jar.visitors.DexFileVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class V3AccessFlagsAdapter
implements DexFileVisitor {
    private Map<String, Integer> map = new HashMap<String, Integer>();
    private Map<String, String> innerNameMap = new HashMap<String, String>();
    private Map<String, Set<String>> extraMember = new HashMap<String, Set<String>>();

    public Map<String, String> getInnerNameMap() {
        return this.innerNameMap;
    }

    public Map<String, Integer> getAccessFlagsMap() {
        return this.map;
    }

    public Map<String, Set<String>> getExtraMember() {
        return this.extraMember;
    }

    public DexClassVisitor visit(int access_flags, final String className, String superClass, String[] interfaceNames) {
        return new DexClassVisitor(){
            protected List<Annotation> anns = new ArrayList<Annotation>();

            public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
                Annotation ann = new Annotation(name, visible);
                this.anns.add(ann);
                return new V3AnnAdapter(ann);
            }

            public void visitSource(String file) {
            }

            public DexMethodVisitor visitMethod(int accessFlags, Method method) {
                return null;
            }

            public DexFieldVisitor visitField(int accessFlags, Field field, Object value) {
                return null;
            }

            public void visitEnd() {
                String enclosingClass = null;
                for (Annotation ann : this.anns) {
                    if (ann.type.equals("Ldalvik/annotation/EnclosingClass;")) {
                        for (Annotation.Item i : ann.items) {
                            if (!i.name.equals("value")) continue;
                            enclosingClass = i.value.toString();
                        }
                        continue;
                    }
                    if (!ann.type.equals("Ldalvik/annotation/EnclosingMethod;")) continue;
                    for (Annotation.Item i : ann.items) {
                        if (!"value".equals(i.name)) continue;
                        Method m = (Method)i.value;
                        enclosingClass = m.getOwner();
                    }
                }
                for (Annotation ann : this.anns) {
                    if (!"Ldalvik/annotation/InnerClass;".equals(ann.type)) continue;
                    for (Annotation.Item it : ann.items) {
                        if ("accessFlags".equals(it.name)) {
                            V3AccessFlagsAdapter.this.map.put(className, (Integer)it.value);
                            continue;
                        }
                        if (!"name".equals(it.name)) continue;
                        V3AccessFlagsAdapter.this.innerNameMap.put(className, (String)it.value);
                        if (it.value != null) continue;
                        TreeSet<String> set = (TreeSet<String>)V3AccessFlagsAdapter.this.extraMember.get(enclosingClass);
                        if (set == null) {
                            set = new TreeSet<String>();
                            V3AccessFlagsAdapter.this.extraMember.put(enclosingClass, set);
                        }
                        set.add(className);
                    }
                }
            }
        };
    }

    public void visitEnd() {
    }
}

