/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.util.ASMifierCodeV;
import com.googlecode.dex2jar.util.Escape;
import com.googlecode.dex2jar.util.Out;
import com.googlecode.dex2jar.v3.ClassVisitorFactory;
import com.googlecode.dex2jar.v3.V3;
import com.googlecode.dex2jar.v3.V3AccessFlagsAdapter;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.DexFileVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import com.googlecode.dex2jar.visitors.EmptyVisitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void doData(byte[] data, File destJar) throws IOException {
        Main.doData(data, destJar, new HashMap<Method, Exception>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doData(byte[] data, File destJar, final Map<Method, Exception> exceptions) throws IOException {
        DexFileReader reader = new DexFileReader(data);
        V3AccessFlagsAdapter afa = new V3AccessFlagsAdapter();
        reader.accept((DexFileVisitor)afa, 3);
        final ZipOutputStream zos = new ZipOutputStream(FileUtils.openOutputStream((File)destJar));
        try {
            reader.accept((DexFileVisitor)new V3(afa.getAccessFlagsMap(), afa.getInnerNameMap(), afa.getExtraMember(), exceptions, new ClassVisitorFactory(){

                @Override
                public ClassVisitor create(final String name) {
                    return new ClassWriter(1){

                        public void visitEnd() {
                            super.visitEnd();
                            try {
                                byte[] data = this.toByteArray();
                                ZipEntry entry = new ZipEntry(name + ".class");
                                zos.putNextEntry(entry);
                                zos.write(data);
                                zos.closeEntry();
                            }
                            catch (IOException e) {
                                e.printStackTrace(System.err);
                            }
                        }
                    };
                }
            }), 1);
            zos.finish();
        }
        catch (Exception e) {
            if (exceptions == null) {
                throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
            }
            e.printStackTrace(System.err);
        }
        finally {
            zos.close();
        }
        if (exceptions != null && exceptions.size() > 0) {
            for (Map.Entry<Method, Exception> e : exceptions.entrySet()) {
                System.err.println("Error:" + e.getKey().toString() + "->" + e.getValue().getMessage());
            }
            File errorFile = new File(destJar.getParentFile(), FilenameUtils.getBaseName((String)destJar.getName()) + ".error.txt");
            final PrintWriter fw = new PrintWriter(new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)errorFile), "UTF-8"));
            fw.println(Main.getVersionString());
            final Out out = new Out(){

                public void s(String format, Object ... arg) {
                    fw.println(String.format(format, arg));
                }

                public void s(String s) {
                    fw.println(s);
                }

                public void push() {
                }

                public void pop() {
                }
            };
            reader.accept((DexFileVisitor)new EmptyVisitor(){

                public DexClassVisitor visit(int accessFlags, String className, String superClass, String[] interfaceNames) {
                    return new EmptyVisitor(){

                        public DexMethodVisitor visitMethod(final int accessFlags, final Method method) {
                            if (exceptions.containsKey(method)) {
                                return new EmptyVisitor(){

                                    public DexCodeVisitor visitCode() {
                                        out.s("===========================================");
                                        Exception exception = (Exception)exceptions.get(method);
                                        exception.printStackTrace(fw);
                                        out.s("");
                                        out.s("DexMethodVisitor mv=cv.visitMethod(%s, %s);", new Object[]{Escape.methodAcc((int)accessFlags), Escape.v((Method)method)});
                                        out.s("DexCodeVisitor code = mv.visitCode();");
                                        return new ASMifierCodeV(out);
                                    }

                                    public void visitEnd() {
                                        out.s("mv.visitEnd();");
                                        fw.flush();
                                    }
                                };
                            }
                            return null;
                        }
                    };
                }
            }, 1);
            fw.close();
            System.err.println("Detail Error Information in File " + errorFile);
            System.err.println("Please report this file to http://code.google.com/p/dex2jar/issues/entry if possible.");
        }
    }

    public static void doFile(File srcDex) throws IOException {
        Main.doFile(srcDex, new File(srcDex.getParentFile(), FilenameUtils.getBaseName((String)srcDex.getName()) + "_dex2jar.jar"));
    }

    public static void doFile(File srcDex, File distJar) throws IOException {
        Main.doData(Main.readClasses(srcDex), distJar);
    }

    public static String getVersionString() {
        return "dex2jar version: reader-" + DexFileReader.class.getPackage().getImplementationVersion() + ", translator-" + Main.class.getPackage().getImplementationVersion() + ", ir-" + ET.class.getPackage().getImplementationVersion();
    }

    public static void main(String ... args) {
        log.info(Main.getVersionString());
        if (args.length == 0) {
            System.err.println("dex2jar file1.dexORapk file2.dexORapk ...");
            return;
        }
        String jreVersion = System.getProperty("java.specification.version");
        if (jreVersion.compareTo("1.6") < 0) {
            System.err.println("A JRE version >=1.6 is required");
            return;
        }
        boolean containsError = false;
        for (String file : args) {
            File dex = new File(file);
            File gen = new File(dex.getParentFile(), FilenameUtils.getBaseName((String)file) + "_dex2jar.jar");
            log.info("dex2jar {} -> {}", (Object)dex, (Object)gen);
            try {
                Main.doFile(dex, gen);
            }
            catch (Exception e) {
                containsError = true;
                Main.niceExceptionMessage(log, (Throwable)new DexException((Throwable)e, "while process file: [%s]", new Object[]{dex}), 0);
            }
        }
        log.info("Done.");
        System.exit(containsError ? -1 : 0);
    }

    public static void niceExceptionMessage(Logger log, Throwable t, int deep) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < deep + 1; ++i) {
            sb.append(".");
        }
        sb.append(' ');
        if (t instanceof DexException) {
            sb.append(t.getMessage());
            log.error(sb.toString());
            if (t.getCause() != null) {
                Main.niceExceptionMessage(log, t.getCause(), deep + 1);
            }
        } else if (t != null) {
            log.error(sb.append("ROOT cause:").toString(), t);
        }
    }

    public static byte[] readClasses(File srcDex) throws IOException {
        byte[] data = FileUtils.readFileToByteArray((File)srcDex);
        if ("dex".equals(new String(data, 0, 3))) {
            return data;
        }
        if ("PK".equals(new String(data, 0, 2))) {
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(data));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals("classes.dex")) {
                    return IOUtils.toByteArray((InputStream)zis);
                }
                entry = zis.getNextEntry();
            }
        }
        throw new RuntimeException("the src file not a .dex file or a zip file");
    }
}

