/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.ByteArrayAnnotatedOutput;
import org.jf.smali.LexerErrorInterface;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;
import org.jf.util.ConsoleUtil;
import org.jf.util.smaliHelpFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class main {
    public static final String VERSION;
    private static final Options basicOptions;
    private static final Options debugOptions;
    private static final Options options;

    private main() {
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException ex) {
            main.usage();
            return;
        }
        boolean sort = false;
        boolean fixStringConst = true;
        boolean fixGoto = true;
        boolean verboseErrors = false;
        boolean oldLexer = false;
        boolean printTokens = false;
        String outputDexFile = "out.dex";
        String dumpFileName = null;
        String[] remainingArgs = commandLine.getArgs();
        Option[] options = commandLine.getOptions();
        block17: for (int i = 0; i < options.length; ++i) {
            Option option = options[i];
            String opt = option.getOpt();
            switch (opt.charAt(0)) {
                case 'v': {
                    main.version();
                    return;
                }
                case '?': {
                    while (++i < options.length) {
                        if (options[i].getOpt().charAt(0) != '?') continue;
                        main.usage(true);
                        return;
                    }
                    main.usage(false);
                    return;
                }
                case 'o': {
                    outputDexFile = commandLine.getOptionValue("o");
                    continue block17;
                }
                case 'D': {
                    dumpFileName = commandLine.getOptionValue("D", outputDexFile + ".dump");
                    continue block17;
                }
                case 'S': {
                    sort = true;
                    continue block17;
                }
                case 'C': {
                    fixStringConst = false;
                    continue block17;
                }
                case 'G': {
                    fixGoto = false;
                    continue block17;
                }
                case 'V': {
                    verboseErrors = true;
                    continue block17;
                }
                case 'L': {
                    oldLexer = true;
                    continue block17;
                }
                case 'T': {
                    printTokens = true;
                    continue block17;
                }
                default: {
                    assert (false);
                    continue block17;
                }
            }
        }
        if (remainingArgs.length == 0) {
            main.usage();
            return;
        }
        try {
            LinkedHashSet<File> filesToProcess = new LinkedHashSet<File>();
            for (String arg : remainingArgs) {
                File argFile = new File(arg);
                if (!argFile.exists()) {
                    throw new RuntimeException("Cannot find file or directory \"" + arg + "\"");
                }
                if (argFile.isDirectory()) {
                    main.getSmaliFilesInDir(argFile, filesToProcess);
                    continue;
                }
                if (!argFile.isFile()) continue;
                filesToProcess.add(argFile);
            }
            DexFile dexFile = new DexFile();
            boolean errors = false;
            for (File file : filesToProcess) {
                if (main.assembleSmaliFile(file, dexFile, verboseErrors, oldLexer, printTokens)) continue;
                errors = true;
            }
            if (errors) {
                System.exit(1);
            }
            if (sort) {
                dexFile.setSortAllItems(true);
            }
            if (fixStringConst || fixGoto) {
                main.fixInstructions(dexFile, fixStringConst, fixGoto);
            }
            dexFile.place();
            ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput();
            if (dumpFileName != null) {
                out.enableAnnotations(120, true);
            }
            dexFile.writeTo(out);
            byte[] bytes = out.toByteArray();
            DexFile.calcSignature(bytes);
            DexFile.calcChecksum(bytes);
            if (dumpFileName != null) {
                out.finishAnnotating();
                FileWriter fileWriter = new FileWriter(dumpFileName);
                out.writeAnnotationsTo(fileWriter);
                fileWriter.close();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(outputDexFile);
            fileOutputStream.write(bytes);
            fileOutputStream.close();
        }
        catch (RuntimeException ex) {
            System.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
            ex.printStackTrace();
            System.exit(2);
        }
        catch (Throwable ex) {
            System.err.println("\nUNEXPECTED TOP-LEVEL ERROR:");
            ex.printStackTrace();
            System.exit(3);
        }
    }

    private static void getSmaliFilesInDir(File dir, Set<File> smaliFiles) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                main.getSmaliFilesInDir(file, smaliFiles);
                continue;
            }
            if (!file.getName().endsWith(".smali")) continue;
            smaliFiles.add(file);
        }
    }

    private static void fixInstructions(DexFile dexFile, boolean fixStringConst, boolean fixGoto) {
        dexFile.place();
        Object newInsns = null;
        for (CodeItem codeItem : dexFile.CodeItemsSection.getItems()) {
            codeItem.fixInstructions(fixStringConst, fixGoto);
        }
    }

    private static boolean assembleSmaliFile(File smaliFile, DexFile dexFile, boolean verboseErrors, boolean oldLexer, boolean printTokens) throws Exception {
        CommonTokenStream tokens;
        LexerErrorInterface lexer;
        boolean lexerErrors = false;
        if (oldLexer) {
            ANTLRFileStream input = new ANTLRFileStream(smaliFile.getAbsolutePath(), "UTF-8");
            input.name = smaliFile.getAbsolutePath();
            lexer = new smaliLexer(input);
            tokens = new CommonTokenStream((TokenSource)((Object)lexer));
        } else {
            FileInputStream fis = new FileInputStream(smaliFile.getAbsolutePath());
            InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
            lexer = new smaliFlexLexer(reader);
            ((smaliFlexLexer)lexer).setSourceFile(smaliFile);
            tokens = new CommonTokenStream((TokenSource)((Object)lexer));
        }
        if (printTokens) {
            tokens.getTokens();
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = tokens.get(i);
                if (token.getChannel() == 99) continue;
                System.out.println(smaliParser.tokenNames[token.getType()] + ": " + token.getText());
            }
        }
        smaliParser parser = new smaliParser(tokens);
        parser.setVerboseErrors(verboseErrors);
        smaliParser.smali_file_return result = parser.smali_file();
        if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
            return false;
        }
        CommonTree t = (CommonTree)result.getTree();
        CommonTreeNodeStream treeStream = new CommonTreeNodeStream(t);
        treeStream.setTokenStream(tokens);
        smaliTreeWalker dexGen = new smaliTreeWalker(treeStream);
        dexGen.dexFile = dexFile;
        dexGen.smali_file();
        return dexGen.getNumberOfSyntaxErrors() <= 0;
    }

    private static void usage(boolean printDebugOptions) {
        smaliHelpFormatter formatter = new smaliHelpFormatter();
        formatter.setWidth(ConsoleUtil.getConsoleWidth());
        formatter.printHelp("java -jar smali.jar [options] [--] [<smali-file>|folder]*", "assembles a set of smali files into a dex file", basicOptions, "");
        if (printDebugOptions) {
            System.out.println();
            System.out.println("Debug Options:");
            StringBuffer sb = new StringBuffer();
            formatter.renderOptions(sb, debugOptions);
            System.out.println(sb.toString());
        }
    }

    private static void usage() {
        main.usage(false);
    }

    private static void version() {
        System.out.println("smali " + VERSION + " (http://smali.googlecode.com)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"prints the version then exits");
        Option versionOption = OptionBuilder.create((String)"v");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"prints the help message then exits. Specify twice for debug options");
        Option helpOption = OptionBuilder.create((String)"?");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"the name of the dex file that will be written. The default is out.dex");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option outputOption = OptionBuilder.create((String)"o");
        OptionBuilder.withLongOpt((String)"dump-to");
        OptionBuilder.withDescription((String)"additionally writes a dump of written dex file to FILE (<dexfile>.dump by default)");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"FILE");
        Option dumpOption = OptionBuilder.create((String)"D");
        OptionBuilder.withLongOpt((String)"sort");
        OptionBuilder.withDescription((String)"sort the items in the dex file into a canonical order before writing");
        Option sortOption = OptionBuilder.create((String)"S");
        OptionBuilder.withLongOpt((String)"no-fix-string-const");
        OptionBuilder.withDescription((String)"Don't replace string-const instructions with string-const/jumbo where appropriate");
        Option noFixStringConstOption = OptionBuilder.create((String)"C");
        OptionBuilder.withLongOpt((String)"no-fix-goto");
        OptionBuilder.withDescription((String)"Don't replace goto type instructions with a larger version where appropriate");
        Option noFixGotoOption = OptionBuilder.create((String)"G");
        OptionBuilder.withLongOpt((String)"verbose-errors");
        OptionBuilder.withDescription((String)"Generate verbose error messages");
        Option verboseErrorsOption = OptionBuilder.create((String)"V");
        OptionBuilder.withLongOpt((String)"old-lexer");
        OptionBuilder.withDescription((String)"Use the old lexer");
        Option oldLexerOption = OptionBuilder.create((String)"L");
        OptionBuilder.withLongOpt((String)"print-tokens");
        OptionBuilder.withDescription((String)"Print the name and text of each token");
        Option printTokensOption = OptionBuilder.create((String)"T");
        basicOptions.addOption(versionOption);
        basicOptions.addOption(helpOption);
        basicOptions.addOption(outputOption);
        debugOptions.addOption(dumpOption);
        debugOptions.addOption(sortOption);
        debugOptions.addOption(noFixStringConstOption);
        debugOptions.addOption(noFixGotoOption);
        debugOptions.addOption(verboseErrorsOption);
        debugOptions.addOption(oldLexerOption);
        debugOptions.addOption(printTokensOption);
        for (Object option : basicOptions.getOptions()) {
            options.addOption((Option)option);
        }
        for (Object option : debugOptions.getOptions()) {
            options.addOption((Option)option);
        }
    }

    static {
        basicOptions = new Options();
        debugOptions = new Options();
        options = new Options();
        main.buildOptions();
        InputStream templateStream = main.class.getClassLoader().getResourceAsStream("smali.properties");
        Properties properties = new Properties();
        String version = "(unknown)";
        try {
            properties.load(templateStream);
            version = properties.getProperty("application.version");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        VERSION = version;
    }
}

