/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.ArrayList;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.ByteArrayOutput;
import org.jf.dexlib.Util.Output;

public final class ByteArrayOutput
implements Output {
    private final boolean stretchy;
    private byte[] data;
    private int cursor;
    private boolean verbose;
    private ArrayList<Annotation> annotations;
    private int annotationWidth;
    private int hexCols;

    public ByteArrayOutput() {
        this(new byte[1000], true);
    }

    private ByteArrayOutput(byte[] data, boolean stretchy) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        this.stretchy = stretchy;
        this.data = data;
        this.cursor = 0;
        this.verbose = false;
        this.annotations = null;
        this.annotationWidth = 0;
        this.hexCols = 0;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.cursor];
        System.arraycopy(this.data, 0, result, 0, this.cursor);
        return result;
    }

    public int getCursor() {
        return this.cursor;
    }

    public void writeByte(int value) {
        int writeAt = this.cursor;
        int end = writeAt + 1;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.data[writeAt] = (byte)value;
        this.cursor = end;
    }

    public void writeShort(int value) {
        int writeAt = this.cursor;
        int end = writeAt + 2;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.data[writeAt] = (byte)value;
        this.data[writeAt + 1] = (byte)(value >> 8);
        this.cursor = end;
    }

    public void writeInt(int value) {
        int writeAt = this.cursor;
        int end = writeAt + 4;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.data[writeAt] = (byte)value;
        this.data[writeAt + 1] = (byte)(value >> 8);
        this.data[writeAt + 2] = (byte)(value >> 16);
        this.data[writeAt + 3] = (byte)(value >> 24);
        this.cursor = end;
    }

    public void writeLong(long value) {
        int writeAt = this.cursor;
        int end = writeAt + 8;
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        int half = (int)value;
        this.data[writeAt] = (byte)half;
        this.data[writeAt + 1] = (byte)(half >> 8);
        this.data[writeAt + 2] = (byte)(half >> 16);
        this.data[writeAt + 3] = (byte)(half >> 24);
        half = (int)(value >> 32);
        this.data[writeAt + 4] = (byte)half;
        this.data[writeAt + 5] = (byte)(half >> 8);
        this.data[writeAt + 6] = (byte)(half >> 16);
        this.data[writeAt + 7] = (byte)(half >> 24);
        this.cursor = end;
    }

    public int writeUnsignedLeb128(int value) {
        int remaining = value >>> 7;
        int count = 0;
        while (remaining != 0) {
            this.writeByte(value & 0x7F | 0x80);
            value = remaining;
            remaining >>>= 7;
            ++count;
        }
        this.writeByte(value & 0x7F);
        return count + 1;
    }

    public int writeSignedLeb128(int value) {
        int end;
        int remaining = value >> 7;
        int count = 0;
        boolean hasMore = true;
        int n = end = (value & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (hasMore) {
            hasMore = remaining != end || (remaining & 1) != (value >> 6 & 1);
            this.writeByte(value & 0x7F | (hasMore ? 128 : 0));
            value = remaining;
            remaining >>= 7;
            ++count;
        }
        return count;
    }

    public void write(byte[] bytes, int offset, int length) {
        int writeAt = this.cursor;
        int end = writeAt + length;
        int bytesEnd = offset + length;
        if ((offset | length | end) < 0 || bytesEnd > bytes.length) {
            throw new IndexOutOfBoundsException("bytes.length " + bytes.length + "; " + offset + "..!" + end);
        }
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        System.arraycopy(bytes, offset, this.data, writeAt, length);
        this.cursor = end;
    }

    public void write(byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    public void alignTo(int alignment) {
        int end = AlignmentUtils.alignOffset(this.cursor, alignment);
        if (this.stretchy) {
            this.ensureCapacity(end);
        } else if (end > this.data.length) {
            ByteArrayOutput.throwBounds();
            return;
        }
        this.cursor = end;
    }

    private static void throwBounds() {
        throw new IndexOutOfBoundsException("attempt to write past the end");
    }

    private void ensureCapacity(int desiredSize) {
        if (this.data.length < desiredSize) {
            byte[] newData = new byte[desiredSize * 2 + 1000];
            System.arraycopy(this.data, 0, newData, 0, this.cursor);
            this.data = newData;
        }
    }
}

