/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class EnumEncodedValue
extends EncodedValue {
    public final FieldIdItem value;

    protected EnumEncodedValue(DexFile dexFile, Input in, byte valueArg) {
        int index = (int)EncodedValueUtils.decodeUnsignedIntegralValue(in.readBytes(valueArg + 1));
        this.value = dexFile.FieldIdsSection.getItemByIndex(index);
    }

    public EnumEncodedValue(FieldIdItem value) {
        this.value = value;
    }

    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeUnsignedIntegralValue(this.value.getIndex());
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_ENUM.name() + ",value_arg=" + (bytes.length - 1));
            out.annotate(bytes.length, "value: " + this.value.getFieldString());
        }
        out.writeByte(ValueType.VALUE_ENUM.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    public int placeValue(int offset) {
        return offset + EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(this.value.getIndex()) + 1;
    }

    protected int compareValue(EncodedValue o) {
        EnumEncodedValue other = (EnumEncodedValue)o;
        return this.value.getIndex() - other.value.getIndex();
    }

    public ValueType getValueType() {
        return ValueType.VALUE_ENUM;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

