/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.HeaderItem;
import org.jf.dexlib.IndexedSection;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MapItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.OdexDependencies;
import org.jf.dexlib.OdexHeader;
import org.jf.dexlib.OffsettedSection;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Section;
import org.jf.dexlib.StringDataItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.FileUtils;
import org.jf.dexlib.Util.Hex;

public class DexFile {
    private final Section[] sectionsByType;
    private final IndexedSection[] indexedSections;
    private final OffsettedSection[] offsettedSections;
    private final boolean preserveSignedRegisters;
    private final boolean skipInstructions;
    private boolean inplace;
    private boolean sortAllItems;
    private final DexFile dexFile;
    private boolean isOdex;
    private OdexHeader odexHeader;
    private OdexDependencies odexDependencies;
    private int dataOffset;
    private int dataSize;
    private int fileSize;
    public final HeaderItem HeaderItem;
    public final MapItem MapItem;
    public final IndexedSection<StringIdItem> StringIdsSection;
    public final IndexedSection<TypeIdItem> TypeIdsSection;
    public final IndexedSection<ProtoIdItem> ProtoIdsSection;
    public final IndexedSection<FieldIdItem> FieldIdsSection;
    public final IndexedSection<MethodIdItem> MethodIdsSection;
    public final IndexedSection<ClassDefItem> ClassDefsSection;
    public final OffsettedSection<TypeListItem> TypeListsSection;
    public final OffsettedSection<AnnotationSetRefList> AnnotationSetRefListsSection;
    public final OffsettedSection<AnnotationSetItem> AnnotationSetsSection;
    public final OffsettedSection<ClassDataItem> ClassDataSection;
    public final OffsettedSection<CodeItem> CodeItemsSection;
    public final OffsettedSection<StringDataItem> StringDataSection;
    public final OffsettedSection<DebugInfoItem> DebugInfoItemsSection;
    public final OffsettedSection<AnnotationItem> AnnotationsSection;
    public final OffsettedSection<EncodedArrayItem> EncodedArraysSection;
    public final OffsettedSection<AnnotationDirectoryItem> AnnotationDirectoriesSection;

    private DexFile(boolean preserveSignedRegisters, boolean skipInstructions) {
        this.inplace = false;
        this.sortAllItems = false;
        this.dexFile = this;
        this.isOdex = false;
        this.HeaderItem = new HeaderItem(this);
        this.MapItem = new MapItem(this);
        this.StringIdsSection = new IndexedSection(this, ItemType.TYPE_STRING_ID_ITEM);
        this.TypeIdsSection = new IndexedSection(this, ItemType.TYPE_TYPE_ID_ITEM);
        this.ProtoIdsSection = new IndexedSection(this, ItemType.TYPE_PROTO_ID_ITEM);
        this.FieldIdsSection = new IndexedSection(this, ItemType.TYPE_FIELD_ID_ITEM);
        this.MethodIdsSection = new IndexedSection(this, ItemType.TYPE_METHOD_ID_ITEM);
        this.ClassDefsSection = new IndexedSection<ClassDefItem>(this, ItemType.TYPE_CLASS_DEF_ITEM){

            @Override
            public int placeAt(int offset) {
                if (DexFile.this.dexFile.getInplace()) {
                    return super.placeAt(offset);
                }
                int ret = ClassDefItem.placeClassDefItems(this, offset);
                Collections.sort(this.items, new Comparator<ClassDefItem>(){

                    @Override
                    public int compare(ClassDefItem a, ClassDefItem b) {
                        return a.getOffset() - b.getOffset();
                    }
                });
                this.offset = ((ClassDefItem)this.items.get(0)).getOffset();
                return ret;
            }
        };
        this.TypeListsSection = new OffsettedSection(this, ItemType.TYPE_TYPE_LIST);
        this.AnnotationSetRefListsSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATION_SET_REF_LIST);
        this.AnnotationSetsSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATION_SET_ITEM);
        this.ClassDataSection = new OffsettedSection(this, ItemType.TYPE_CLASS_DATA_ITEM);
        this.CodeItemsSection = new OffsettedSection(this, ItemType.TYPE_CODE_ITEM);
        this.StringDataSection = new OffsettedSection(this, ItemType.TYPE_STRING_DATA_ITEM);
        this.DebugInfoItemsSection = new OffsettedSection(this, ItemType.TYPE_DEBUG_INFO_ITEM);
        this.AnnotationsSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATION_ITEM);
        this.EncodedArraysSection = new OffsettedSection(this, ItemType.TYPE_ENCODED_ARRAY_ITEM);
        this.AnnotationDirectoriesSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM);
        this.preserveSignedRegisters = preserveSignedRegisters;
        this.skipInstructions = skipInstructions;
        this.sectionsByType = new Section[]{this.StringIdsSection, this.TypeIdsSection, this.ProtoIdsSection, this.FieldIdsSection, this.MethodIdsSection, this.ClassDefsSection, this.TypeListsSection, this.AnnotationSetRefListsSection, this.AnnotationSetsSection, this.ClassDataSection, this.CodeItemsSection, this.AnnotationDirectoriesSection, this.StringDataSection, this.DebugInfoItemsSection, this.AnnotationsSection, this.EncodedArraysSection, null, null};
        this.indexedSections = new IndexedSection[]{this.StringIdsSection, this.TypeIdsSection, this.ProtoIdsSection, this.FieldIdsSection, this.MethodIdsSection, this.ClassDefsSection};
        this.offsettedSections = new OffsettedSection[]{this.AnnotationSetRefListsSection, this.AnnotationSetsSection, this.CodeItemsSection, this.AnnotationDirectoriesSection, this.TypeListsSection, this.StringDataSection, this.AnnotationsSection, this.EncodedArraysSection, this.ClassDataSection, this.DebugInfoItemsSection};
    }

    public DexFile(File file) throws IOException {
        this(file, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexFile(File file, boolean preserveSignedRegisters, boolean skipInstructions) throws IOException {
        Section[] sections;
        ByteArrayInput in;
        block26: {
            this(preserveSignedRegisters, skipInstructions);
            byte[] magic = FileUtils.readFile(file, 0, 8);
            InputStream inputStream = null;
            in = null;
            ZipFile zipFile = null;
            try {
                long fileLength;
                if (magic[0] == 80 && magic[1] == 75) {
                    zipFile = new ZipFile(file);
                    ZipEntry zipEntry = zipFile.getEntry("classes.dex");
                    if (zipEntry == null) {
                        throw new NoClassesDexException("zip file " + file.getName() + " does not contain a classes.dex " + "file");
                    }
                    fileLength = zipEntry.getSize();
                    if (fileLength < 40L) {
                        throw new RuntimeException("The classes.dex file in " + file.getName() + " is too small to be a" + " valid dex file");
                    }
                    if (fileLength > Integer.MAX_VALUE) {
                        throw new RuntimeException("The classes.dex file in " + file.getName() + " is too large to read in");
                    }
                    inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    inputStream.mark(8);
                    for (int i = 0; i < 8; ++i) {
                        magic[i] = (byte)inputStream.read();
                    }
                    inputStream.reset();
                } else {
                    fileLength = file.length();
                    if (fileLength < 40L) {
                        throw new RuntimeException(file.getName() + " is too small to be a valid dex file");
                    }
                    if (fileLength < 40L) {
                        throw new RuntimeException(file.getName() + " is too small to be a valid dex file");
                    }
                    if (fileLength > Integer.MAX_VALUE) {
                        throw new RuntimeException(file.getName() + " is too large to read in");
                    }
                    inputStream = new FileInputStream(file);
                }
                boolean isDex = false;
                this.isOdex = false;
                if (Arrays.equals(magic, org.jf.dexlib.HeaderItem.MAGIC)) {
                    isDex = true;
                } else if (Arrays.equals(magic, OdexHeader.MAGIC_35)) {
                    this.isOdex = true;
                } else if (Arrays.equals(magic, OdexHeader.MAGIC_36)) {
                    this.isOdex = true;
                }
                if (this.isOdex) {
                    byte[] odexHeaderBytes = FileUtils.readStream(inputStream, 40);
                    ByteArrayInput odexHeaderIn = new ByteArrayInput(odexHeaderBytes);
                    this.odexHeader = new OdexHeader(odexHeaderIn);
                    int dependencySkip = this.odexHeader.depsOffset - this.odexHeader.dexOffset - this.odexHeader.dexLength;
                    if (dependencySkip < 0) {
                        throw new ExceptionWithContext("Unexpected placement of the odex dependency data");
                    }
                    if (this.odexHeader.dexOffset > 40) {
                        FileUtils.readStream(inputStream, this.odexHeader.dexOffset - 40);
                    }
                    in = new ByteArrayInput(FileUtils.readStream(inputStream, this.odexHeader.dexLength));
                    if (dependencySkip > 0) {
                        FileUtils.readStream(inputStream, dependencySkip);
                    }
                    this.odexDependencies = new OdexDependencies(new ByteArrayInput(FileUtils.readStream(inputStream, this.odexHeader.depsLength)));
                    break block26;
                }
                if (isDex) {
                    in = new ByteArrayInput(FileUtils.readStream(inputStream, (int)fileLength));
                    break block26;
                }
                StringBuffer sb = new StringBuffer("bad magic value:");
                for (int i = 0; i < 8; ++i) {
                    sb.append(" ");
                    sb.append(Hex.u1(magic[i]));
                }
                throw new RuntimeException(sb.toString());
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        ReadContext readContext = new ReadContext();
        this.HeaderItem.readFrom(in, 0, readContext);
        int mapOffset = readContext.getSectionOffset(ItemType.TYPE_MAP_LIST);
        in.setCursor(mapOffset);
        this.MapItem.readFrom(in, 0, readContext);
        for (Section section : sections = new Section[]{this.StringDataSection, this.StringIdsSection, this.TypeIdsSection, this.TypeListsSection, this.ProtoIdsSection, this.FieldIdsSection, this.MethodIdsSection, this.AnnotationsSection, this.AnnotationSetsSection, this.AnnotationSetRefListsSection, this.AnnotationDirectoriesSection, this.DebugInfoItemsSection, this.CodeItemsSection, this.ClassDataSection, this.EncodedArraysSection, this.ClassDefsSection}) {
            int sectionOffset;
            if (section == null || skipInstructions && (section == this.CodeItemsSection || section == this.DebugInfoItemsSection) || (sectionOffset = readContext.getSectionOffset(section.ItemType)) <= 0) continue;
            int sectionSize = readContext.getSectionSize(section.ItemType);
            in.setCursor(sectionOffset);
            section.readFrom(sectionSize, in, readContext);
        }
    }

    public DexFile() {
        this(true, false);
    }

    public boolean getPreserveSignedRegisters() {
        return this.preserveSignedRegisters;
    }

    public boolean skipInstructions() {
        return this.skipInstructions;
    }

    public boolean getSortAllItems() {
        return this.sortAllItems;
    }

    public void setSortAllItems(boolean value) {
        this.sortAllItems = value;
    }

    public boolean isOdex() {
        return this.isOdex;
    }

    public OdexDependencies getOdexDependencies() {
        return this.odexDependencies;
    }

    public OdexHeader getOdexHeader() {
        return this.odexHeader;
    }

    public boolean getInplace() {
        return this.inplace;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setInplace(boolean value) {
        this.inplace = value;
    }

    protected Section[] getOrderedSections() {
        int sectionCount = 0;
        for (Section section : this.sectionsByType) {
            if (section == null || section.getItems().size() <= 0) continue;
            ++sectionCount;
        }
        Section[] sections = new Section[sectionCount];
        sectionCount = 0;
        for (Section section : this.sectionsByType) {
            if (section == null || section.getItems().size() <= 0) continue;
            sections[sectionCount++] = section;
        }
        Arrays.sort(sections, new Comparator<Section>(){

            @Override
            public int compare(Section a, Section b) {
                return a.getOffset() - b.getOffset();
            }
        });
        return sections;
    }

    public void place() {
        Section section;
        Section[] sections;
        int offset = this.HeaderItem.placeAt(0, 0);
        int sectionsPosition = 0;
        if (this.inplace) {
            sections = this.getOrderedSections();
        } else {
            sections = new Section[this.indexedSections.length + this.offsettedSections.length];
            System.arraycopy(this.indexedSections, 0, sections, 0, this.indexedSections.length);
            System.arraycopy(this.offsettedSections, 0, sections, this.indexedSections.length, this.offsettedSections.length);
        }
        while (sectionsPosition < sections.length && sections[sectionsPosition].ItemType.isIndexedItem()) {
            section = sections[sectionsPosition];
            if (!this.inplace) {
                section.sortSection();
            }
            offset = section.placeAt(offset);
            ++sectionsPosition;
        }
        this.dataOffset = offset;
        while (sectionsPosition < sections.length) {
            section = sections[sectionsPosition];
            if (this.sortAllItems && !this.inplace) {
                section.sortSection();
            }
            offset = section.placeAt(offset);
            ++sectionsPosition;
        }
        offset = AlignmentUtils.alignOffset(offset, ItemType.TYPE_MAP_LIST.ItemAlignment);
        this.fileSize = offset = this.MapItem.placeAt(offset, 0);
        this.dataSize = offset - this.dataOffset;
    }

    public void writeTo(AnnotatedOutput out) {
        Section[] sections;
        out.annotate(0, "-----------------------------");
        out.annotate(0, "header item");
        out.annotate(0, "-----------------------------");
        out.annotate(0, " ");
        this.HeaderItem.writeTo(out);
        out.annotate(0, " ");
        int sectionsPosition = 0;
        if (this.inplace) {
            sections = this.getOrderedSections();
        } else {
            sections = new Section[this.indexedSections.length + this.offsettedSections.length];
            System.arraycopy(this.indexedSections, 0, sections, 0, this.indexedSections.length);
            System.arraycopy(this.offsettedSections, 0, sections, this.indexedSections.length, this.offsettedSections.length);
        }
        while (sectionsPosition < sections.length) {
            sections[sectionsPosition].writeTo(out);
            ++sectionsPosition;
        }
        out.alignTo(this.MapItem.getItemType().ItemAlignment);
        out.annotate(0, " ");
        out.annotate(0, "-----------------------------");
        out.annotate(0, "map item");
        out.annotate(0, "-----------------------------");
        out.annotate(0, " ");
        this.MapItem.writeTo(out);
    }

    public static void calcSignature(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        md.update(bytes, 32, bytes.length - 32);
        try {
            int amt = md.digest(bytes, 12, 20);
            if (amt != 20) {
                throw new RuntimeException("unexpected digest write: " + amt + " bytes");
            }
        }
        catch (DigestException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void calcChecksum(byte[] bytes) {
        Adler32 a32 = new Adler32();
        a32.update(bytes, 12, bytes.length - 12);
        int sum = (int)a32.getValue();
        bytes[8] = (byte)sum;
        bytes[9] = (byte)(sum >> 8);
        bytes[10] = (byte)(sum >> 16);
        bytes[11] = (byte)(sum >> 24);
    }

    public static class NoClassesDexException
    extends ExceptionWithContext {
        public NoClassesDexException(String message) {
            super(message);
        }
    }
}

