/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.ArrayList;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.Debug.DebugInstructionIterator;
import org.jf.dexlib.Debug.DebugOpcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.IndexedSection;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.Leb128Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugInfoItem
extends Item<DebugInfoItem> {
    private int lineStart;
    private StringIdItem[] parameterNames;
    private byte[] encodedDebugInfo;
    private Item[] referencedItems;
    private CodeItem parent = null;

    public DebugInfoItem(DexFile dexFile) {
        super(dexFile);
    }

    private DebugInfoItem(DexFile dexFile, int lineStart, StringIdItem[] parameterNames, byte[] encodedDebugInfo, Item[] referencedItems) {
        super(dexFile);
        this.lineStart = lineStart;
        this.parameterNames = parameterNames;
        this.encodedDebugInfo = encodedDebugInfo;
        this.referencedItems = referencedItems;
    }

    public static DebugInfoItem internDebugInfoItem(DexFile dexFile, int lineStart, StringIdItem[] parameterNames, byte[] encodedDebugInfo, Item[] referencedItems) {
        DebugInfoItem debugInfoItem = new DebugInfoItem(dexFile, lineStart, parameterNames, encodedDebugInfo, referencedItems);
        return dexFile.DebugInfoItemsSection.intern(debugInfoItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.lineStart = in.readUnsignedLeb128();
        this.parameterNames = new StringIdItem[in.readUnsignedLeb128()];
        IndexedSection<StringIdItem> stringIdSection = this.dexFile.StringIdsSection;
        for (int i = 0; i < this.parameterNames.length; ++i) {
            this.parameterNames[i] = stringIdSection.getOptionalItemByIndex(in.readUnsignedLeb128() - 1);
        }
        int start = in.getCursor();
        final ArrayList referencedItemsList = new ArrayList(50);
        DebugInstructionIterator.IterateInstructions(in, new DebugInstructionIterator.ProcessRawDebugInstructionDelegate(){

            public void ProcessStartLocal(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, boolean registerIsSigned) {
                if (nameIndex != -1) {
                    referencedItemsList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(nameIndex));
                }
                if (typeIndex != -1) {
                    referencedItemsList.add(DebugInfoItem.this.dexFile.TypeIdsSection.getItemByIndex(typeIndex));
                }
            }

            public void ProcessStartLocalExtended(int startDebugOffset, int length, int registerNume, int nameIndex, int typeIndex, int signatureIndex, boolean registerIsSigned) {
                if (nameIndex != -1) {
                    referencedItemsList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(nameIndex));
                }
                if (typeIndex != -1) {
                    referencedItemsList.add(DebugInfoItem.this.dexFile.TypeIdsSection.getItemByIndex(typeIndex));
                }
                if (signatureIndex != -1) {
                    referencedItemsList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(signatureIndex));
                }
            }

            public void ProcessSetFile(int startDebugOffset, int length, int nameIndex) {
                if (nameIndex != -1) {
                    referencedItemsList.add(DebugInfoItem.this.dexFile.StringIdsSection.getItemByIndex(nameIndex));
                }
            }
        });
        this.referencedItems = new Item[referencedItemsList.size()];
        referencedItemsList.toArray(this.referencedItems);
        int length = in.getCursor() - start;
        in.setCursor(start);
        this.encodedDebugInfo = in.readBytes(length);
    }

    @Override
    protected int placeItem(int offset) {
        offset += Leb128Utils.unsignedLeb128Size(this.lineStart);
        offset += Leb128Utils.unsignedLeb128Size(this.parameterNames.length);
        for (StringIdItem parameterName : this.parameterNames) {
            int indexp1 = parameterName == null ? 0 : parameterName.getIndex() + 1;
            offset += Leb128Utils.unsignedLeb128Size(indexp1);
        }
        class ProcessDebugInstructionDelegateWithLength
        extends DebugInstructionIterator.ProcessRawDebugInstructionDelegate {
            public int length = 0;

            ProcessDebugInstructionDelegateWithLength() {
            }
        }
        ProcessDebugInstructionDelegateWithLength pdidwl = new ProcessDebugInstructionDelegateWithLength(){
            private int referencedItemsPosition = 0;
            {
            }

            public void ProcessStaticOpcode(DebugOpcode opcode, int startDebugOffset, int length) {
                this.length += length;
            }

            public void ProcessStartLocal(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, boolean registerIsSigned) {
                ++this.length;
                this.length = DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && registerIsSigned ? (this.length += Leb128Utils.signedLeb128Size(registerNum)) : (this.length += Leb128Utils.unsignedLeb128Size(registerNum));
                this.length = nameIndex != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
                this.length = typeIndex != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
            }

            public void ProcessStartLocalExtended(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, int signatureIndex, boolean registerIsSigned) {
                ++this.length;
                this.length = DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && registerIsSigned ? (this.length += Leb128Utils.signedLeb128Size(registerNum)) : (this.length += Leb128Utils.unsignedLeb128Size(registerNum));
                this.length = nameIndex != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
                this.length = typeIndex != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
                this.length = signatureIndex != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
            }

            public void ProcessSetFile(int startDebugOffset, int length, int nameIndex) {
                ++this.length;
                this.length = nameIndex != -1 ? (this.length += Leb128Utils.unsignedLeb128Size(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1)) : ++this.length;
            }
        };
        DebugInstructionIterator.IterateInstructions(new ByteArrayInput(this.encodedDebugInfo), pdidwl);
        return offset + pdidwl.length;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            this.writeItemWithAnnotations(out);
        } else {
            this.writeItemWithNoAnnotations(out);
        }
    }

    protected void setEncodedDebugInfo(byte[] encodedDebugInfo) {
        this.encodedDebugInfo = encodedDebugInfo;
    }

    private void writeItemWithNoAnnotations(final AnnotatedOutput out) {
        out.writeUnsignedLeb128(this.lineStart);
        out.writeUnsignedLeb128(this.parameterNames.length);
        for (StringIdItem parameterName : this.parameterNames) {
            int indexp1 = parameterName == null ? 0 : parameterName.getIndex() + 1;
            out.writeUnsignedLeb128(indexp1);
        }
        DebugInstructionIterator.IterateInstructions(new ByteArrayInput(this.encodedDebugInfo), new DebugInstructionIterator.ProcessRawDebugInstructionDelegate(){
            private int referencedItemsPosition = 0;

            public void ProcessStaticOpcode(DebugOpcode opcode, int startDebugOffset, int length) {
                out.write(DebugInfoItem.this.encodedDebugInfo, startDebugOffset, length);
            }

            public void ProcessStartLocal(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, boolean registerIsSigned) {
                out.writeByte(DebugOpcode.DBG_START_LOCAL.value);
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && registerIsSigned) {
                    out.writeSignedLeb128(registerNum);
                } else {
                    out.writeUnsignedLeb128(registerNum);
                }
                if (nameIndex != -1) {
                    out.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    out.writeByte(0);
                }
                if (typeIndex != -1) {
                    out.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    out.writeByte(0);
                }
            }

            public void ProcessStartLocalExtended(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, int signatureIndex, boolean registerIsSigned) {
                out.writeByte(DebugOpcode.DBG_START_LOCAL_EXTENDED.value);
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && registerIsSigned) {
                    out.writeSignedLeb128(registerNum);
                } else {
                    out.writeUnsignedLeb128(registerNum);
                }
                if (nameIndex != -1) {
                    out.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    out.writeByte(0);
                }
                if (typeIndex != -1) {
                    out.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    out.writeByte(0);
                }
                if (signatureIndex != -1) {
                    out.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    out.writeByte(0);
                }
            }

            public void ProcessSetFile(int startDebugOffset, int length, int nameIndex) {
                out.writeByte(DebugOpcode.DBG_SET_FILE.value);
                if (nameIndex != -1) {
                    out.writeUnsignedLeb128(DebugInfoItem.this.referencedItems[this.referencedItemsPosition++].getIndex() + 1);
                } else {
                    out.writeByte(0);
                }
            }
        });
    }

    private void writeItemWithAnnotations(final AnnotatedOutput out) {
        out.annotate(0, this.parent.getParent().method.getMethodString());
        out.annotate("line_start: 0x" + Integer.toHexString(this.lineStart) + " (" + this.lineStart + ")");
        out.writeUnsignedLeb128(this.lineStart);
        out.annotate("parameters_size: 0x" + Integer.toHexString(this.parameterNames.length) + " (" + this.parameterNames.length + ")");
        out.writeUnsignedLeb128(this.parameterNames.length);
        int index = 0;
        for (StringIdItem parameterName : this.parameterNames) {
            int indexp1;
            if (parameterName == null) {
                out.annotate("[" + index++ + "] parameterName: ");
                indexp1 = 0;
            } else {
                out.annotate("[" + index++ + "] parameterName: " + parameterName.getStringValue());
                indexp1 = parameterName.getIndex() + 1;
            }
            out.writeUnsignedLeb128(indexp1);
        }
        DebugInstructionIterator.IterateInstructions(new ByteArrayInput(this.encodedDebugInfo), new DebugInstructionIterator.ProcessRawDebugInstructionDelegate(){
            private int referencedItemsPosition = 0;

            public void ProcessEndSequence(int startDebugOffset) {
                out.annotate("DBG_END_SEQUENCE");
                out.writeByte(DebugOpcode.DBG_END_SEQUENCE.value);
            }

            public void ProcessAdvancePC(int startDebugOffset, int length, int addressDiff) {
                out.annotate("DBG_ADVANCE_PC");
                out.writeByte(DebugOpcode.DBG_ADVANCE_PC.value);
                out.indent();
                out.annotate("addr_diff: 0x" + Integer.toHexString(addressDiff) + " (" + addressDiff + ")");
                out.writeUnsignedLeb128(addressDiff);
                out.deindent();
            }

            public void ProcessAdvanceLine(int startDebugOffset, int length, int lineDiff) {
                out.annotate("DBG_ADVANCE_LINE");
                out.writeByte(DebugOpcode.DBG_ADVANCE_LINE.value);
                out.indent();
                out.annotate("line_diff: 0x" + Integer.toHexString(lineDiff) + " (" + lineDiff + ")");
                out.writeSignedLeb128(lineDiff);
                out.deindent();
            }

            public void ProcessStartLocal(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, boolean registerIsSigned) {
                out.annotate("DBG_START_LOCAL");
                out.writeByte(DebugOpcode.DBG_START_LOCAL.value);
                out.indent();
                out.annotate("register_num: 0x" + Integer.toHexString(registerNum) + " (" + registerNum + ")");
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && registerIsSigned) {
                    out.writeSignedLeb128(registerNum);
                } else {
                    out.writeUnsignedLeb128(registerNum);
                }
                if (nameIndex != -1) {
                    Item nameItem = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (nameItem instanceof StringIdItem);
                    out.annotate("name: " + ((StringIdItem)nameItem).getStringValue());
                    out.writeUnsignedLeb128(nameItem.getIndex() + 1);
                } else {
                    out.annotate("name: ");
                    out.writeByte(0);
                }
                if (typeIndex != -1) {
                    Item typeItem = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (typeItem instanceof TypeIdItem);
                    out.annotate("type: " + ((TypeIdItem)typeItem).getTypeDescriptor());
                    out.writeUnsignedLeb128(typeItem.getIndex() + 1);
                } else {
                    out.annotate("type: ");
                    out.writeByte(0);
                }
                out.deindent();
            }

            public void ProcessStartLocalExtended(int startDebugOffset, int length, int registerNum, int nameIndex, int typeIndex, int signatureIndex, boolean registerIsSigned) {
                out.annotate("DBG_START_LOCAL_EXTENDED");
                out.writeByte(DebugOpcode.DBG_START_LOCAL_EXTENDED.value);
                out.indent();
                out.annotate("register_num: 0x" + Integer.toHexString(registerNum) + " (" + registerNum + ")");
                if (DebugInfoItem.this.dexFile.getPreserveSignedRegisters() && registerIsSigned) {
                    out.writeSignedLeb128(registerNum);
                } else {
                    out.writeUnsignedLeb128(registerNum);
                }
                if (nameIndex != -1) {
                    Item nameItem = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (nameItem instanceof StringIdItem);
                    out.annotate("name: " + ((StringIdItem)nameItem).getStringValue());
                    out.writeUnsignedLeb128(nameItem.getIndex() + 1);
                } else {
                    out.annotate("name: ");
                    out.writeByte(0);
                }
                if (typeIndex != -1) {
                    Item typeItem = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (typeItem instanceof TypeIdItem);
                    out.annotate("type: " + ((TypeIdItem)typeItem).getTypeDescriptor());
                    out.writeUnsignedLeb128(typeItem.getIndex() + 1);
                } else {
                    out.annotate("type: ");
                    out.writeByte(0);
                }
                if (signatureIndex != -1) {
                    Item signatureItem = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (signatureItem instanceof StringIdItem);
                    out.annotate("signature: " + ((StringIdItem)signatureItem).getStringValue());
                    out.writeUnsignedLeb128(signatureItem.getIndex() + 1);
                } else {
                    out.annotate("signature: ");
                    out.writeByte(0);
                }
                out.deindent();
            }

            public void ProcessEndLocal(int startDebugOffset, int length, int registerNum, boolean registerIsSigned) {
                out.annotate("DBG_END_LOCAL");
                out.writeByte(DebugOpcode.DBG_END_LOCAL.value);
                out.annotate("register_num: 0x" + Integer.toHexString(registerNum) + " (" + registerNum + ")");
                if (registerIsSigned) {
                    out.writeSignedLeb128(registerNum);
                } else {
                    out.writeUnsignedLeb128(registerNum);
                }
            }

            public void ProcessRestartLocal(int startDebugOffset, int length, int registerNum, boolean registerIsSigned) {
                out.annotate("DBG_RESTART_LOCAL");
                out.writeByte(DebugOpcode.DBG_RESTART_LOCAL.value);
                out.annotate("register_num: 0x" + Integer.toHexString(registerNum) + " (" + registerNum + ")");
                if (registerIsSigned) {
                    out.writeSignedLeb128(registerNum);
                } else {
                    out.writeUnsignedLeb128(registerNum);
                }
            }

            public void ProcessSetPrologueEnd(int startDebugOffset) {
                out.annotate("DBG_SET_PROLOGUE_END");
                out.writeByte(DebugOpcode.DBG_SET_PROLOGUE_END.value);
            }

            public void ProcessSetEpilogueBegin(int startDebugOffset) {
                out.annotate("DBG_SET_EPILOGUE_BEGIN");
                out.writeByte(DebugOpcode.DBG_SET_EPILOGUE_BEGIN.value);
            }

            public void ProcessSetFile(int startDebugOffset, int length, int nameIndex) {
                out.annotate("DBG_SET_FILE");
                out.writeByte(DebugOpcode.DBG_SET_FILE.value);
                if (nameIndex != -1) {
                    Item sourceItem = DebugInfoItem.this.referencedItems[this.referencedItemsPosition++];
                    assert (sourceItem instanceof StringIdItem);
                    out.annotate("source_file: \"" + ((StringIdItem)sourceItem).getStringValue() + "\"");
                    out.writeUnsignedLeb128(sourceItem.getIndex() + 1);
                } else {
                    out.annotate("source_file: ");
                    out.writeByte(0);
                }
            }

            public void ProcessSpecialOpcode(int startDebugOffset, int debugOpcode, int lineDiff, int addressDiff) {
                out.annotate("DBG_SPECIAL_OPCODE: line_diff=0x" + Integer.toHexString(lineDiff) + "(" + lineDiff + "),addressDiff=0x" + Integer.toHexString(addressDiff) + "(" + addressDiff + ")");
                out.writeByte(debugOpcode);
            }
        });
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_DEBUG_INFO_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "debug_info_item @0x" + Integer.toHexString(this.getOffset());
    }

    @Override
    public int compareTo(DebugInfoItem other) {
        if (this.parent == null) {
            if (other.parent == null) {
                return 0;
            }
            return -1;
        }
        if (other.parent == null) {
            return 1;
        }
        return this.parent.compareTo(other.parent);
    }

    protected void setParent(CodeItem codeItem) {
        this.parent = codeItem;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public byte[] getEncodedDebugInfo() {
        return this.encodedDebugInfo;
    }

    public StringIdItem[] getParameterNames() {
        return this.parameterNames;
    }
}

