/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.List;
import org.jf.baksmali.Adaptors.AnnotationFormatter;
import org.jf.baksmali.Adaptors.FieldDefinition;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.Code.Format.Instruction21c;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.SparseArray;
import org.jf.util.IndentingWriter;

public class ClassDefinition {
    private ClassDefItem classDefItem;
    private ClassDataItem classDataItem;
    private SparseArray<AnnotationSetItem> methodAnnotationsMap;
    private SparseArray<AnnotationSetItem> fieldAnnotationsMap;
    private SparseArray<AnnotationSetRefList> parameterAnnotationsMap;
    private SparseArray<FieldIdItem> fieldsSetInStaticConstructor;
    protected boolean validationErrors;

    public ClassDefinition(ClassDefItem classDefItem) {
        this.classDefItem = classDefItem;
        this.classDataItem = classDefItem.getClassData();
        this.buildAnnotationMaps();
        this.findFieldsSetInStaticConstructor();
    }

    public boolean hadValidationErrors() {
        return this.validationErrors;
    }

    private void buildAnnotationMaps() {
        AnnotationDirectoryItem annotationDirectory = this.classDefItem.getAnnotations();
        if (annotationDirectory == null) {
            this.methodAnnotationsMap = new SparseArray(0);
            this.fieldAnnotationsMap = new SparseArray(0);
            this.parameterAnnotationsMap = new SparseArray(0);
            return;
        }
        this.methodAnnotationsMap = new SparseArray(annotationDirectory.getMethodAnnotationCount());
        annotationDirectory.iterateMethodAnnotations(new AnnotationDirectoryItem.MethodAnnotationIteratorDelegate(){

            public void processMethodAnnotations(MethodIdItem method, AnnotationSetItem methodAnnotations) {
                ClassDefinition.this.methodAnnotationsMap.put(method.getIndex(), methodAnnotations);
            }
        });
        this.fieldAnnotationsMap = new SparseArray(annotationDirectory.getFieldAnnotationCount());
        annotationDirectory.iterateFieldAnnotations(new AnnotationDirectoryItem.FieldAnnotationIteratorDelegate(){

            public void processFieldAnnotations(FieldIdItem field, AnnotationSetItem fieldAnnotations) {
                ClassDefinition.this.fieldAnnotationsMap.put(field.getIndex(), fieldAnnotations);
            }
        });
        this.parameterAnnotationsMap = new SparseArray(annotationDirectory.getParameterAnnotationCount());
        annotationDirectory.iterateParameterAnnotations(new AnnotationDirectoryItem.ParameterAnnotationIteratorDelegate(){

            public void processParameterAnnotations(MethodIdItem method, AnnotationSetRefList parameterAnnotations) {
                ClassDefinition.this.parameterAnnotationsMap.put(method.getIndex(), parameterAnnotations);
            }
        });
    }

    private void findFieldsSetInStaticConstructor() {
        this.fieldsSetInStaticConstructor = new SparseArray();
        if (this.classDataItem == null) {
            return;
        }
        for (ClassDataItem.EncodedMethod directMethod : this.classDataItem.getDirectMethods()) {
            if (!directMethod.method.getMethodName().getStringValue().equals("<clinit>") || directMethod.codeItem == null) continue;
            for (Instruction instruction : directMethod.codeItem.getInstructions()) {
                switch (instruction.opcode) {
                    case SPUT: 
                    case SPUT_BOOLEAN: 
                    case SPUT_BYTE: 
                    case SPUT_CHAR: 
                    case SPUT_OBJECT: 
                    case SPUT_SHORT: 
                    case SPUT_WIDE: {
                        Instruction21c ins = (Instruction21c)instruction;
                        FieldIdItem fieldIdItem = (FieldIdItem)ins.getReferencedItem();
                        this.fieldsSetInStaticConstructor.put(fieldIdItem.getIndex(), fieldIdItem);
                    }
                }
            }
        }
    }

    public void writeTo(IndentingWriter writer) throws IOException {
        this.writeClass(writer);
        this.writeSuper(writer);
        this.writeSourceFile(writer);
        this.writeInterfaces(writer);
        this.writeAnnotations(writer);
        this.writeStaticFields(writer);
        this.writeInstanceFields(writer);
        this.writeDirectMethods(writer);
        this.writeVirtualMethods(writer);
    }

    private void writeClass(IndentingWriter writer) throws IOException {
        writer.write(".class ");
        this.writeAccessFlags(writer);
        writer.write(this.classDefItem.getClassType().getTypeDescriptor());
        writer.write(10);
    }

    private void writeAccessFlags(IndentingWriter writer) throws IOException {
        for (AccessFlags accessFlag : AccessFlags.getAccessFlagsForClass(this.classDefItem.getAccessFlags())) {
            writer.write(accessFlag.toString());
            writer.write(32);
        }
    }

    private void writeSuper(IndentingWriter writer) throws IOException {
        TypeIdItem superClass = this.classDefItem.getSuperclass();
        if (superClass != null) {
            writer.write(".super ");
            writer.write(superClass.getTypeDescriptor());
            writer.write(10);
        }
    }

    private void writeSourceFile(IndentingWriter writer) throws IOException {
        StringIdItem sourceFile = this.classDefItem.getSourceFile();
        if (sourceFile != null) {
            writer.write(".source \"");
            writer.write(sourceFile.getStringValue());
            writer.write("\"\n");
        }
    }

    private void writeInterfaces(IndentingWriter writer) throws IOException {
        TypeListItem interfaceList = this.classDefItem.getInterfaces();
        if (interfaceList == null) {
            return;
        }
        List<TypeIdItem> interfaces = interfaceList.getTypes();
        if (interfaces == null || interfaces.size() == 0) {
            return;
        }
        writer.write(10);
        writer.write("# interfaces\n");
        for (TypeIdItem typeIdItem : interfaceList.getTypes()) {
            writer.write(".implements ");
            writer.write(typeIdItem.getTypeDescriptor());
            writer.write(10);
        }
    }

    private void writeAnnotations(IndentingWriter writer) throws IOException {
        AnnotationDirectoryItem annotationDirectory = this.classDefItem.getAnnotations();
        if (annotationDirectory == null) {
            return;
        }
        AnnotationSetItem annotationSet = annotationDirectory.getClassAnnotations();
        if (annotationSet == null) {
            return;
        }
        writer.write("\n\n");
        writer.write("# annotations\n");
        AnnotationFormatter.writeTo(writer, annotationSet);
    }

    private void writeStaticFields(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        assert (this.classDefItem != null);
        EncodedArrayItem encodedStaticInitializers = this.classDefItem.getStaticFieldInitializers();
        EncodedValue[] staticInitializers = encodedStaticInitializers != null ? encodedStaticInitializers.getEncodedArray().values : new EncodedValue[]{};
        ClassDataItem.EncodedField[] encodedFields = this.classDataItem.getStaticFields();
        if (encodedFields == null || encodedFields.length == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# static fields\n");
        boolean first = true;
        for (int i = 0; i < encodedFields.length; ++i) {
            if (!first) {
                writer.write(10);
            }
            first = false;
            ClassDataItem.EncodedField field = encodedFields[i];
            EncodedValue encodedValue = null;
            if (i < staticInitializers.length) {
                encodedValue = staticInitializers[i];
            }
            AnnotationSetItem annotationSet = this.fieldAnnotationsMap.get(field.field.getIndex());
            boolean setInStaticConstructor = this.fieldsSetInStaticConstructor.get(field.field.getIndex()) != null;
            FieldDefinition.writeTo(writer, field, encodedValue, annotationSet, setInStaticConstructor);
        }
    }

    private void writeInstanceFields(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        ClassDataItem.EncodedField[] encodedFields = this.classDataItem.getInstanceFields();
        if (encodedFields == null || encodedFields.length == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# instance fields\n");
        boolean first = true;
        for (ClassDataItem.EncodedField field : this.classDataItem.getInstanceFields()) {
            if (!first) {
                writer.write(10);
            }
            first = false;
            AnnotationSetItem annotationSet = this.fieldAnnotationsMap.get(field.field.getIndex());
            FieldDefinition.writeTo(writer, field, null, annotationSet, false);
        }
    }

    private void writeDirectMethods(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        ClassDataItem.EncodedMethod[] directMethods = this.classDataItem.getDirectMethods();
        if (directMethods == null || directMethods.length == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# direct methods\n");
        this.writeMethods(writer, directMethods);
    }

    private void writeVirtualMethods(IndentingWriter writer) throws IOException {
        if (this.classDataItem == null) {
            return;
        }
        ClassDataItem.EncodedMethod[] virtualMethods = this.classDataItem.getVirtualMethods();
        if (virtualMethods == null || virtualMethods.length == 0) {
            return;
        }
        writer.write("\n\n");
        writer.write("# virtual methods\n");
        this.writeMethods(writer, virtualMethods);
    }

    private void writeMethods(IndentingWriter writer, ClassDataItem.EncodedMethod[] methods) throws IOException {
        boolean first = true;
        for (ClassDataItem.EncodedMethod method : methods) {
            if (!first) {
                writer.write(10);
            }
            first = false;
            AnnotationSetItem annotationSet = this.methodAnnotationsMap.get(method.method.getIndex());
            AnnotationSetRefList parameterAnnotationList = this.parameterAnnotationsMap.get(method.method.getIndex());
            MethodDefinition methodDefinition = new MethodDefinition(method);
            methodDefinition.writeTo(writer, annotationSet, parameterAnnotationList);
            ValidationException validationException = methodDefinition.getValidationException();
            if (validationException == null) continue;
            System.err.println(String.format("Error while disassembling method %s. Continuing.", method.method.getMethodString()));
            validationException.printStackTrace(System.err);
            this.validationErrors = true;
        }
    }
}

