/*
 * Decompiled with CFR 0.152.
 */
package brut.util;

import brut.common.BrutException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;

public class OS {
    public static void rmdir(File dir) throws BrutException {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                OS.rmdir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    public static void cpdir(File src, File dest) throws BrutException {
        dest.mkdirs();
        File[] files = src.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            File destFile = new File(dest.getPath() + File.separatorChar + file.getName());
            if (file.isDirectory()) {
                OS.cpdir(file, destFile);
                continue;
            }
            try {
                FileInputStream in = new FileInputStream(file);
                FileOutputStream out = new FileOutputStream(destFile);
                IOUtils.copy(in, out);
                ((InputStream)in).close();
                ((OutputStream)out).close();
                continue;
            }
            catch (IOException ex) {
                throw new BrutException("Could not copy file: " + file, ex);
            }
        }
    }

    public static void exec(String[] cmd) throws BrutException {
        Process ps = null;
        try {
            ps = Runtime.getRuntime().exec(cmd);
            new StreamForwarder(ps.getInputStream(), System.err).start();
            new StreamForwarder(ps.getErrorStream(), System.err).start();
            if (ps.waitFor() != 0) {
                throw new BrutException("could not exec command: " + Arrays.toString(cmd));
            }
        }
        catch (IOException ex) {
            throw new BrutException("could not exec command: " + Arrays.toString(cmd), ex);
        }
        catch (InterruptedException ex) {
            throw new BrutException("could not exec command: " + Arrays.toString(cmd), ex);
        }
    }

    static class StreamForwarder
    extends Thread {
        private final InputStream mIn;
        private final OutputStream mOut;

        public StreamForwarder(InputStream in, OutputStream out) {
            this.mIn = in;
            this.mOut = out;
        }

        public void run() {
            try {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(this.mIn));
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.mOut));
                while ((line = in.readLine()) != null) {
                    out.write(line);
                    out.newLine();
                }
                out.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

