/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public abstract class ResScalarValue
extends ResValue
implements ResValuesXmlSerializable {
    protected final String mType;
    protected final String mRawValue;

    protected ResScalarValue(String type, String rawValue) {
        this.mType = type;
        this.mRawValue = rawValue;
    }

    public String encodeAsResXmlAttr() throws AndrolibException {
        if (this.mRawValue != null) {
            return this.mRawValue;
        }
        return this.encodeAsResXml();
    }

    public String encodeAsResXmlValue() throws AndrolibException {
        if (this.mRawValue != null) {
            return this.mRawValue;
        }
        return this.encodeAsResXml();
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        String type = res.getResSpec().getType().getName();
        boolean item = !"reference".equals(this.mType) && !type.equals(this.mType);
        String tagName = item ? "item" : type;
        serializer.startTag(null, tagName);
        if (item) {
            serializer.attribute(null, "type", type);
        }
        serializer.attribute(null, "name", res.getResSpec().getName());
        this.serializeExtraXmlAttrs(serializer, res);
        String body = this.serializeXmlBody(serializer, res);
        if (!body.isEmpty()) {
            serializer.ignorableWhitespace(body);
        }
        serializer.endTag(null, tagName);
    }

    public String getType() {
        return this.mType;
    }

    protected String serializeXmlBody(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        return this.encodeAsResXmlValue();
    }

    protected void serializeExtraXmlAttrs(XmlSerializer serializer, ResResource res) throws IOException {
    }

    protected abstract String encodeAsResXml() throws AndrolibException;
}

