/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.ValueBox;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.NewExpr;
import com.googlecode.dex2jar.ir.stmt.AssignStmt;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LookupSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.stmt.TableSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.UnopStmt;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class LocalRemove
implements Transformer {
    private static boolean canRemove(Stmt pre) {
        switch (pre.st) {
            case ASSIGN: 
            case IDENTITY: {
                AssignStmt as = (AssignStmt)pre;
                if (as.op1.value.vt != Value.VT.LOCAL) break;
                Local aLeft = (Local)as.op1.value;
                if (aLeft._ls_write_count != 1 || aLeft._ls_read_count != 1) break;
                switch (as.op2.value.vt) {
                    case THIS_REF: 
                    case PARAMETER_REF: 
                    case EXCEPTION_REF: {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static void execStmt(List<ValueBox> vbs, Stmt st, Local local) {
        switch (st.st) {
            case ASSIGN: 
            case IDENTITY: {
                AssignStmt as = (AssignStmt)st;
                if (as.op1.value.vt != Value.VT.LOCAL) {
                    LocalRemove.execValue(vbs, as.op1, local);
                }
                LocalRemove.execValue(vbs, as.op2, local);
                break;
            }
            case IF: {
                JumpStmt js = (JumpStmt)st;
                LocalRemove.execValue(vbs, js.op, local);
                break;
            }
            case LOOKUP_SWITCH: {
                LookupSwitchStmt lss = (LookupSwitchStmt)st;
                LocalRemove.execValue(vbs, lss.op, local);
                break;
            }
            case TABLE_SWITCH: {
                TableSwitchStmt tss = (TableSwitchStmt)st;
                LocalRemove.execValue(vbs, tss.op, local);
                break;
            }
            case RETURN: 
            case LOCK: 
            case UNLOCK: 
            case THROW: {
                UnopStmt us = (UnopStmt)st;
                LocalRemove.execValue(vbs, us.op, local);
            }
        }
    }

    private static void execValue(List<ValueBox> vbs, ValueBox valueBox, Local local) {
        Value toReplace = valueBox.value;
        switch (toReplace.et) {
            case E0: {
                switch (toReplace.vt) {
                    case LOCAL: {
                        vbs.add(valueBox);
                    }
                }
                break;
            }
            case E1: {
                ValueBox op = ((Value.E1Expr)toReplace).op;
                if (op == null) break;
                vbs.add(op);
                break;
            }
            case E2: {
                Value.E2Expr e2 = (Value.E2Expr)toReplace;
                switch (e2.vt) {
                    case AND: 
                    case OR: 
                    case XOR: 
                    case ADD: 
                    case MUL: {
                        if (e2.op1.value != local || e2.op1.value.vt != Value.VT.LOCAL && e2.op1.value.vt != Value.VT.CONSTANT) break;
                        ValueBox tmp = e2.op1;
                        e2.op1 = e2.op2;
                        e2.op2 = tmp;
                    }
                }
                vbs.add(e2.op1);
                vbs.add(e2.op2);
                break;
            }
            case En: {
                Value.EnExpr ie = (Value.EnExpr)toReplace;
                for (ValueBox vb : ie.ops) {
                    vbs.add(vb);
                }
                break;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void transform(IrMethod je) {
        AssignStmt nas;
        ValueBox[] vb;
        InvokeExpr ie;
        AssignStmt stmt;
        Iterator<AssignStmt> it;
        NewExpr c;
        Local aLeft;
        Stmt st;
        StmtList list = je.stmts;
        List<Stmt> orderList = list._ls_visit_order;
        block17: for (int p = 0; p < orderList.size(); ++p) {
            st = orderList.get(p);
            if (st == null || !list.contains(st)) continue;
            switch (st.st) {
                case ASSIGN: 
                case IDENTITY: {
                    AssignStmt as = (AssignStmt)st;
                    if (as.op1.value.vt != Value.VT.LOCAL) continue block17;
                    aLeft = (Local)as.op1.value;
                    if (as.op2.value.vt == Value.VT.NEW) {
                        c = (NewExpr)as.op2.value;
                        boolean replaced = false;
                        it = list._ls_inits.iterator();
                        while (it.hasNext()) {
                            stmt = it.next();
                            ie = (InvokeExpr)stmt.op2.value;
                            if (ie.ops[0].value != aLeft || !ie.methodOwnerType.equals((Object)c.type)) continue;
                            list.remove(st);
                            it.remove();
                            je.locals.remove(stmt.op1.value);
                            vb = new ValueBox[ie.ops.length - 1];
                            System.arraycopy(ie.ops, 1, vb, 0, vb.length);
                            nas = Stmts.nAssign(as.op1, new ValueBox(Exprs.nInvokeNew(vb, ie.argmentTypes, ie.methodOwnerType)));
                            list.replace(stmt, nas);
                            --aLeft._ls_read_count;
                            orderList.set(orderList.indexOf(stmt), nas);
                            replaced = true;
                            break;
                        }
                        if (replaced) continue block17;
                    }
                    if (aLeft._ls_write_count != 1) continue block17;
                    switch (as.op2.value.vt) {
                        case LOCAL: {
                            Local b = (Local)as.op2.value;
                            if (b._ls_write_count != 1) break;
                            b._ls_read_count += aLeft._ls_read_count - 1;
                            je.locals.remove(aLeft);
                            aLeft._ls_vb.value = b;
                            list.remove(st);
                            orderList.set(p, null);
                            break;
                        }
                        case CONSTANT: {
                            as.op1.value = as.op2.value;
                            je.locals.remove(aLeft);
                            list.remove(st);
                            orderList.set(p, null);
                            break;
                        }
                    }
                    continue block17;
                }
            }
        }
        ArrayList<ValueBox> vbs = new ArrayList<ValueBox>(20);
        Stack<ValueBox> tmp = new Stack<ValueBox>();
        block19: for (int p = 0; p < orderList.size(); ++p) {
            Stmt st2 = orderList.get(p);
            if (st2 == null || !list.contains(st2)) continue;
            switch (st2.st) {
                case IDENTITY: 
                case RETURN_VOID: 
                case LABEL: 
                case GOTO: 
                case NOP: {
                    continue block19;
                }
                default: {
                    Stmt pre = st2.getPre();
                    if (pre == null || !LocalRemove.canRemove(pre)) continue block19;
                    vbs.clear();
                    tmp.clear();
                    AssignStmt as = (AssignStmt)pre;
                    Local preLocal = (Local)as.op1.value;
                    LocalRemove.execStmt(vbs, st2, preLocal);
                    block20: for (ValueBox vb2 : vbs) {
                        switch (vb2.value.vt) {
                            case CONSTANT: {
                                continue block20;
                            }
                            case LOCAL: {
                                tmp.push(vb2);
                                continue block20;
                            }
                        }
                    }
                    while (!tmp.isEmpty()) {
                        ValueBox vb3 = (ValueBox)tmp.pop();
                        if (vb3.value != preLocal) continue;
                        vb3.value = as.op2.value;
                        list.remove(as);
                        je.locals.remove(preLocal);
                        pre = st2.getPre();
                        if (pre == null || !LocalRemove.canRemove(pre)) continue block19;
                        as = (AssignStmt)pre;
                        preLocal = (Local)as.op1.value;
                    }
                    break block7;
                }
            }
        }
        if (list._ls_inits.size() > 0) {
            block22: for (int p = 0; p < orderList.size(); ++p) {
                st = orderList.get(p);
                if (st == null || !list.contains(st)) continue;
                switch (st.st) {
                    case ASSIGN: 
                    case IDENTITY: {
                        AssignStmt as = (AssignStmt)st;
                        if (as.op1.value.vt != Value.VT.LOCAL) continue block22;
                        aLeft = (Local)as.op1.value;
                        if (as.op2.value.vt != Value.VT.NEW) continue block22;
                        c = (NewExpr)as.op2.value;
                        boolean replaced = false;
                        it = list._ls_inits.iterator();
                        while (it.hasNext()) {
                            stmt = it.next();
                            ie = (InvokeExpr)stmt.op2.value;
                            if (ie.ops[0].value != aLeft || !ie.methodOwnerType.equals((Object)c.type)) continue;
                            list.remove(st);
                            it.remove();
                            vb = new ValueBox[ie.ops.length - 1];
                            System.arraycopy(ie.ops, 1, vb, 0, vb.length);
                            nas = Stmts.nAssign(as.op1, new ValueBox(Exprs.nInvokeNew(vb, ie.argmentTypes, ie.methodOwnerType)));
                            list.replace(stmt, nas);
                            --aLeft._ls_read_count;
                            orderList.set(orderList.indexOf(stmt), nas);
                            replaced = true;
                            break;
                        }
                        if (!replaced) continue block22;
                        continue block22;
                    }
                }
            }
        }
        list._ls_inits = null;
    }
}

