/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir;

import com.googlecode.dex2jar.ir.ToStringUtil;
import com.googlecode.dex2jar.ir.Value;
import org.objectweb.asm.Type;

public class Constant
extends Value.E0Expr {
    public static final Object Null = new Object();
    public static Type STRING = Type.getType(String.class);
    public Type type;
    public Object value;

    public static Constant n(Type type, Object value) {
        return new Constant(type, value);
    }

    public static Constant nByte(byte i) {
        return new Constant(Type.BYTE_TYPE, i);
    }

    public static Constant nChar(char i) {
        return new Constant(Type.CHAR_TYPE, Character.valueOf(i));
    }

    public static Constant nClass(Type clz) {
        return new Constant(Type.getType((String)"Ljava/lang/Class;"), clz);
    }

    public static Constant nDouble(double i) {
        return new Constant(Type.DOUBLE_TYPE, i);
    }

    public static Constant nFloat(float i) {
        return new Constant(Type.FLOAT_TYPE, Float.valueOf(i));
    }

    public static Constant nInt(int i) {
        return new Constant(Type.INT_TYPE, i);
    }

    public static Constant nLong(long i) {
        return new Constant(Type.LONG_TYPE, i);
    }

    public static Constant nNull() {
        return new Constant(Null);
    }

    public static Constant nShort(short i) {
        return new Constant(Type.SHORT_TYPE, i);
    }

    public static Constant nString(String i) {
        return new Constant(STRING, i);
    }

    public Constant(Object value) {
        super(Value.VT.CONSTANT);
        this.value = value;
    }

    public Constant(Type type, Object value) {
        super(Value.VT.CONSTANT);
        this.value = value;
        this.type = type;
    }

    @Override
    public Value clone() {
        return new Constant(this.type, this.value);
    }

    public String toString() {
        if (Null == this.value) {
            return "null";
        }
        if (this.value == null) {
            return "NULL";
        }
        if (this.value instanceof Number) {
            if (this.value instanceof Float) {
                return this.value.toString() + "F";
            }
            if (this.value instanceof Long) {
                return this.value.toString() + "L";
            }
            return this.value.toString();
        }
        if (this.value instanceof String) {
            return "\"" + this.value + "\"";
        }
        if (this.type.equals((Object)Type.getType(Class.class))) {
            return ToStringUtil.toShortClassName((Type)this.value) + ".class";
        }
        return "" + this.value;
    }
}

