/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.util;

import com.googlecode.dex2jar.util.ASMifierClassV;
import com.googlecode.dex2jar.util.ArrayOut;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexFileVisitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;

public class ASMifierFileV
implements DexFileVisitor {
    String pkgName = "dex2jar.gen";
    File dir;
    ArrayOut file = new ArrayOut();

    public ASMifierFileV(File dir, String pkgName) {
        this.dir = dir == null ? new File(".") : dir;
        if (pkgName != null) {
            this.pkgName = pkgName;
        }
        this.file.s("package %s;", this.pkgName);
        this.file.s("import com.googlecode.dex2jar.*;");
        this.file.s("import com.googlecode.dex2jar.visitors.*;");
        this.file.s("public class Main {");
        this.file.push();
        this.file.s("public static void accept(DexFileVisitor v) {");
        this.file.push();
    }

    static void write(ArrayOut out, File file) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>(out.array.size());
        for (int i = 0; i < out.array.size(); ++i) {
            sb.setLength(0);
            int p = out.is.get(i);
            for (int j = 0; j < p; ++j) {
                sb.append("    ");
            }
            sb.append(out.array.get(i));
            list.add(sb.toString());
        }
        try {
            FileUtils.writeLines((File)file, (String)"UTF-8", list);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
        final String n = className.substring(1, className.length() - 1).replace('/', '_').replace('$', '_');
        this.file.s("%s.accept(v);", n);
        return new ASMifierClassV(this.pkgName, n, access_flags, className, superClass, interfaceNames){

            @Override
            public void visitEnd() {
                super.visitEnd();
                ASMifierFileV.write(this.out, new File(ASMifierFileV.this.dir, ASMifierFileV.this.pkgName.replace('.', '/') + '/' + n + ".java"));
            }
        };
    }

    @Override
    public void visitEnd() {
        this.file.pop();
        this.file.s("}");
        this.file.pop();
        this.file.s("}");
        ASMifierFileV.write(this.file, new File(this.dir, this.pkgName.replace('.', '/') + "/Main.java"));
    }
}

