/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodes;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.DexInternalOpcode;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import java.util.Map;

class DexOpcodeAdapter
implements DexOpcodes,
DexInternalOpcode {
    private DexCodeVisitor dcv;
    private DexFileReader dex;
    private Map<Integer, DexLabel> labels;
    private int offset;

    DexOpcodeAdapter(DexFileReader dex, Map<Integer, DexLabel> labels, DexCodeVisitor dcv) {
        this.dex = dex;
        this.labels = labels;
        this.dcv = dcv;
    }

    private DexLabel getLabel(int offset) {
        return this.labels.get(this.offset + offset);
    }

    public void offset(int currentOffset) {
        this.offset = currentOffset;
        DexLabel label = this.getLabel(0);
        if (label != null) {
            this.dcv.visitLabel(label);
        }
    }

    public void visitFillArrayStmt(int opcode, int aA, int elemWidth, int initLength, Object[] values) {
        this.dcv.visitFillArrayStmt(opcode, aA, elemWidth, initLength, values);
    }

    public void visitLookupSwitchStmt(int opcode, int aA, int defaultOffset, int[] cases, int[] iLabel) {
        DexLabel[] labels = new DexLabel[iLabel.length];
        for (int i = 0; i < iLabel.length; ++i) {
            labels[i] = this.getLabel(iLabel[i]);
        }
        this.dcv.visitLookupSwitchStmt(opcode, aA, this.getLabel(defaultOffset), cases, labels);
    }

    public void visitTableSwitchStmt(int opcode, int aA, int defaultOffset, int first_case, int last_case, int[] iLabel) {
        DexLabel[] labels = new DexLabel[iLabel.length];
        for (int i = 0; i < iLabel.length; ++i) {
            labels[i] = this.getLabel(iLabel[i]);
        }
        this.dcv.visitTableSwitchStmt(opcode, aA, this.getLabel(defaultOffset), first_case, last_case, labels);
    }

    public void x0t(int opcode, int offset) {
        switch (opcode) {
            case 40: 
            case 41: 
            case 42: {
                this.dcv.visitJumpStmt(40, this.getLabel(offset));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x0x(int opcode) {
        switch (opcode) {
            case 0: {
                break;
            }
            case 14: {
                this.dcv.visitReturnStmt(opcode);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1c(int opcode, int A, int B) {
        switch (opcode) {
            case 26: 
            case 27: {
                this.dcv.visitConstStmt(26, A, this.dex.getString(B));
                break;
            }
            case 28: {
                this.dcv.visitConstStmt(28, A, this.dex.getType(B));
                break;
            }
            case 31: 
            case 34: {
                this.dcv.visitClassStmt(opcode, A, this.dex.getType(B));
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                this.dcv.visitFieldStmt(96, A, this.dex.getField(B));
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                this.dcv.visitFieldStmt(103, A, this.dex.getField(B));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1h(int opcode, int A, int B) {
        switch (opcode) {
            case 21: {
                this.dcv.visitConstStmt(20, A, B << 16);
                break;
            }
            case 25: {
                this.dcv.visitConstStmt(24, A, (long)B << 48);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1i(int opcode, int aA, int bBBBBBBB) {
        switch (opcode) {
            case 20: {
                this.dcv.visitConstStmt(opcode, aA, bBBBBBBB);
                break;
            }
            case 23: {
                this.dcv.visitConstStmt(24, aA, bBBBBBBB);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1l(int opcode, int aA, long bBBBBBBB_BBBBBBBB) {
        switch (opcode) {
            case 24: {
                this.dcv.visitConstStmt(opcode, aA, bBBBBBBB_BBBBBBBB);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1n(int opcode, int A, int B) {
        switch (opcode) {
            case 18: {
                this.dcv.visitConstStmt(20, A, B);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1s(int opcode, int A, int B) {
        switch (opcode) {
            case 19: {
                this.dcv.visitConstStmt(20, A, B);
                break;
            }
            case 22: {
                this.dcv.visitConstStmt(24, A, B);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1t(int opcode, int A, int offset) {
        switch (opcode) {
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                this.dcv.visitJumpStmt(opcode, A, this.getLabel(offset));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x1x(int opcode, int A) {
        switch (opcode) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                this.dcv.visitMoveStmt(opcode, A);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                this.dcv.visitReturnStmt(15, A);
                break;
            }
            case 39: {
                this.dcv.visitReturnStmt(opcode, A);
                break;
            }
            case 29: 
            case 30: {
                this.dcv.visitMonitorStmt(opcode, A);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2b(int opcode, int aA, int bB, int cC) {
        switch (opcode) {
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: {
                this.dcv.visitBinopLitXStmt(opcode - -16711680, aA, bB, cC);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2c(int opcode, int a, int b, int cCCC) {
        switch (opcode) {
            case 32: 
            case 35: {
                this.dcv.visitClassStmt(opcode, a, b, this.dex.getType(cCCC));
                break;
            }
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                this.dcv.visitFieldStmt(82, a, b, this.dex.getField(cCCC));
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.dcv.visitFieldStmt(89, a, b, this.dex.getField(cCCC));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2s(int opcode, int a, int b, int cCCC) {
        switch (opcode) {
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: {
                this.dcv.visitBinopLitXStmt(opcode - -16711688, a, b, cCCC);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2t(int opcode, int a, int b, int cCCC) {
        switch (opcode) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.dcv.visitJumpStmt(opcode, a, b, this.getLabel(cCCC));
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x2x(int opcode, int A, int B) {
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: {
                this.dcv.visitMoveStmt(1, A, B);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.dcv.visitMoveStmt(4, A, B);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                this.dcv.visitMoveStmt(7, A, B);
                break;
            }
            case 33: {
                this.dcv.visitUnopStmt(33, A, B);
                break;
            }
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                this.dcv.visitUnopStmt(opcode, A, B);
                break;
            }
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: {
                this.dcv.visitBinopStmt(opcode - 32, A, A, B);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x3x(int opcode, int aA, int bB, int cC) {
        switch (opcode) {
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                this.dcv.visitCmpStmt(opcode, aA, bB, cC);
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.dcv.visitArrayStmt(68, aA, bB, cC);
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.dcv.visitArrayStmt(75, aA, bB, cC);
                break;
            }
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: {
                this.dcv.visitBinopStmt(opcode, aA, bB, cC);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void x5c(int opcode, int b, int d, int e, int f, int g, int a, int cCCC) {
        int[] args;
        switch (b) {
            case 0: {
                args = new int[]{};
                break;
            }
            case 1: {
                args = new int[]{d};
                break;
            }
            case 2: {
                args = new int[]{d, e};
                break;
            }
            case 3: {
                args = new int[]{d, e, f};
                break;
            }
            case 4: {
                args = new int[]{d, e, f, g};
                break;
            }
            case 5: {
                args = new int[]{d, e, f, g, a};
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
        switch (opcode) {
            case 36: {
                this.dcv.visitFilledNewArrayStmt(opcode, args, this.dex.getType(cCCC));
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                Method m = this.dex.getMethod(cCCC);
                int realSize = m.getParameterTypes().length + (opcode == 113 ? 0 : 1);
                if (realSize != args.length) {
                    int[] nArgs = new int[realSize];
                    int i = 0;
                    int j = 0;
                    if (opcode != 113) {
                        nArgs[i++] = args[j++];
                    }
                    for (String t : m.getParameterTypes()) {
                        nArgs[i++] = args[j];
                        j += "J".equals(t) || "D".equals(t) ? 2 : 1;
                    }
                    this.dcv.visitMethodStmt(opcode, nArgs, m);
                    break;
                }
                this.dcv.visitMethodStmt(opcode, args, m);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }

    public void xrc(int opcode, int cCCC, int aA, int bBBB) {
        int[] args = new int[aA];
        for (int i = 0; i < aA; ++i) {
            args[i] = cCCC + i;
        }
        switch (opcode) {
            case 37: {
                this.dcv.visitFilledNewArrayStmt(36, args, this.dex.getType(bBBB));
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                int nOpcode = opcode - 6;
                Method m = this.dex.getMethod(bBBB);
                int realSize = m.getParameterTypes().length + (nOpcode == 113 ? 0 : 1);
                if (realSize != args.length) {
                    int[] nArgs = new int[realSize];
                    int i = 0;
                    int j = 0;
                    if (nOpcode != 113) {
                        nArgs[i++] = args[j++];
                    }
                    for (String t : m.getParameterTypes()) {
                        nArgs[i++] = args[j];
                        j += "J".equals(t) || "D".equals(t) ? 2 : 1;
                    }
                    this.dcv.visitMethodStmt(nOpcode, nArgs, m);
                    break;
                }
                this.dcv.visitMethodStmt(nOpcode, args, m);
                break;
            }
            default: {
                throw new RuntimeException("");
            }
        }
    }
}

