/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.DexException;
import com.googlecode.dex2jar.DexLabel;
import com.googlecode.dex2jar.DexOpcodes;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.reader.DataIn;
import com.googlecode.dex2jar.reader.DexDebugInfoReader;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.reader.DexOpcodeAdapter;
import com.googlecode.dex2jar.reader.DexOpcodeUtil;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import java.util.HashMap;
import java.util.Map;

class DexCodeReader
implements DexOpcodes {
    private DexFileReader dex;
    private DataIn in;
    Map<Integer, DexLabel> labels = new HashMap<Integer, DexLabel>();
    private boolean isStatic;
    private Method method;

    DexCodeReader(DexFileReader dex, DataIn in, boolean isStatic, Method method) {
        this.dex = dex;
        this.in = in;
        this.method = method;
        this.isStatic = isStatic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void findLabels(DataIn in, int instruction_size) {
        baseOffset = in.getCurrentPosition();
        currentOffset = 0;
        while (currentOffset < instruction_size) {
            block25: {
                opcode = in.readByte() & 255;
                try {
                    block2 : switch (opcode) {
                        case 40: {
                            this.order(currentOffset + in.readByte());
                            break;
                        }
                        case 41: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: {
                            in.skip(1);
                            this.order(currentOffset + in.readShortx());
                            break;
                        }
                        case 42: {
                            in.skip(1);
                            this.order(currentOffset + in.readIntx());
                            break;
                        }
                        case 43: 
                        case 44: {
                            in.skip(1);
                            offset = in.readIntx();
                            in.push();
                            try {
                                in.skip((offset - 3) * 2);
                                switch (opcode) {
                                    case 44: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        in.skip(4 * switch_size);
                                        for (j = 0; j < switch_size; ++j) {
                                            this.order(currentOffset + in.readIntx());
                                        }
                                        this.order(currentOffset + 3);
                                        ** break;
lbl34:
                                        // 1 sources

                                        break block25;
                                    }
                                    case 43: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        in.skip(4);
                                        for (j = 0; j < switch_size; ++j) {
                                            targetOffset = in.readIntx();
                                            this.order(currentOffset + targetOffset);
                                        }
                                        this.order(currentOffset + 3);
                                        break block25;
                                    }
                                    ** default:
lbl46:
                                    // 1 sources

                                    break block25;
                                }
                            }
                            finally {
                                in.pop();
                            }
                        }
                        case 0: {
                            x = in.readByte();
                            switch (x) {
                                case 0: {
                                    break block2;
                                }
                                case 1: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 4 + 4);
                                    break block2;
                                }
                                case 2: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 8);
                                    break block2;
                                }
                                case 3: {
                                    element_width = in.readUShortx();
                                    size = in.readUIntx();
                                    in.skip(size * element_width + 1 & -2);
                                    break block2;
                                }
                            }
                            break;
                        }
                        default: {
                            size = DexOpcodeUtil.length(opcode);
                            in.skip(size * 2 - 1);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    throw new DexException(e, String.format("while scan for label, Posotion :%04x", new Object[]{currentOffset}), new Object[0]);
                }
            }
            currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findTryCatch(DataIn in, DexCodeVisitor dcv, int tries_size) {
        int encoded_catch_handler_list = in.getCurrentPosition() + tries_size * 8;
        for (int i = 0; i < tries_size; ++i) {
            int start_addr = in.readUIntx();
            int insn_count = in.readUShortx();
            int handler_offset = in.readUShortx();
            this.order(start_addr);
            int end = start_addr + insn_count;
            this.order(end);
            in.pushMove(encoded_catch_handler_list + handler_offset);
            try {
                boolean catchAll = false;
                int listSize = (int)in.readLeb128();
                if (listSize <= 0) {
                    listSize = -listSize;
                    catchAll = true;
                }
                for (int k = 0; k < listSize; ++k) {
                    int type_id = (int)in.readULeb128();
                    int handler = (int)in.readULeb128();
                    this.order(handler);
                    String type = this.dex.getType(type_id);
                    dcv.visitTryCatch(this.labels.get(start_addr), this.labels.get(end), this.labels.get(handler), type);
                }
                if (!catchAll) continue;
                int handler = (int)in.readULeb128();
                this.order(handler);
                dcv.visitTryCatch(this.labels.get(start_addr), this.labels.get(end), this.labels.get(handler), null);
                continue;
            }
            finally {
                in.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(DexCodeVisitor dcv, int config) {
        int args_index;
        int[] args;
        DataIn in = this.in;
        int total_registers_size = in.readUShortx();
        int in_register_size = in.readUShortx();
        in.skip(2);
        int tries_size = in.readUShortx();
        int debug_off = in.readUIntx();
        int instruction_size = in.readUIntx();
        DexDebugInfoReader.LocalVariable[] localVariables = new DexDebugInfoReader.LocalVariable[total_registers_size];
        int i = total_registers_size - in_register_size;
        String[] parameterTypes = this.method.getParameterTypes();
        if (!this.isStatic) {
            args = new int[parameterTypes.length + 1];
            localVariables[i] = new DexDebugInfoReader.LocalVariable(i, 0, -1, "this", this.method.getOwner(), null);
            args[0] = i++;
            args_index = 1;
        } else {
            args = new int[parameterTypes.length];
            args_index = 0;
        }
        for (String type : parameterTypes) {
            localVariables[i] = new DexDebugInfoReader.LocalVariable(i, 0, -1, "arg" + args_index, type, null);
            args[args_index++] = i++;
            if (!"D".equals(type) && !"J".equals(type)) continue;
            ++i;
        }
        dcv.visitArguments(total_registers_size, args);
        if (tries_size > 0) {
            in.push();
            try {
                in.skip(instruction_size * 2);
                if ((instruction_size & 1) != 0) {
                    in.skip(2);
                }
                this.findTryCatch(in, dcv, tries_size);
            }
            finally {
                in.pop();
            }
        }
        if (debug_off != 0 && 0 == (config & 1)) {
            in.pushMove(debug_off);
            try {
                new DexDebugInfoReader(in, this.dex, instruction_size, this, localVariables, args).accept(dcv);
            }
            finally {
                in.pop();
            }
        }
        in.push();
        try {
            this.findLabels(in, instruction_size);
        }
        finally {
            in.pop();
        }
        DexOpcodeAdapter n = new DexOpcodeAdapter(this.dex, this.labels, dcv);
        this.acceptInsn(in, instruction_size, n);
        dcv.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void acceptInsn(DataIn in, int instruction_size, DexOpcodeAdapter n) {
        currentOffset = 0;
        baseOffset = in.getCurrentPosition();
        while (true) {
            if (currentOffset >= instruction_size) {
                n.offset(currentOffset);
                return;
            }
            opcode = in.readByte() & 255;
            n.offset(currentOffset);
            format = DexOpcodeUtil.format(opcode);
            block1 : switch (format) {
                case 1: {
                    n.x0t(opcode, (byte)(in.readByte() & 255));
                    break;
                }
                case 2: {
                    x = in.readByte();
                    switch (opcode) {
                        case 0: {
                            switch (x) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 4 + 4);
                                    break;
                                }
                                case 2: {
                                    switch_size = in.readUShortx();
                                    in.skip(switch_size * 8);
                                    break;
                                }
                                case 3: {
                                    element_width = in.readUShortx();
                                    size = in.readUIntx();
                                    in.skip(size * element_width + 1 & -2);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                    n.x0x(opcode);
                    break;
                }
                case 3: {
                    VV = in.readByte();
                    B = VV >> 4;
                    n.x1n(opcode, VV & 15, B);
                    break;
                }
                case 4: {
                    n.x1x(opcode, in.readUByte());
                    break;
                }
                case 5: {
                    VV = in.readUByte();
                    n.x2x(opcode, VV & 15, VV >>> 4);
                    break;
                }
                case 6: {
                    in.skip(1);
                    n.x0t(opcode, in.readShortx());
                    break;
                }
                case 7: {
                    AA = in.readUByte();
                    BBBB = in.readUShortx();
                    n.x1c(opcode, AA, BBBB);
                    break;
                }
                case 8: {
                    A = in.readUByte();
                    B = in.readShortx();
                    n.x1h(opcode, A, B);
                    break;
                }
                case 9: {
                    AA = in.readUByte();
                    BBBBB = in.readShortx();
                    n.x1s(opcode, AA, BBBBB);
                    break;
                }
                case 10: {
                    AA = in.readUByte();
                    BBBB = in.readShortx();
                    n.x1t(opcode, AA, BBBB);
                    break;
                }
                case 11: {
                    AA = in.readUByte();
                    BB = in.readUByte();
                    CC = in.readByte();
                    n.x2b(opcode, AA, BB, CC);
                    break;
                }
                case 12: {
                    VV = in.readUByte();
                    A = VV & 15;
                    B = VV >>> 4;
                    CCCC = in.readUShortx();
                    n.x2c(opcode, A, B, CCCC);
                    break;
                }
                case 13: {
                    VV = in.readUByte();
                    A = VV & 15;
                    B = VV >>> 4;
                    CCCC = in.readShortx();
                    n.x2s(opcode, A, B, CCCC);
                    break;
                }
                case 14: {
                    VV = in.readUByte();
                    A = VV & 15;
                    B = VV >>> 4;
                    CCCC = in.readShortx();
                    n.x2t(opcode, A, B, CCCC);
                    break;
                }
                case 15: {
                    AA = in.readUByte();
                    BBBB = in.readUShortx();
                    n.x2x(opcode, AA, BBBB);
                    break;
                }
                case 16: {
                    AA = in.readUByte();
                    BB = in.readUByte();
                    CC = in.readUByte();
                    n.x3x(opcode, AA, BB, CC);
                    break;
                }
                case 17: {
                    in.skip(1);
                    n.x0t(opcode, in.readIntx());
                    break;
                }
                case 18: {
                    AA = in.readUByte();
                    BBBBBBBB = in.readUIntx();
                    n.x1c(opcode, AA, BBBBBBBB);
                    break;
                }
                case 19: {
                    AA = in.readUByte();
                    BBBBBBBB = in.readIntx();
                    n.x1i(opcode, AA, BBBBBBBB);
                    break;
                }
                case 20: {
                    AA = in.readUByte();
                    BBBBBBBB = in.readIntx();
                    switch (opcode) {
                        case 38: 
                        case 43: 
                        case 44: {
                            in.push();
                            try {
                                in.skip((BBBBBBBB - 3) * 2);
                                switch (opcode) {
                                    case 44: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        cases = new int[switch_size];
                                        label = new int[switch_size];
                                        for (j = 0; j < switch_size; ++j) {
                                            cases[j] = in.readIntx();
                                        }
                                        for (j = 0; j < switch_size; ++j) {
                                            label[j] = in.readIntx();
                                        }
                                        n.visitLookupSwitchStmt(opcode, AA, 3, cases, label);
                                        ** break;
lbl147:
                                        // 1 sources

                                        break block1;
                                    }
                                    case 43: {
                                        in.skip(2);
                                        switch_size = in.readUShortx();
                                        first_case = in.readIntx();
                                        last_case = first_case - 1 + switch_size;
                                        _labels = new int[switch_size];
                                        for (j = 0; j < switch_size; ++j) {
                                            _labels[j] = targetOffset = in.readIntx();
                                        }
                                        n.visitTableSwitchStmt(opcode, AA, 3, first_case, last_case, _labels);
                                        ** break;
lbl159:
                                        // 1 sources

                                        break block1;
                                    }
                                    case 38: {
                                        in.skip(2);
                                        elemWidth = in.readUShortx();
                                        initLength = in.readUIntx();
                                        values = new Object[initLength];
                                        switch (elemWidth) {
                                            case 1: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = (byte)in.readByte();
                                                }
                                                break;
                                            }
                                            case 2: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = (short)in.readShortx();
                                                }
                                                break;
                                            }
                                            case 4: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = in.readIntx();
                                                }
                                                break;
                                            }
                                            case 8: {
                                                for (j = 0; j < initLength; ++j) {
                                                    values[j] = in.readLongx();
                                                }
                                                break;
                                            }
                                        }
                                        n.visitFillArrayStmt(opcode, AA, elemWidth, initLength, values);
                                        break block1;
                                    }
                                }
                                break block1;
                            }
                            finally {
                                in.pop();
                            }
                        }
                    }
                    n.x1t(opcode, AA, BBBBBBBB);
                    break;
                }
                case 21: {
                    in.skip(1);
                    AAAA = in.readUShortx();
                    BBBB = in.readUShortx();
                    n.x2x(opcode, AAAA, BBBB);
                    break;
                }
                case 22: {
                    VV = in.readUByte();
                    A = VV & 15;
                    B = VV >>> 4;
                    CCCC = in.readUShortx();
                    VV = in.readUShortx();
                    D = VV & 15;
                    E = VV >> 4 & 15;
                    F = VV >> 8 & 15;
                    G = VV >>> 12;
                    n.x5c(opcode, B, D, E, F, G, A, CCCC);
                    break;
                }
                case 23: {
                    AA = in.readUByte();
                    BBBB = in.readUShortx();
                    CCCC = in.readUShortx();
                    n.xrc(opcode, CCCC, AA, BBBB);
                    break;
                }
                case 24: {
                    AA = in.readUByte();
                    BBBBBBBB_BBBBBBBB = in.readLongx();
                    n.x1l(opcode, AA, BBBBBBBB_BBBBBBBB);
                    break;
                }
            }
            currentOffset = (in.getCurrentPosition() - baseOffset) / 2;
        }
    }

    void order(int offset) {
        if (!this.labels.containsKey(offset)) {
            this.labels.put(offset, new DexLabel());
        }
    }
}

