/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader;

import com.googlecode.dex2jar.reader.DataIn;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Stack;

class DataInImpl
extends ByteArrayInputStream
implements DataIn {
    private Stack<Integer> stack = new Stack();

    public DataInImpl(byte[] data) {
        super(data);
    }

    @Override
    public int getCurrentPosition() {
        return this.pos;
    }

    @Override
    public void move(int absOffset) {
        this.pos = absOffset;
    }

    @Override
    public void pop() {
        this.move(this.stack.pop());
    }

    @Override
    public void push() {
        this.stack.push(this.pos);
    }

    @Override
    public void pushMove(int absOffset) {
        this.push();
        this.move(absOffset);
    }

    @Override
    public int readByte() {
        return (byte)super.read();
    }

    @Override
    public byte[] readBytes(int size) {
        byte[] data = new byte[size];
        try {
            super.read(data);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return data;
    }

    @Override
    public int readIntx() {
        return super.read() | super.read() << 8 | super.read() << 16 | super.read() << 24;
    }

    @Override
    public long readLeb128() {
        int inp;
        int bitpos = 0;
        long vln = 0L;
        do {
            inp = super.read();
            vln |= (long)(inp & 0x7F) << bitpos;
            bitpos += 7;
        } while ((inp & 0x80) != 0);
        if ((1L << bitpos - 1 & vln) != 0L) {
            vln -= 1L << bitpos;
        }
        return vln;
    }

    @Override
    public long readLongx() {
        return (long)this.readIntx() & 0xFFFFFFFFL | (long)this.readIntx() << 32;
    }

    @Override
    public int readShortx() {
        return (short)(this.readUByte() | this.readUByte() << 8);
    }

    @Override
    public int readUByte() {
        return super.read();
    }

    @Override
    public int readUIntx() {
        return this.readIntx();
    }

    @Override
    public long readULeb128() {
        long value = 0L;
        int count = 0;
        int b = super.read();
        while ((b & 0x80) != 0) {
            value |= (long)((b & 0x7F) << count);
            count += 7;
            b = super.read();
        }
        return value |= (long)((b & 0x7F) << count);
    }

    @Override
    public int readUShortx() {
        return this.readUByte() | this.readUByte() << 8;
    }

    @Override
    public void skip(int bytes) {
        super.skip(bytes);
    }
}

