/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.threaddump.impl;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.ui.actions.ActionUtils;
import com.sun.tools.visualvm.core.ui.actions.MultiDataSourceAction;
import com.sun.tools.visualvm.coredump.CoreDump;
import com.sun.tools.visualvm.threaddump.ThreadDumpSupport;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadDumpAction
extends MultiDataSourceAction<DataSource> {
    private Set<Application> lastSelectedApplications = new HashSet<Application>();
    private final PropertyChangeListener stateListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            ThreadDumpAction.this.updateState(ActionUtils.getSelectedDataSources());
        }
    };
    private static ThreadDumpAction instance;

    public static synchronized ThreadDumpAction instance() {
        if (instance == null) {
            instance = new ThreadDumpAction();
        }
        return instance;
    }

    protected void actionPerformed(Set<DataSource> dataSources, ActionEvent actionEvent) {
        for (DataSource dataSource : dataSources) {
            if (dataSource instanceof Application) {
                Application application = (Application)dataSource;
                ThreadDumpSupport.getInstance().takeThreadDump(application, (actionEvent.getModifiers() & 2) == 0);
                continue;
            }
            if (!(dataSource instanceof CoreDump)) continue;
            CoreDump coreDump = (CoreDump)dataSource;
            ThreadDumpSupport.getInstance().takeThreadDump(coreDump, (actionEvent.getModifiers() & 2) == 0);
        }
    }

    protected boolean isEnabled(Set<DataSource> dataSources) {
        for (DataSource dataSource : dataSources) {
            if (dataSource instanceof Application) {
                Application application = (Application)dataSource;
                this.lastSelectedApplications.add(application);
                application.addPropertyChangeListener("prop_state", this.stateListener);
                if (application.getState() != 1) {
                    return false;
                }
                if (ThreadDumpSupport.getInstance().supportsThreadDump((Application)dataSource)) continue;
                return false;
            }
            if (dataSource instanceof CoreDump) continue;
            return false;
        }
        return true;
    }

    protected void updateState(Set<DataSource> dataSources) {
        if (!this.lastSelectedApplications.isEmpty()) {
            for (Application application : this.lastSelectedApplications) {
                application.removePropertyChangeListener("prop_state", this.stateListener);
            }
        }
        this.lastSelectedApplications.clear();
        super.updateState(dataSources);
    }

    private ThreadDumpAction() {
        super(DataSource.class);
        this.putValue("Name", NbBundle.getMessage(ThreadDumpAction.class, (String)"MSG_Thread_Dump"));
        this.putValue("ShortDescription", NbBundle.getMessage(ThreadDumpAction.class, (String)"LBL_Thread_Dump"));
    }
}

