/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.attach;

import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapHistogramImpl {
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final String VOID_TEXT = "void";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char OBJECT_CODE = 'L';
    private final Set<ClassInfoImpl> classes;
    private final Set<ClassInfoImpl> permGenClasses;
    private final Date time;
    private final long totalBytes;
    private final long totalInstances;
    private long totalHeapBytes;
    private long totalHeapInstances;
    private long totalPermGenBytes;
    private long totalPermgenInstances;

    HeapHistogramImpl(InputStream in) {
        HashMap<String, ClassInfoImpl> classesMap = new HashMap<String, ClassInfoImpl>(1024);
        HashMap<String, ClassInfoImpl> permGenMap = new HashMap<String, ClassInfoImpl>(1024);
        this.time = new Date();
        Scanner sc = new Scanner(in, "UTF-8");
        sc.useRadix(10);
        sc.nextLine();
        sc.nextLine();
        sc.skip("-+");
        sc.nextLine();
        while (sc.hasNext("[0-9]+:")) {
            ClassInfoImpl newClInfo = new ClassInfoImpl(sc);
            if (newClInfo.isPermGen()) {
                this.storeClassInfo(newClInfo, permGenMap);
                this.totalPermGenBytes += newClInfo.getBytes();
                this.totalPermgenInstances += newClInfo.getInstancesCount();
                continue;
            }
            this.storeClassInfo(newClInfo, classesMap);
            this.totalHeapBytes += newClInfo.getBytes();
            this.totalHeapInstances += newClInfo.getInstancesCount();
        }
        sc.next("Total");
        this.totalInstances = sc.nextLong();
        this.totalBytes = sc.nextLong();
        this.classes = new HashSet(classesMap.values());
        this.permGenClasses = new HashSet(permGenMap.values());
    }

    private void storeClassInfo(ClassInfoImpl newClInfo, Map<String, ClassInfoImpl> map) {
        ClassInfoImpl oldClInfo = map.get(newClInfo.getName());
        if (oldClInfo == null) {
            map.put(newClInfo.getName(), newClInfo);
        } else {
            oldClInfo.bytes += newClInfo.getBytes();
            oldClInfo.instances += newClInfo.getInstancesCount();
        }
    }

    public Date getTime() {
        return this.time;
    }

    public Set<ClassInfoImpl> getHeapHistogram() {
        return this.classes;
    }

    public long getTotalInstances() {
        return this.totalInstances;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getTotalHeapInstances() {
        return this.totalHeapInstances;
    }

    public long getTotalHeapBytes() {
        return this.totalHeapBytes;
    }

    public Set<ClassInfoImpl> getPermGenHistogram() {
        return this.permGenClasses;
    }

    public long getTotalPerGenInstances() {
        return this.totalPermgenInstances;
    }

    public long getTotalPermGenHeapBytes() {
        return this.totalPermGenBytes;
    }

    public static class ClassInfoImpl {
        private long instances;
        private long bytes;
        private String name;
        private boolean permGen;

        public ClassInfoImpl() {
        }

        ClassInfoImpl(Scanner sc) {
            sc.next();
            this.instances = sc.nextLong();
            this.bytes = sc.nextLong();
            String jvmName = sc.next();
            this.permGen = jvmName.charAt(0) == '<';
            this.name = this.convertJVMName(jvmName);
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.instances;
        }

        public long getBytes() {
            return this.bytes;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassInfoImpl) {
                return this.getName().equals(((ClassInfoImpl)obj).getName());
            }
            return false;
        }

        private boolean isPermGen() {
            return this.permGen;
        }

        private String convertJVMName(String jvmName) {
            String name;
            int index = jvmName.lastIndexOf(91);
            if (index != -1) {
                switch (jvmName.charAt(index + 1)) {
                    case 'Z': {
                        name = HeapHistogramImpl.BOOLEAN_TEXT;
                        break;
                    }
                    case 'C': {
                        name = HeapHistogramImpl.CHAR_TEXT;
                        break;
                    }
                    case 'B': {
                        name = HeapHistogramImpl.BYTE_TEXT;
                        break;
                    }
                    case 'S': {
                        name = HeapHistogramImpl.SHORT_TEXT;
                        break;
                    }
                    case 'I': {
                        name = HeapHistogramImpl.INT_TEXT;
                        break;
                    }
                    case 'J': {
                        name = HeapHistogramImpl.LONG_TEXT;
                        break;
                    }
                    case 'F': {
                        name = HeapHistogramImpl.FLOAT_TEXT;
                        break;
                    }
                    case 'D': {
                        name = HeapHistogramImpl.DOUBLE_TEXT;
                        break;
                    }
                    case 'L': {
                        name = jvmName.substring(index + 2, jvmName.length() - 1);
                        break;
                    }
                    default: {
                        System.out.println("Uknown name " + jvmName);
                        name = jvmName;
                    }
                }
                for (int i = 0; i <= index; ++i) {
                    name = name + "[]";
                }
            } else {
                name = jvmName;
            }
            return name.intern();
        }
    }
}

