/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application.views.overview;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.application.views.overview.ApplicationOverviewModel;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasupport.DataChangeEvent;
import com.sun.tools.visualvm.core.datasupport.DataChangeListener;
import com.sun.tools.visualvm.core.snapshot.RegisteredSnapshotCategories;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.core.ui.components.NotSupportedDisplayer;
import com.sun.tools.visualvm.core.ui.components.ScrollableContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

class OverviewViewSupport {
    OverviewViewSupport() {
    }

    static class SystemPropertiesViewSupport
    extends JPanel {
        public SystemPropertiesViewSupport(String properties) {
            this.initComponents(properties);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_System_properties"), null, 20, (JComponent)this, null);
        }

        private void initComponents(String properties) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (properties != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + properties + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }
    }

    static class JVMArgumentsViewSupport
    extends JPanel {
        public JVMArgumentsViewSupport(String jvmargs) {
            this.initComponents(jvmargs);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM_arguments"), null, 10, (JComponent)this, null);
        }

        private void initComponents(String jvmargs) {
            NotSupportedDisplayer contents;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (jvmargs != null) {
                HTMLTextArea area = new HTMLTextArea("<nobr>" + jvmargs + "</nobr>");
                area.setCaretPosition(0);
                area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                contents = area;
            } else {
                contents = new NotSupportedDisplayer(NotSupportedDisplayer.JVM);
            }
            this.add((Component)new ScrollableContainer((JComponent)contents), "Center");
        }
    }

    static class SnapshotsViewSupport
    extends JPanel
    implements DataChangeListener {
        private DataSource dataSource;
        private HTMLTextArea area;

        public SnapshotsViewSupport(DataSource dataSource) {
            this.dataSource = dataSource;
            this.initComponents();
            dataSource.getRepository().addDataChangeListener((DataChangeListener)this, Snapshot.class);
        }

        public DataViewComponent.DetailsView getDetailsView() {
            return new DataViewComponent.DetailsView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Saved_data"), null, 10, (JComponent)this, null);
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.area = new HTMLTextArea();
            this.updateSavedData();
            this.area.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add((Component)new ScrollableContainer((JComponent)this.area), "Center");
        }

        public void dataChanged(DataChangeEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SnapshotsViewSupport.this.updateSavedData();
                }
            });
        }

        void removed() {
            this.dataSource.getRepository().removeDataChangeListener((DataChangeListener)this);
        }

        private void updateSavedData() {
            StringBuilder data = new StringBuilder();
            List snapshotCategories = RegisteredSnapshotCategories.sharedInstance().getVisibleCategories();
            for (SnapshotCategory category : snapshotCategories) {
                data.append("<b>" + category.getName() + ":</b> " + this.dataSource.getRepository().getDataSources(category.getType()).size() + "<br>");
            }
            this.area.setText("<nobr>" + data.toString() + "</nobr>");
        }
    }

    static class MasterViewSupport
    extends JPanel {
        private PropertyChangeListener oomeListener;

        public MasterViewSupport(ApplicationOverviewModel model) {
            this.initComponents(model);
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Overview"), null, (JComponent)this);
        }

        private void initComponents(final ApplicationOverviewModel model) {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            final HTMLTextArea area = new HTMLTextArea("<nobr>" + this.getGeneralProperties(model) + "</nobr>");
            area.setBorder(BorderFactory.createEmptyBorder(14, 8, 14, 8));
            DataSource source = model.getSource();
            if (source instanceof Application) {
                this.oomeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("prop_oome".equals(evt.getPropertyName())) {
                            int selStart = area.getSelectionStart();
                            int selEnd = area.getSelectionEnd();
                            area.setText("<nobr>" + MasterViewSupport.this.getGeneralProperties(model) + "</nobr>");
                            area.select(selStart, selEnd);
                        }
                    }
                };
                Jvm jvm = JvmFactory.getJVMFor((Application)((Application)source));
                jvm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.oomeListener, (Object)jvm));
            }
            this.add((Component)area, "Center");
        }

        private String getGeneralProperties(ApplicationOverviewModel model) {
            StringBuilder data = new StringBuilder();
            String PID = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_PID");
            String HOST = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Host");
            data.append("<b>" + PID + ":</b> " + model.getPid() + "<br>");
            data.append("<b>" + HOST + ":</b> " + model.getHostName() + "<br>");
            if (model.basicInfoSupported()) {
                String MAIN_CLASS = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Main_class");
                String ARGS = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Arguments");
                String JVM = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM");
                String JAVA_HOME = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Java_Home");
                String JVM_FLAGS = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_JVM_Flags");
                String HEAP_DUMP_OOME = NbBundle.getMessage(OverviewViewSupport.class, (String)"LBL_Heap_dump_on_OOME");
                data.append("<b>" + MAIN_CLASS + ":</b> " + model.getMainClass() + "<br>");
                data.append("<b>" + ARGS + ":</b> " + model.getMainArgs() + "<br>");
                data.append("<br>");
                data.append("<b>" + JVM + ":</b> " + model.getVmId() + "<br>");
                data.append("<b>" + JAVA_HOME + ":</b> " + model.getJavaHome() + "<br>");
                data.append("<b>" + JVM_FLAGS + ":</b> " + model.getJvmFlags() + "<br><br>");
                data.append("<b>" + HEAP_DUMP_OOME + ":</b> " + model.oomeEnabled() + "<br>");
            }
            return data.toString();
        }
    }
}

