/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.application;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.ApplicationDescriptorProvider;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.model.ModelProvider;
import com.sun.tools.visualvm.host.Host;
import java.lang.management.ManagementFactory;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class ApplicationSupport {
    private static ApplicationSupport instance;

    public static synchronized ApplicationSupport getInstance() {
        if (instance == null) {
            instance = new ApplicationSupport();
        }
        return instance;
    }

    Application createCurrentApplication() {
        String selfName = ManagementFactory.getRuntimeMXBean().getName();
        int selfPid = Integer.valueOf(selfName.substring(0, selfName.indexOf(64)));
        CurrentApplication currentApplication = new CurrentApplication(selfPid, Host.LOCALHOST, Host.LOCALHOST.getHostName() + "-" + selfPid);
        currentApplication.jvm = JvmFactory.getJVMFor(currentApplication);
        return currentApplication;
    }

    private void initCurrentApplication() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            public void run() {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Host.LOCALHOST.getRepository().addDataSource((DataSource)Application.CURRENT_APPLICATION);
                    }
                });
            }
        });
    }

    private ApplicationSupport() {
        DataSourceDescriptorFactory.getDefault().registerProvider((ModelProvider)new ApplicationDescriptorProvider());
        this.initCurrentApplication();
    }

    private class CurrentApplication
    extends Application {
        private int selfPid;
        Jvm jvm;

        private CurrentApplication(int selfPid, Host host, String id) {
            super(host, id);
            this.selfPid = selfPid;
        }

        public int getPid() {
            return this.selfPid;
        }
    }
}

