/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;

public class JMethodIdTable {
    private static JMethodIdTable defaultTable;
    private JMethodIdTableEntry[] entries;
    private boolean staticTable = false;
    private int incompleteEntries;
    private int nElements;
    private int size;
    private int threshold;

    JMethodIdTable() {
        this.size = 97;
        this.threshold = this.size * 3 / 4;
        this.nElements = 0;
        this.entries = new JMethodIdTableEntry[this.size];
    }

    JMethodIdTable(int[] nArray, String[][] stringArray) {
        this.staticTable = true;
        this.size = nArray.length * 2;
        this.threshold = this.size * 3 / 4;
        this.nElements = 0;
        this.entries = new JMethodIdTableEntry[this.size];
        for (int i = 0; i < nArray.length; ++i) {
            this.addEntry(nArray[i], stringArray[0][i], stringArray[1][i], stringArray[2][i]);
        }
    }

    public static JMethodIdTable getDefault() {
        if (defaultTable == null) {
            defaultTable = new JMethodIdTable();
        }
        return defaultTable;
    }

    public static void reset() {
        defaultTable = null;
    }

    public String debug() {
        if (this.entries == null) {
            return "Entries = null, size = " + this.size + ", nElements = " + this.nElements + ", threshold = " + this.threshold + ", incompleteEntries = " + this.incompleteEntries;
        }
        return "Entries.length = " + this.entries.length + ", size = " + this.size + ", nElements = " + this.nElements + ", threshold = " + this.threshold + ", incompleteEntries = " + this.incompleteEntries;
    }

    public void readFromStream(DataInputStream dataInputStream) throws IOException {
        this.size = dataInputStream.readInt();
        this.nElements = dataInputStream.readInt();
        this.threshold = dataInputStream.readInt();
        this.entries = new JMethodIdTableEntry[this.size];
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            String string3 = dataInputStream.readUTF();
            this.addEntry(n2, string, string2, string3);
        }
    }

    public void writeToStream(DataOutputStream dataOutputStream) throws IOException {
        int n;
        dataOutputStream.writeInt(this.size);
        dataOutputStream.writeInt(this.nElements);
        dataOutputStream.writeInt(this.threshold);
        int n2 = 0;
        for (n = 0; n < this.entries.length; ++n) {
            if (this.entries[n] == null) continue;
            ++n2;
        }
        dataOutputStream.writeInt(n2);
        for (n = 0; n < this.entries.length; ++n) {
            if (this.entries[n] == null) continue;
            dataOutputStream.writeInt(this.entries[n].methodId);
            dataOutputStream.writeUTF(this.entries[n].className);
            dataOutputStream.writeUTF(this.entries[n].methodName);
            dataOutputStream.writeUTF(this.entries[n].methodSig);
        }
    }

    JMethodIdTableEntry getEntry(int n) {
        int n2 = this.hash(n) % this.size;
        while (this.entries[n2] != null && this.entries[n2].methodId != n) {
            n2 = (n2 + 1) % this.size;
        }
        return this.entries[n2];
    }

    synchronized void getNamesForMethodIds(ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        if (this.staticTable) {
            throw new IllegalStateException("Attempt to update snapshot JMethodIdTable");
        }
        if (this.incompleteEntries == 0) {
            return;
        }
        int[] nArray = new int[this.incompleteEntries];
        int n = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null || this.entries[i].className != null) continue;
            nArray[n++] = this.entries[i].methodId;
        }
        String[][] stringArray = profilerClient.getMethodNamesForJMethodIds(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            this.completeEntry(nArray[i], stringArray[0][i], stringArray[1][i], stringArray[2][i]);
        }
        this.incompleteEntries = 0;
    }

    void addEntry(int n, String string, String string2, String string3) {
        this.checkMethodId(n);
        this.completeEntry(n, string, string2, string3);
    }

    synchronized void checkMethodId(int n) {
        int n2 = this.hash(n) % this.size;
        while (this.entries[n2] != null) {
            if (this.entries[n2].methodId == n) {
                return;
            }
            n2 = (n2 + 1) % this.size;
        }
        if (this.nElements < this.threshold) {
            this.entries[n2] = new JMethodIdTableEntry(n);
            ++this.nElements;
            ++this.incompleteEntries;
            return;
        }
        this.growTable();
        this.checkMethodId(n);
    }

    private void completeEntry(int n, String string, String string2, String string3) {
        int n2 = this.hash(n) % this.size;
        while (this.entries[n2].methodId != n) {
            n2 = (n2 + 1) % this.size;
        }
        this.entries[n2].className = string;
        this.entries[n2].methodName = string2;
        this.entries[n2].methodSig = string3;
    }

    private void growTable() {
        JMethodIdTableEntry[] jMethodIdTableEntryArray = this.entries;
        this.size = this.size * 2 + 1;
        this.threshold = this.size * 3 / 4;
        this.entries = new JMethodIdTableEntry[this.size];
        for (int i = 0; i < jMethodIdTableEntryArray.length; ++i) {
            if (jMethodIdTableEntryArray[i] == null) continue;
            int n = this.hash(jMethodIdTableEntryArray[i].methodId) % this.size;
            while (this.entries[n] != null) {
                n = (n + 1) % this.size;
            }
            this.entries[n] = jMethodIdTableEntryArray[i];
        }
    }

    private int hash(int n) {
        return (n >> 2) * 123457 & 0xFFFFFFF;
    }

    static class JMethodIdTableEntry {
        String className;
        String methodName;
        String methodSig;
        int methodId;

        JMethodIdTableEntry(int n) {
            this.methodId = n;
        }
    }
}

