/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.ArrayList;
import java.util.logging.Level;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.TransactionalSupport;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.results.BaseCallGraphBuilder;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CPUCCTNodeFactory;
import org.netbeans.lib.profiler.results.cpu.cct.RuntimeCPUCCTNodeVisitorAdaptor;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.BaseCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MarkedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ServletRequestCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.SimpleCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.ThreadCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.TimedCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.MarkingEngine;

public class CPUCallGraphBuilder
extends BaseCallGraphBuilder
implements CPUProfilingResultListener,
CPUCCTProvider {
    private CPUCCTNodeFactory factory;
    private DebugInfoCollector debugCollector = null;
    private InstrumentationFilter instrFilter;
    private boolean stackIntegrityViolationReported;
    private long delta;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CPUCCTContainer[] createPresentationCCTs(CPUResultsSnapshot cPUResultsSnapshot) {
        ThreadInfo.beginTrans(false);
        try {
            String[] stringArray = ThreadInfo.getThreadNames();
            if (stringArray == null) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            int n = stringArray.length;
            if (n == 0) {
                CPUCCTContainer[] cPUCCTContainerArray = null;
                return cPUCCTContainerArray;
            }
            ArrayList<CPUCCTContainer> arrayList = new ArrayList<CPUCCTContainer>(n);
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                ThreadInfo threadInfo = ThreadInfo.threadInfos[i];
                if (threadInfo == null || threadInfo.stack[0] == null) continue;
                double[] dArray = this.calculateThreadActiveTimes(threadInfo);
                TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[0];
                CPUCCTContainer cPUCCTContainer = new CPUCCTContainer(timedCPUCCTNode, cPUResultsSnapshot, this.status, this.instrFilter, threadInfo.totalNNodes, dArray, n2++, stringArray[i]);
                if (cPUCCTContainer.rootNode == null || cPUCCTContainer.rootNode.getNChildren() <= 0) continue;
                arrayList.add(cPUCCTContainer);
            }
            CPUCCTContainer[] cPUCCTContainerArray = arrayList.toArray(new CPUCCTContainer[arrayList.size()]);
            return cPUCCTContainerArray;
        }
        finally {
            ThreadInfo.endTrans();
        }
    }

    public void methodEntry(int n, int n2, int n3, long l, long l2) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        switch (n3) {
            case 1: {
                this.plainMethodEntry(n, threadInfo, l, l2);
                break;
            }
            case 2: {
                this.rootMethodEntry(n, threadInfo, l, l2);
                break;
            }
            case 3: {
                this.markerMethodEntry(n, threadInfo, l, l2);
            }
        }
        this.batchNotEmpty = true;
    }

    public void methodEntryUnstamped(int n, int n2, int n3) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        switch (n3) {
            case 1: {
                this.plainMethodEntry(n, threadInfo);
                break;
            }
            case 3: {
                this.markerMethodEntry(n, threadInfo);
            }
        }
        this.batchNotEmpty = true;
    }

    public void methodExit(int n, int n2, int n3, long l, long l2) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        TimedCPUCCTNode timedCPUCCTNode2 = null;
        switch (n3) {
            case 1: 
            case 3: {
                timedCPUCCTNode2 = this.plainMethodExit(n, threadInfo, l, l2);
                break;
            }
            case 2: {
                timedCPUCCTNode2 = this.rootMethodExit(n, threadInfo, l, l2);
            }
        }
        if (timedCPUCCTNode2 != null && (timedCPUCCTNode = threadInfo.peek()) != null && (timedCPUCCTNode instanceof MarkedCPUCCTNode || timedCPUCCTNode instanceof ServletRequestCPUCCTNode)) {
            threadInfo.pop();
        }
        this.batchNotEmpty = true;
    }

    public void methodExitUnstamped(int n, int n2, int n3) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n2];
        if (threadInfo == null) {
            return;
        }
        TimedCPUCCTNode timedCPUCCTNode2 = null;
        switch (n3) {
            case 1: 
            case 3: {
                timedCPUCCTNode2 = this.plainMethodExit(n, threadInfo);
            }
        }
        if (timedCPUCCTNode2 != null && (timedCPUCCTNode = threadInfo.peek()) != null && (timedCPUCCTNode instanceof MarkedCPUCCTNode || timedCPUCCTNode instanceof ServletRequestCPUCCTNode)) {
            threadInfo.pop();
        }
        this.batchNotEmpty = true;
    }

    public void monitorEntry(int n, long l, long l2) {
        this.waitEntry(n, l, l2);
        this.batchNotEmpty = true;
    }

    public void monitorExit(int n, long l, long l2) {
        this.waitEntry(n, l, l2);
        this.batchNotEmpty = true;
    }

    public void newThread(int n, String string, String string2) {
        if (!this.isReady()) {
            return;
        }
        LOGGER.finest("New thread creation for thread id = " + n + ", name = " + string);
        ThreadInfo.newThreadInfo(n, string, string2);
        this.batchNotEmpty = true;
    }

    public void servletRequest(int n, int n2, String string, int n3) {
        ServletRequestCPUCCTNode servletRequestCPUCCTNode;
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n];
        if (threadInfo == null) {
            return;
        }
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.peek();
        if (timedCPUCCTNode == null) {
            timedCPUCCTNode = this.factory.createThreadNode(n);
            ++threadInfo.totalNNodes;
            threadInfo.push(timedCPUCCTNode);
            --threadInfo.totalNInv;
        }
        if ((servletRequestCPUCCTNode = ServletRequestCPUCCTNode.Locator.locate(n2, string, timedCPUCCTNode.getChildren())) == null) {
            servletRequestCPUCCTNode = this.factory.createServletRequestNode(n2, string);
            timedCPUCCTNode.attachNodeAsChild(servletRequestCPUCCTNode);
        }
        threadInfo.push(servletRequestCPUCCTNode);
    }

    public void sleepEntry(int n, long l, long l2) {
        long l3;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY SLEEP: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", ti: " + threadInfo);
            this.delta = l;
        }
        if ((l3 = l - threadInfo.topMethodEntryTime0) > 0L) {
            timedCPUCCTNode.addNetTime0(l3);
        } else {
            l = threadInfo.topMethodEntryTime0;
        }
        threadInfo.topMethodEntryTime0 = l;
        timedCPUCCTNode.setLastWaitOrSleepStamp(l);
        this.batchNotEmpty = true;
    }

    public void sleepExit(int n, long l, long l2) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        long l3 = l - timedCPUCCTNode.getLastWaitOrSleepStamp();
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT SLEEP: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", slept: " + l3 + ", ti: " + threadInfo);
            this.delta = l;
            l3 = 0L;
        }
        timedCPUCCTNode.setLastWaitOrSleepStamp(0L);
        timedCPUCCTNode.addSleepTime0(l3);
        if (l - threadInfo.topMethodEntryTime0 > 0L) {
            threadInfo.topMethodEntryTime0 = l;
        }
        this.batchNotEmpty = true;
    }

    public void threadsResume(long l, long l2) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo[] threadInfoArray = ThreadInfo.threadInfos;
        for (int i = 0; i < threadInfoArray.length; ++i) {
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null || threadInfo.stackTopIdx < 0) continue;
            threadInfo.topMethodEntryTime0 = l;
            if (this.status.collectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
            if (this.status.collectingTwoTimeStamps()) {
                threadInfo.rootMethodEntryTimeAbs = l;
                threadInfo.rootMethodEntryTimeThreadCPU = l2;
                continue;
            }
            threadInfo.rootMethodEntryTimeAbs = l;
        }
        this.batchNotEmpty = true;
    }

    public void threadsSuspend(long l, long l2) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo[] threadInfoArray = ThreadInfo.threadInfos;
        for (int i = 0; i < threadInfoArray.length; ++i) {
            ThreadInfo threadInfo = threadInfoArray[i];
            if (threadInfo == null || threadInfo.stackTopIdx < 0) continue;
            TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
            long l3 = l - threadInfo.topMethodEntryTime0;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime0(l3);
            }
            if (this.status.collectingTwoTimeStamps()) {
                threadInfo.rootGrossTimeAbs += l - threadInfo.rootMethodEntryTimeAbs;
                l3 = l2 - threadInfo.topMethodEntryTime1;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime1(l3);
                }
                threadInfo.rootGrossTimeThreadCPU += l2 - threadInfo.rootMethodEntryTimeThreadCPU;
                continue;
            }
            threadInfo.rootGrossTimeAbs += l - threadInfo.rootMethodEntryTimeAbs;
        }
        this.batchNotEmpty = true;
    }

    public void timeAdjust(final int n, final long l, final long l2) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        final ProfilingPointsProcessor profilingPointsProcessor = TargetAppRunner.getDefault().getProfilingPointsProcessor();
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n];
        threadInfo.rootMethodEntryTimeAbs += l;
        threadInfo.rootMethodEntryTimeThreadCPU += l2;
        threadInfo.topMethodEntryTime0 += l;
        if (this.status.collectingTwoTimeStamps()) {
            threadInfo.topMethodEntryTime1 += l2;
        }
        this.afterBatchCommands.add(new Runnable(){

            public void run() {
                profilingPointsProcessor.timeAdjust(n, l, l2);
            }
        });
        this.batchNotEmpty = true;
    }

    public void waitEntry(int n, long l, long l2) {
        long l3;
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("ENTRY WAIT: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", ti: " + threadInfo);
            this.delta = l;
            LOGGER.finest(this.dumpStack(threadInfo));
        }
        if ((l3 = l - threadInfo.topMethodEntryTime0) > 0L) {
            timedCPUCCTNode.addNetTime0(l3);
        } else {
            l = threadInfo.topMethodEntryTime0;
        }
        threadInfo.topMethodEntryTime0 = l;
        timedCPUCCTNode.setLastWaitOrSleepStamp(l);
        this.batchNotEmpty = true;
    }

    public void waitExit(int n, long l, long l2) {
        if (!this.isReady() || ThreadInfo.threadInfos == null) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.threadInfos[n];
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[threadInfo.stackTopIdx];
        long l3 = l - timedCPUCCTNode.getLastWaitOrSleepStamp();
        timedCPUCCTNode.setLastWaitOrSleepStamp(0L);
        timedCPUCCTNode.addWaitTime0(l3);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("EXIT WAIT: " + this.debugNode(timedCPUCCTNode) + ", time: " + l + ", delta: " + (l - this.delta) + ", waited: " + l3 + ", ti: " + threadInfo);
            this.delta = l;
            LOGGER.finest(this.dumpStack(threadInfo));
        }
        if (l - threadInfo.topMethodEntryTime0 > 0L) {
            threadInfo.topMethodEntryTime0 = l;
        }
        this.batchNotEmpty = true;
    }

    protected long[][] getAllThreadsActiveTimes() {
        int n = ThreadInfo.getThreadNames().length;
        long[][] lArray = new long[2][n];
        for (int i = 0; i < n; ++i) {
            ThreadInfo threadInfo = ThreadInfo.threadInfos[i];
            double[] dArray = this.calculateThreadActiveTimes(threadInfo);
            lArray[0][i] = (long)((dArray[0] - dArray[2]) * 1000.0 / (double)this.status.timerCountsInSecond[0]);
            lArray[1][i] = dArray[1] != -1.0 ? (long)((dArray[1] - dArray[3]) * 1000.0 / (double)this.status.timerCountsInSecond[1]) : -1L;
        }
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RuntimeCCTNode getAppRootNode() {
        if (ThreadInfo.isEmpty()) {
            return null;
        }
        SimpleCPUCCTNode simpleCPUCCTNode = null;
        ThreadInfo.beginTrans(false);
        try {
            simpleCPUCCTNode = new SimpleCPUCCTNode(true);
            int n = ThreadInfo.getThreadNames() != null ? ThreadInfo.getThreadNames().length : 0;
            for (int i = 0; i < n; ++i) {
                ThreadInfo threadInfo = ThreadInfo.threadInfos[i];
                if (threadInfo == null || threadInfo.stack[0] == null) continue;
                simpleCPUCCTNode.attachNodeAsChild(threadInfo.stack[0]);
            }
        }
        finally {
            ThreadInfo.endTrans();
        }
        return simpleCPUCCTNode;
    }

    double[] calculateThreadActiveTimes(ThreadInfo threadInfo) {
        long l;
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[0];
        if (timedCPUCCTNode == null) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        long l2 = threadInfo.rootGrossTimeAbs;
        if (threadInfo.stackTopIdx != -1) {
            l = this.status.dumpAbsTimeStamp;
            if (threadInfo.topMethodEntryTime0 > l) {
                l = threadInfo.topMethodEntryTime0;
            }
            l2 += l - threadInfo.rootMethodEntryTimeAbs;
        }
        l = threadInfo.rootGrossTimeThreadCPU;
        if (threadInfo.stackTopIdx != -1) {
            l = this.status.collectingTwoTimeStamps() ? (l += threadInfo.topMethodEntryTime1 - threadInfo.rootMethodEntryTimeThreadCPU) : -1L;
        }
        int n = timedCPUCCTNode.getNCalls();
        double d = 0.0;
        double d2 = TimingAdjusterOld.getDefault(this.status).delta(n, (int)(threadInfo.totalNInv - (long)n), false);
        d = this.status.collectingTwoTimeStamps() ? TimingAdjusterOld.getDefault(this.status).delta(n, (int)(threadInfo.totalNInv - (long)n), true) : d2 * (double)this.status.timerCountsInSecond[1] / (double)this.status.timerCountsInSecond[0];
        return new double[]{l2, l, d2, d};
    }

    protected void doBatchStart() {
        ThreadInfo.beginTrans(true);
    }

    protected void doBatchStop() {
        ThreadInfo.endTrans();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReset() {
        boolean bl = ThreadInfo.beginTrans(true, true);
        if (bl) {
            try {
                ThreadInfo.reset();
            }
            finally {
                ThreadInfo.endTrans();
            }
        }
    }

    protected void doShutdown() {
        ThreadInfo.reset();
        this.factory = null;
        this.instrFilter = null;
    }

    protected void doStartup(ProfilerClient profilerClient) {
        this.instrFilter = profilerClient.getSettings().getInstrumentationFilter();
        this.factory = new CPUCCTNodeFactory(this.status.collectingTwoTimeStamps());
        profilerClient.registerCPUCCTProvider(this);
    }

    private synchronized DebugInfoCollector getDebugCollector() {
        if (this.debugCollector == null) {
            this.debugCollector = new DebugInfoCollector();
        }
        return this.debugCollector;
    }

    private boolean isReady() {
        return this.status != null && this.factory != null && this.instrFilter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String debugMethod(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.status.beginTrans(false);
        try {
            stringBuffer.append(this.status.getInstrMethodClasses()[n]).append('.').append(this.status.getInstrMethodNames()[n]);
            stringBuffer.append(this.status.getInstrMethodSignatures()[n]).append(" (methodId = ").append(n).append(')');
        }
        finally {
            this.status.endTrans();
        }
        return stringBuffer.toString();
    }

    private String debugNode(RuntimeCPUCCTNode runtimeCPUCCTNode) {
        return this.getDebugCollector().getInfo(runtimeCPUCCTNode);
    }

    private String dumpStack(ThreadInfo threadInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("*** Thread stack dump:\n");
        for (int i = threadInfo.stackTopIdx; i >= 0; --i) {
            DebugInfoCollector debugInfoCollector = new DebugInfoCollector();
            TimedCPUCCTNode timedCPUCCTNode = threadInfo.stack[i];
            timedCPUCCTNode.accept(debugInfoCollector);
            stringBuffer.append(debugInfoCollector.getInfo(timedCPUCCTNode)).append('\n');
        }
        return stringBuffer.toString();
    }

    private TimedCPUCCTNode markerMethodEntry(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        Object object;
        TimedCPUCCTNode timedCPUCCTNode;
        Mark mark = MarkingEngine.getDefault().markMethod(n, this.status);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("MarkerMEntry" + (!bl ? "(unstamped)" : "") + " for tId = " + threadInfo.threadId + ", time: " + l + ", method:  " + this.debugMethod(n) + ", inRoot: " + threadInfo.rootMethodEntryTimeAbs + ", rootEntryTimeThread: " + threadInfo.rootMethodEntryTimeThreadCPU);
        }
        if ((timedCPUCCTNode = threadInfo.peek()) == null) {
            object = this.factory.createThreadNode(threadInfo.threadId);
            ++threadInfo.totalNNodes;
            threadInfo.push((TimedCPUCCTNode)object);
            --threadInfo.totalNInv;
            if (!mark.isDefault()) {
                timedCPUCCTNode = this.factory.createCategory(mark);
                ((BaseCPUCCTNode)object).attachNodeAsChild(timedCPUCCTNode);
                ++threadInfo.totalNNodes;
                threadInfo.push(timedCPUCCTNode);
                object = timedCPUCCTNode;
            }
            timedCPUCCTNode = this.factory.createMethodNode(n);
            ((BaseCPUCCTNode)object).attachNodeAsChild(timedCPUCCTNode);
            ++threadInfo.totalNNodes;
            threadInfo.push(timedCPUCCTNode);
            threadInfo.topMethodEntryTime0 = l;
            if (this.status.collectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        } else {
            if (bl) {
                long l3 = l - threadInfo.topMethodEntryTime0;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime0(l3);
                } else {
                    l = threadInfo.topMethodEntryTime0;
                }
                threadInfo.topMethodEntryTime0 = l;
                if (this.status.collectingTwoTimeStamps()) {
                    l3 = l2 - threadInfo.topMethodEntryTime1;
                    if (l3 > 0L) {
                        timedCPUCCTNode.addNetTime1(l3);
                    } else {
                        l2 = threadInfo.topMethodEntryTime1;
                    }
                    threadInfo.topMethodEntryTime1 = l2;
                }
            }
            if (!mark.isDefault()) {
                MarkedCPUCCTNode markedCPUCCTNode = MarkedCPUCCTNode.Locator.locate(mark, timedCPUCCTNode.getChildren());
                if (markedCPUCCTNode == null) {
                    markedCPUCCTNode = this.factory.createCategory(mark);
                    timedCPUCCTNode.attachNodeAsChild(markedCPUCCTNode);
                    ++threadInfo.totalNNodes;
                }
                threadInfo.push(markedCPUCCTNode);
                timedCPUCCTNode = markedCPUCCTNode;
            }
            if ((object = MethodCPUCCTNode.Locator.locate(n, timedCPUCCTNode.getChildren())) == null) {
                object = this.factory.createMethodNode(n);
                timedCPUCCTNode.attachNodeAsChild((RuntimeCPUCCTNode)object);
                ++threadInfo.totalNNodes;
            }
            threadInfo.push((TimedCPUCCTNode)object);
            timedCPUCCTNode = object;
        }
        if (!threadInfo.isInRoot()) {
            timedCPUCCTNode.setFilteredStatus(2);
            if (bl) {
                threadInfo.rootMethodEntryTimeAbs = l;
                threadInfo.rootMethodEntryTimeThreadCPU = l2;
                threadInfo.topMethodEntryTime0 = l;
                if (this.status.collectingTwoTimeStamps()) {
                    threadInfo.topMethodEntryTime1 = l2;
                }
            }
        } else {
            object = this.status.getInstrMethodClasses()[((MethodCPUCCTNode)timedCPUCCTNode).getMethodId()].replace('.', '/');
            ProfilerClient profilerClient = this.getClient();
            if (profilerClient != null) {
                if (!profilerClient.getSettings().getInstrumentationFilter().passesFilter((String)object)) {
                    timedCPUCCTNode.setFilteredStatus(2);
                }
            } else {
                timedCPUCCTNode.setFilteredStatus(2);
            }
        }
        return timedCPUCCTNode;
    }

    private TimedCPUCCTNode markerMethodEntry(int n, ThreadInfo threadInfo, long l, long l2) {
        return this.markerMethodEntry(n, threadInfo, l, l2, true);
    }

    private TimedCPUCCTNode markerMethodEntry(int n, ThreadInfo threadInfo) {
        return this.markerMethodEntry(n, threadInfo, 0L, 0L, false);
    }

    private TimedCPUCCTNode plainMethodEntry(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        MethodCPUCCTNode methodCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST) && LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("MethodEntry " + (!bl ? "(unstamped)" : "") + " for tId = " + threadInfo.threadId + ", time: " + l + ", delta: " + (l - this.delta) + ", method:  " + this.debugMethod(n));
        }
        TimedCPUCCTNode timedCPUCCTNode = threadInfo.peek();
        if (bl) {
            long l3 = l - threadInfo.topMethodEntryTime0;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime0(l3);
            } else {
                l = threadInfo.topMethodEntryTime0;
            }
            threadInfo.topMethodEntryTime0 = l;
            if (this.status.collectingTwoTimeStamps()) {
                l3 = l2 - threadInfo.topMethodEntryTime1;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime1(l3);
                } else {
                    l2 = threadInfo.topMethodEntryTime1;
                }
                threadInfo.topMethodEntryTime1 = l2;
            }
        }
        if ((methodCPUCCTNode = MethodCPUCCTNode.Locator.locate(n, timedCPUCCTNode.getChildren())) != null) {
            threadInfo.push(methodCPUCCTNode);
            return methodCPUCCTNode;
        }
        methodCPUCCTNode = this.factory.createMethodNode(n);
        timedCPUCCTNode.attachNodeAsChild(methodCPUCCTNode);
        timedCPUCCTNode = methodCPUCCTNode;
        ++threadInfo.totalNNodes;
        threadInfo.push(timedCPUCCTNode);
        if (!threadInfo.isInRoot()) {
            String string = this.status.getInstrMethodClasses()[((MethodCPUCCTNode)timedCPUCCTNode).getMethodId()].replace('.', '/');
            ProfilerClient profilerClient = this.getClient();
            if (profilerClient != null) {
                if (!profilerClient.getSettings().getInstrumentationFilter().passesFilter(string)) {
                    timedCPUCCTNode.setFilteredStatus(2);
                }
            } else {
                timedCPUCCTNode.setFilteredStatus(2);
            }
        }
        return timedCPUCCTNode;
    }

    private TimedCPUCCTNode plainMethodEntry(int n, ThreadInfo threadInfo, long l, long l2) {
        return this.plainMethodEntry(n, threadInfo, l, l2, true);
    }

    private TimedCPUCCTNode plainMethodEntry(int n, ThreadInfo threadInfo) {
        return this.plainMethodEntry(n, threadInfo, 0L, 0L, false);
    }

    private TimedCPUCCTNode plainMethodExit(int n, ThreadInfo threadInfo, long l, long l2, boolean bl) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("MethodExit" + (!bl ? "(unstamped)" : "") + ": " + this.debugMethod(n) + ", time: " + l + ", delta: " + (l - this.delta) + ", ti: " + threadInfo);
            this.delta = l;
        }
        if ((timedCPUCCTNode = threadInfo.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(timedCPUCCTNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodCPUCCTNode = (MethodCPUCCTNode)timedCPUCCTNode;
        if (n != methodCPUCCTNode.getMethodId()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("*** Profiler engine warning: ").append("critical: stack integrity violation on method exit.\n");
            stringBuffer.append("*** methodId on simulated stack top: ").append(methodCPUCCTNode.getMethodId());
            stringBuffer.append(", received methodId (should match) = ").append(n).append('\n');
            stringBuffer.append("received method debug: ").append(this.debugMethod(n)).append('\n');
            stringBuffer.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (this.status != null && this.status.getInstrMethodClasses() != null && !this.stackIntegrityViolationReported) {
                stringBuffer.append(this.dumpStack(threadInfo));
                this.stackIntegrityViolationReported = true;
            }
            stringBuffer.append('\n');
            LOGGER.severe(stringBuffer.toString());
            return null;
        }
        if (bl) {
            long l3 = l - threadInfo.topMethodEntryTime0;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime0(l3);
            } else {
                l = threadInfo.topMethodEntryTime0;
            }
            if (this.status.collectingTwoTimeStamps()) {
                l3 = l2 - threadInfo.topMethodEntryTime1;
                if (l3 > 0L) {
                    timedCPUCCTNode.addNetTime1(l3);
                } else {
                    l2 = threadInfo.topMethodEntryTime1;
                }
            }
        }
        TimedCPUCCTNode timedCPUCCTNode2 = threadInfo.pop();
        if (bl) {
            threadInfo.topMethodEntryTime0 = l;
            if (this.status.collectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        }
        return timedCPUCCTNode2;
    }

    private TimedCPUCCTNode plainMethodExit(int n, ThreadInfo threadInfo, long l, long l2) {
        return this.plainMethodExit(n, threadInfo, l, l2, true);
    }

    private TimedCPUCCTNode plainMethodExit(int n, ThreadInfo threadInfo) {
        return this.plainMethodExit(n, threadInfo, 0L, 0L, false);
    }

    private TimedCPUCCTNode rootMethodEntry(int n, ThreadInfo threadInfo, long l, long l2) {
        Object object;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("RootMEntry for tId = " + threadInfo.threadId + ", time: " + l + ", method:  " + this.debugMethod(n));
        }
        Mark mark = MarkingEngine.getDefault().markMethod(n, this.status);
        Object object2 = threadInfo.peek();
        if (threadInfo.isInRoot()) {
            object = new StringBuffer();
            ((StringBuffer)object).append("*** Profiler engine warning: ").append("critical: at root method entry thread stack is not at 0 - should not happen!\n");
            ((StringBuffer)object).append("*** thread = ").append(ThreadInfo.threadNames[threadInfo.threadId]);
            ((StringBuffer)object).append(", ti.stackTopIdx = ").append(threadInfo.stackTopIdx);
            if (object2 != null) {
                ((StringBuffer)object).append(", curNode = " + object2).append('\n');
            }
            ((StringBuffer)object).append("*** Please report this problem to feedback@profiler.netbeans.org");
            LOGGER.severe(((StringBuffer)object).toString());
        }
        if (object2 == null) {
            object = this.factory.createThreadNode(threadInfo.threadId);
            ++threadInfo.totalNNodes;
            threadInfo.push((TimedCPUCCTNode)object);
            --threadInfo.totalNInv;
            if (!mark.isDefault()) {
                object2 = this.factory.createCategory(mark);
                ((BaseCPUCCTNode)object).attachNodeAsChild((RuntimeCPUCCTNode)object2);
                ++threadInfo.totalNNodes;
                threadInfo.push((TimedCPUCCTNode)object2);
                object = object2;
            }
            object2 = this.factory.createMethodNode(n);
            ((BaseCPUCCTNode)object).attachNodeAsChild((RuntimeCPUCCTNode)object2);
            ++threadInfo.totalNNodes;
        } else {
            if (!mark.isDefault()) {
                object = MarkedCPUCCTNode.Locator.locate(mark, ((BaseCPUCCTNode)object2).getChildren());
                if (object == null) {
                    object = this.factory.createCategory(mark);
                    ((BaseCPUCCTNode)object2).attachNodeAsChild((RuntimeCPUCCTNode)object);
                    ++threadInfo.totalNNodes;
                }
                threadInfo.push((TimedCPUCCTNode)object);
                object2 = object;
            }
            if ((object = MethodCPUCCTNode.Locator.locate(n, ((BaseCPUCCTNode)object2).getChildren())) == null) {
                object = this.factory.createMethodNode(n);
                ((BaseCPUCCTNode)object2).attachNodeAsChild((RuntimeCPUCCTNode)object);
                ++threadInfo.totalNNodes;
            }
            object2 = object;
        }
        threadInfo.push((TimedCPUCCTNode)object2);
        threadInfo.rootMethodEntryTimeAbs = l;
        threadInfo.rootMethodEntryTimeThreadCPU = l2;
        threadInfo.topMethodEntryTime0 = l;
        if (this.status.collectingTwoTimeStamps()) {
            threadInfo.topMethodEntryTime1 = l2;
        }
        ++threadInfo.inRoot;
        return object2;
    }

    private TimedCPUCCTNode rootMethodExit(int n, ThreadInfo threadInfo, long l, long l2) {
        TimedCPUCCTNode timedCPUCCTNode;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("RootMExit for tId = " + threadInfo.threadId + ", time: " + l + ", delta: " + (l - this.delta) + ", method: " + this.debugMethod(n));
            this.delta = l;
        }
        if ((timedCPUCCTNode = threadInfo.peek()) == null) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        if (!(timedCPUCCTNode instanceof MethodCPUCCTNode)) {
            LOGGER.severe("*** Profiler engine warning: critical: stack integrity violation on root method exit.\n*** methodId on simulated stack top is unidentifiable\n");
            return null;
        }
        MethodCPUCCTNode methodCPUCCTNode = (MethodCPUCCTNode)timedCPUCCTNode;
        if (n != methodCPUCCTNode.getMethodId()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("*** Profiler engine warning: ").append("critical: stack integrity violation on root thod exit.\n");
            stringBuffer.append("*** methodId on simulated stack top: ").append(methodCPUCCTNode.getMethodId()).append('\n');
            stringBuffer.append(", received methodId (should match) = ").append(n).append('\n');
            stringBuffer.append("received method debug: ").append(this.debugMethod(n)).append('\n');
            stringBuffer.append("*** Please report this problem to feedback@profiler.netbeans.org");
            if (this.status != null && this.status.getInstrMethodClasses() != null && !this.stackIntegrityViolationReported) {
                stringBuffer.append(this.dumpStack(threadInfo));
                this.stackIntegrityViolationReported = true;
            }
            stringBuffer.append('\n');
            LOGGER.severe(stringBuffer.toString());
            return null;
        }
        long l3 = l - threadInfo.topMethodEntryTime0;
        if (l3 > 0L) {
            timedCPUCCTNode.addNetTime0(l3);
        } else {
            l = threadInfo.topMethodEntryTime0;
        }
        if (this.status.collectingTwoTimeStamps()) {
            l3 = l2 - threadInfo.topMethodEntryTime1;
            if (l3 > 0L) {
                timedCPUCCTNode.addNetTime1(l3);
            } else {
                l2 = threadInfo.topMethodEntryTime1;
            }
        }
        --threadInfo.inRoot;
        TimedCPUCCTNode timedCPUCCTNode2 = threadInfo.pop();
        if (threadInfo.isInRoot()) {
            threadInfo.topMethodEntryTime0 = l;
            if (this.status.collectingTwoTimeStamps()) {
                threadInfo.topMethodEntryTime1 = l2;
            }
        } else {
            threadInfo.rootGrossTimeAbs += l - threadInfo.rootMethodEntryTimeAbs;
            threadInfo.rootGrossTimeThreadCPU += l2 - threadInfo.rootMethodEntryTimeThreadCPU;
            threadInfo.rootMethodEntryTimeAbs = 0L;
            threadInfo.rootMethodEntryTimeThreadCPU = 0L;
        }
        return timedCPUCCTNode2;
    }

    private class DebugInfoCollector
    extends RuntimeCPUCCTNodeVisitorAdaptor {
        private StringBuffer buffer = new StringBuffer();

        public StringBuffer getBuffer() {
            return this.buffer;
        }

        public synchronized String getInfo(RuntimeCPUCCTNode runtimeCPUCCTNode) {
            this.buffer = new StringBuffer();
            runtimeCPUCCTNode.accept(this);
            return this.buffer.toString();
        }

        public void visit(MethodCPUCCTNode methodCPUCCTNode) {
            this.buffer.append(CPUCallGraphBuilder.this.debugMethod(methodCPUCCTNode.getMethodId()));
        }

        public void visit(ServletRequestCPUCCTNode servletRequestCPUCCTNode) {
            this.buffer.append("Boundary");
        }

        public void visit(ThreadCPUCCTNode threadCPUCCTNode) {
            this.buffer.append("threadId = ").append(threadCPUCCTNode.getThreadId());
        }

        public void visit(MarkedCPUCCTNode markedCPUCCTNode) {
            this.buffer.append("Category ").append(markedCPUCCTNode.getMark());
        }

        public void visit(SimpleCPUCCTNode simpleCPUCCTNode) {
        }
    }

    static class ThreadInfo {
        static ThreadInfo[] threadInfos;
        static String[] threadNames;
        static String[] threadClassNames;
        static int threadInfosLastIdx;
        private static TransactionalSupport transaction;
        TimedCPUCCTNode[] stack = new TimedCPUCCTNode[40];
        int inRoot = 0;
        int stackTopIdx = -1;
        final int threadId;
        TimedCPUCCTNode comboNodeDst;
        TimedCPUCCTNode comboNodeSrc;
        int totalNNodes;
        long rootGrossTimeAbs;
        long rootGrossTimeThreadCPU;
        long rootMethodEntryTimeAbs;
        long rootMethodEntryTimeThreadCPU;
        long topMethodEntryTime0;
        long topMethodEntryTime1;
        long totalNInv;

        private ThreadInfo(int n) {
            this.threadId = n;
        }

        static boolean isEmpty() {
            if (threadInfos == null || threadInfos.length == 0) {
                return true;
            }
            for (int i = 0; i < threadInfos.length; ++i) {
                if (threadInfos[i] == null || ThreadInfo.threadInfos[i].stack == null || ThreadInfo.threadInfos[i].stack[0] == null || ThreadInfo.threadInfos[i].stack[0].getChildren() == null || ThreadInfo.threadInfos[i].stack[0].getChildren().size() <= 0) continue;
                return false;
            }
            return true;
        }

        static synchronized String[] getThreadNames() {
            return threadNames;
        }

        static void beginTrans(boolean bl) {
            transaction.beginTrans(bl);
        }

        static boolean beginTrans(boolean bl, boolean bl2) {
            return transaction.beginTrans(bl, bl2);
        }

        static void endTrans() {
            transaction.endTrans();
        }

        static synchronized void newThreadInfo(int n, String string, String string2) {
            if (n > threadInfosLastIdx || threadInfos == null) {
                int n2 = n + 1;
                ThreadInfo[] threadInfoArray = new ThreadInfo[n2];
                String[] stringArray = new String[n2];
                String[] stringArray2 = new String[n2];
                if (threadInfos != null) {
                    System.arraycopy(threadInfos, 0, threadInfoArray, 0, threadInfos.length);
                    System.arraycopy(threadNames, 0, stringArray, 0, threadNames.length);
                    System.arraycopy(threadClassNames, 0, stringArray2, 0, threadNames.length);
                }
                threadInfos = threadInfoArray;
                threadNames = stringArray;
                threadClassNames = stringArray2;
                threadInfosLastIdx = n;
            }
            ThreadInfo.threadInfos[n] = new ThreadInfo(n);
            ThreadInfo.threadNames[n] = string;
            ThreadInfo.threadClassNames[n] = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void reset() {
            ThreadInfo.beginTrans(true);
            try {
                threadInfos = null;
                threadNames = null;
                threadInfosLastIdx = -1;
            }
            finally {
                ThreadInfo.endTrans();
            }
        }

        boolean isInRoot() {
            return this.inRoot > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TimedCPUCCTNode peek() {
            TimedCPUCCTNode[] timedCPUCCTNodeArray = this.stack;
            synchronized (this.stack) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.stackTopIdx > -1 ? this.stack[this.stackTopIdx] : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TimedCPUCCTNode pop() {
            TimedCPUCCTNode timedCPUCCTNode = null;
            TimedCPUCCTNode[] timedCPUCCTNodeArray = this.stack;
            synchronized (this.stack) {
                if (this.stackTopIdx >= 0) {
                    timedCPUCCTNode = this.stack[this.stackTopIdx];
                    this.stack[this.stackTopIdx] = null;
                    --this.stackTopIdx;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return timedCPUCCTNode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void push(TimedCPUCCTNode timedCPUCCTNode) {
            TimedCPUCCTNode[] timedCPUCCTNodeArray = this.stack;
            synchronized (this.stack) {
                ++this.stackTopIdx;
                if (this.stackTopIdx >= this.stack.length) {
                    this.increaseStack();
                }
                this.stack[this.stackTopIdx] = timedCPUCCTNode;
                timedCPUCCTNode.addNCalls(1);
                ++this.totalNInv;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private void increaseStack() {
            TimedCPUCCTNode[] timedCPUCCTNodeArray = new TimedCPUCCTNode[this.stack.length * 2];
            System.arraycopy(this.stack, 0, timedCPUCCTNodeArray, 0, this.stack.length);
            this.stack = timedCPUCCTNodeArray;
        }

        static {
            transaction = new TransactionalSupport();
            ThreadInfo.reset();
        }
    }
}

