/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.IOException;
import java.util.ArrayList;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.classfile.BaseClassInfo;
import org.netbeans.lib.profiler.classfile.ClassLoaderTable;
import org.netbeans.lib.profiler.classfile.ClassRepository;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.RuntimeProfilingPoint;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.instrumentation.BadLocationException;
import org.netbeans.lib.profiler.instrumentation.ClassManager;
import org.netbeans.lib.profiler.instrumentation.CodeRegionMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.MemoryProfMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.MiscInstrumentationOps;
import org.netbeans.lib.profiler.instrumentation.ObjLivenessMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.RecursiveMethodInstrumentor;
import org.netbeans.lib.profiler.instrumentation.RecursiveMethodInstrumentor1;
import org.netbeans.lib.profiler.instrumentation.RecursiveMethodInstrumentor2;
import org.netbeans.lib.profiler.instrumentation.RecursiveMethodInstrumentor3;
import org.netbeans.lib.profiler.instrumentation.RootMethods;
import org.netbeans.lib.profiler.wireprotocol.ClassLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupCommand;
import org.netbeans.lib.profiler.wireprotocol.InstrumentMethodGroupResponse;
import org.netbeans.lib.profiler.wireprotocol.MethodInvokedFirstTimeCommand;
import org.netbeans.lib.profiler.wireprotocol.MethodLoadedCommand;
import org.netbeans.lib.profiler.wireprotocol.RootClassLoadedCommand;

public class Instrumentor
implements CommonConstants {
    private static final boolean DEBUG = System.getProperty("org.netbeans.lib.profiler.instrumentation.Instrumentor") != null;
    private CodeRegionMethodInstrumentor crms;
    private MemoryProfMethodInstrumentor oms;
    private ProfilerEngineSettings settings;
    private ProfilingSessionStatus status;
    private RecursiveMethodInstrumentor ms;
    private RootMethods rootMethods;
    private ClientUtils.SourceCodeSelection savedSourceCodeSelection;

    public Instrumentor(ProfilingSessionStatus profilingSessionStatus, ProfilerEngineSettings profilerEngineSettings) {
        this.status = profilingSessionStatus;
        this.settings = profilerEngineSettings;
    }

    public int getClassId(String string, int n) {
        BaseClassInfo baseClassInfo;
        if (string.charAt(0) == '[') {
            if (string.endsWith(";")) {
                int n2 = string.indexOf(76);
                string = new StringBuffer(string).deleteCharAt(string.length() - 1).deleteCharAt(n2).toString();
            }
            baseClassInfo = ClassRepository.lookupSpecialClass(string);
        } else {
            baseClassInfo = ClassRepository.lookupClassOrCreatePlaceholder(string, n);
        }
        if (baseClassInfo == null) {
            System.err.println("Warning: could not find class " + string + " loaded by the VM on the class path");
            return -1;
        }
        return baseClassInfo.getInstrClassId();
    }

    public synchronized InstrumentMethodGroupCommand getCommandToUnprofileClasses(boolean[] blArray) {
        ObjLivenessMethodInstrumentor objLivenessMethodInstrumentor = (ObjLivenessMethodInstrumentor)this.oms;
        Object[] objectArray = objLivenessMethodInstrumentor.getMethodsToInstrumentUponClassUnprofiling(blArray);
        if (objectArray == null) {
            return new InstrumentMethodGroupCommand(null);
        }
        return new InstrumentMethodGroupCommand(5, (String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[2], null, this.oms.getNInstantiatableClasses());
    }

    public String[] getRootClassNames() {
        ArrayList<String> arrayList = this.rootMethods.getRootClassNames();
        RuntimeProfilingPoint[] runtimeProfilingPointArray = this.settings.getRuntimeProfilingPoints();
        if (arrayList == null && runtimeProfilingPointArray.length > 0) {
            arrayList = new ArrayList<String>();
        }
        for (int i = 0; i < runtimeProfilingPointArray.length; ++i) {
            RuntimeProfilingPoint runtimeProfilingPoint = runtimeProfilingPointArray[i];
            String string = runtimeProfilingPoint.getClassName();
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void setSavedSourceCodeSelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.savedSourceCodeSelection = sourceCodeSelectionArray[0];
    }

    public void setStatusInfoFromSourceCodeSelection(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) throws ClassNotFoundException, BadLocationException, IOException, ClassFormatError {
        ClientUtils.SourceCodeSelection sourceCodeSelection;
        Object var2_2 = null;
        if (sourceCodeSelectionArray.length > 0 && (sourceCodeSelection = sourceCodeSelectionArray[0]).definedViaSourceLines()) {
            this.status.instrStartLine = sourceCodeSelection.getStartLine();
            this.status.instrEndLine = sourceCodeSelection.getEndLine();
        }
        this.rootMethods = new RootMethods(sourceCodeSelectionArray);
    }

    public synchronized InstrumentMethodGroupCommand createClearAllInstrumentationCommand() {
        Object[] objectArray = null;
        switch (this.status.currentInstrType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.ms = null;
                objectArray = new MiscInstrumentationOps(this.status).getOrigCodeForAllInstrumentedMethods();
                break;
            }
            case 1: {
                objectArray = new MiscInstrumentationOps(this.status).getOrigCodeForSingleInstrumentedMethod(this.rootMethods);
            }
        }
        this.ms = null;
        this.oms = null;
        this.crms = null;
        if (objectArray == null) {
            return new InstrumentMethodGroupCommand(null);
        }
        return new InstrumentMethodGroupCommand(0, (String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[2], null, 0);
    }

    public synchronized InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponse(Command command) {
        Object object;
        if (command instanceof ClassLoadedCommand) {
            byte[] byArray;
            object = (ClassLoadedCommand)command;
            int[] nArray = ((ClassLoadedCommand)object).getThisAndParentLoaderData();
            if (DEBUG) {
                System.err.println("Instrumentor.DEBUG: Class loaded command: " + command.toString());
            }
            if ((byArray = ((ClassLoadedCommand)object).getClassFileBytes()) != null) {
                ClassRepository.addVMSuppliedClassFile(((ClassLoadedCommand)object).getClassName(), nArray[0], byArray);
            }
            ClassLoaderTable.addChildAndParent(nArray);
        } else if (command instanceof MethodLoadedCommand) {
            object = (MethodLoadedCommand)command;
            if (DEBUG) {
                System.err.println("Instrumentor.DEBUG: Method loaded command: " + ((MethodLoadedCommand)object).toString());
            }
        }
        object = null;
        switch (this.status.currentInstrType) {
            case 2: 
            case 3: {
                object = this.createFollowUpInstrumentMethodGroupResponseForCallGraph(command);
                break;
            }
            case 1: {
                if (!(command instanceof ClassLoadedCommand)) {
                    return new InstrumentMethodGroupResponse((Object)null);
                }
                object = this.createFollowUpInstrumentMethodGroupResponseForCodeRegion((ClassLoadedCommand)command);
                break;
            }
            case 4: 
            case 5: {
                if (!(command instanceof ClassLoadedCommand)) {
                    return new InstrumentMethodGroupResponse((Object)null);
                }
                object = this.createFollowUpInstrumentMethodGroupResponseForMemoryProfiling((ClassLoadedCommand)command);
                break;
            }
            default: {
                object = new InstrumentMethodGroupResponse((Object)null);
            }
        }
        return object;
    }

    public synchronized InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponse(RootClassLoadedCommand rootClassLoadedCommand) throws ClassNotFoundException, BadLocationException {
        ClassLoaderTable.initTable(rootClassLoadedCommand.getParentLoaderIds());
        InstrumentMethodGroupResponse instrumentMethodGroupResponse = null;
        switch (this.status.currentInstrType) {
            case 2: 
            case 3: {
                instrumentMethodGroupResponse = this.createInitialInstrumentMethodGroupResponseForCallGraph(rootClassLoadedCommand.getAllLoadedClassNames(), rootClassLoadedCommand.getAllLoadedClassLoaderIds(), rootClassLoadedCommand.getCachedClassFileBytes());
                break;
            }
            case 1: {
                instrumentMethodGroupResponse = this.createInitialInstrumentMethodGroupResponseForCodeRegion(rootClassLoadedCommand.getAllLoadedClassNames(), rootClassLoadedCommand.getAllLoadedClassLoaderIds(), rootClassLoadedCommand.getCachedClassFileBytes());
                break;
            }
            case 4: 
            case 5: {
                instrumentMethodGroupResponse = this.createInitialInstrumentMethodGroupResponseForMemoryProfiling(this.status.currentInstrType, rootClassLoadedCommand.getAllLoadedClassNames(), rootClassLoadedCommand.getAllLoadedClassLoaderIds(), rootClassLoadedCommand.getCachedClassFileBytes());
                break;
            }
            default: {
                System.err.println("*** Profiler engine warning: Instrumentor.createInitialInstrumentMethodGroupResponse() called with INSTR_NONE?");
                System.err.println("*** Please report this problem to feedback@profiler.netbeans.org");
                instrumentMethodGroupResponse = new InstrumentMethodGroupResponse((Object)null);
            }
        }
        return instrumentMethodGroupResponse;
    }

    public void resetPerVMInstanceData() {
        ClassRepository.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponseForCallGraph(Command command) {
        Object[] objectArray = null;
        if (this.ms == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        if (command instanceof MethodInvokedFirstTimeCommand) {
            int n = ((MethodInvokedFirstTimeCommand)command).getMethodId();
            this.status.beginTrans(false);
            try {
                if (n >= this.status.getInstrMethodClasses().length || this.status.getInstrMethodClasses()[n] == null) {
                    InstrumentMethodGroupResponse instrumentMethodGroupResponse = new InstrumentMethodGroupResponse((Object)null);
                    return instrumentMethodGroupResponse;
                }
                objectArray = this.ms.getMethodsToInstrumentUponMethodInvocation(this.status.getInstrMethodClasses()[n], this.status.getClassLoaderIds()[n], this.status.getInstrMethodNames()[n], this.status.getInstrMethodSignatures()[n]);
            }
            finally {
                this.status.endTrans();
            }
        } else if (command instanceof ClassLoadedCommand) {
            ClassLoadedCommand classLoadedCommand = (ClassLoadedCommand)command;
            objectArray = this.ms.getMethodsToInstrumentUponClassLoad(classLoadedCommand.getClassName(), classLoadedCommand.getThisAndParentLoaderData()[0], classLoadedCommand.getThreadInCallGraph());
        } else if (command instanceof MethodLoadedCommand) {
            MethodLoadedCommand methodLoadedCommand = (MethodLoadedCommand)command;
            objectArray = this.ms.getMethodsToInstrumentUponReflectInvoke(methodLoadedCommand.getClassName(), methodLoadedCommand.getClassLoaderId(), methodLoadedCommand.getMethodName(), methodLoadedCommand.getMethodSignature());
        }
        if (objectArray == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[3], (boolean[])objectArray[2], 0);
    }

    private InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponseForCodeRegion(ClassLoadedCommand classLoadedCommand) {
        if (this.crms == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        Object[] objectArray = this.crms.getFollowUpInstrumentCodeRegionResponse(classLoadedCommand.getThisAndParentLoaderData()[0]);
        if (objectArray == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[2], null, 0);
    }

    private InstrumentMethodGroupResponse createFollowUpInstrumentMethodGroupResponseForMemoryProfiling(ClassLoadedCommand classLoadedCommand) {
        if (this.oms == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        Object[] objectArray = this.oms.getMethodsToInstrumentUponClassLoad(classLoadedCommand.getClassName(), classLoadedCommand.getThisAndParentLoaderData()[0]);
        if (objectArray == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        int n = this.status.getNInstrClasses();
        return new InstrumentMethodGroupResponse((String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[2], null, n);
    }

    private InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponseForCallGraph(String[] stringArray, int[] nArray, byte[][] byArray) {
        switch (this.settings.getInstrScheme()) {
            case 1: {
                this.ms = new RecursiveMethodInstrumentor1(this.status, this.settings);
                break;
            }
            case 2: {
                this.ms = new RecursiveMethodInstrumentor2(this.status, this.settings);
                break;
            }
            case 3: {
                this.ms = new RecursiveMethodInstrumentor3(this.status, this.settings);
            }
        }
        Object[] objectArray = this.ms.getInitialMethodsToInstrument(stringArray, nArray, byArray, this.rootMethods);
        if (objectArray == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[3], (boolean[])objectArray[2], 0);
    }

    private InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponseForCodeRegion(String[] stringArray, int[] nArray, byte[][] byArray) throws ClassNotFoundException, BadLocationException {
        CodeRegionMethodInstrumentor.resetLoadedClassData();
        ClassManager.storeClassFileBytesForCustomLoaderClasses(stringArray, nArray, byArray);
        this.crms = new CodeRegionMethodInstrumentor(this.status, this.savedSourceCodeSelection);
        Object[] objectArray = this.crms.getInitialInstrumentCodeRegionResponse(stringArray, nArray);
        if (objectArray == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        return new InstrumentMethodGroupResponse((String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[2], null, 0);
    }

    private InstrumentMethodGroupResponse createInitialInstrumentMethodGroupResponseForMemoryProfiling(int n, String[] stringArray, int[] nArray, byte[][] byArray) {
        this.oms = new ObjLivenessMethodInstrumentor(this.status, this.settings, n == 5);
        Object[] objectArray = this.oms.getInitialMethodsToInstrument(stringArray, nArray, byArray);
        if (objectArray == null) {
            return new InstrumentMethodGroupResponse((Object)null);
        }
        int n2 = this.oms.getNInstantiatableClasses() + this.status.getNInstrClasses();
        return new InstrumentMethodGroupResponse((String[])objectArray[0], (int[])objectArray[1], (byte[][])objectArray[2], null, n2);
    }
}

