/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public class ConstantPoolExtension
implements JavaClassConstants {
    protected byte[] addedCPContents;
    protected int nAddedEntries;

    protected ConstantPoolExtension(PackedCPFragment packedCPFragment, int n, int n2) {
        this.addedCPContents = packedCPFragment.getRelocatedCPBytes(n, n2);
        this.nAddedEntries = packedCPFragment.nEntries;
    }

    protected ConstantPoolExtension() {
    }

    public byte[] getConcatenatedContents(ConstantPoolExtension constantPoolExtension) {
        if (this.addedCPContents == null) {
            return constantPoolExtension.getContents();
        }
        if (constantPoolExtension.addedCPContents == null) {
            return this.getContents();
        }
        byte[] byArray = new byte[this.addedCPContents.length + constantPoolExtension.addedCPContents.length];
        System.arraycopy(this.addedCPContents, 0, byArray, 0, this.addedCPContents.length);
        System.arraycopy(constantPoolExtension.addedCPContents, 0, byArray, this.addedCPContents.length, constantPoolExtension.addedCPContents.length);
        return byArray;
    }

    public byte[] getContents() {
        return this.addedCPContents;
    }

    public int getNEntries() {
        return this.nAddedEntries;
    }

    public static class PackedCPFragment {
        private static byte[] tmpBytes = new byte[64];
        int nEntries;
        private byte[] cpoolBytes;
        private char[] externalIndices;
        private char[] internalIndices;

        public PackedCPFragment(CPEntry[] cPEntryArray) {
            int n;
            this.nEntries = cPEntryArray.length;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            block10: for (n = 0; n < this.nEntries; ++n) {
                switch (cPEntryArray[n].tag) {
                    case 7: {
                        n2 += 3;
                        if (cPEntryArray[n].index1 <= 65535) {
                            ++n3;
                            continue block10;
                        }
                        ++n4;
                        continue block10;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        n2 += 5;
                        if (cPEntryArray[n].index1 <= 65535) {
                            ++n3;
                        } else {
                            ++n4;
                        }
                        if (cPEntryArray[n].index2 <= 65535) {
                            ++n3;
                            continue block10;
                        }
                        ++n4;
                        continue block10;
                    }
                    case 1: {
                        n2 += 3 + cPEntryArray[n].utf8.length();
                        continue block10;
                    }
                    default: {
                        System.err.println("*** PackedAddedCPool : unsupported constant!");
                    }
                }
            }
            this.cpoolBytes = new byte[n2];
            this.internalIndices = new char[n3];
            this.externalIndices = new char[n4];
            n = 0;
            n3 = 0;
            n4 = 0;
            block11: for (int i = 0; i < this.nEntries; ++i) {
                switch (cPEntryArray[i].tag) {
                    case 7: {
                        this.cpoolBytes[n++] = cPEntryArray[i].tag;
                        if (cPEntryArray[i].index1 <= 65535) {
                            this.internalIndices[n3++] = (char)n;
                        } else {
                            this.externalIndices[n4++] = (char)n;
                        }
                        this.cpoolBytes[n++] = (byte)(cPEntryArray[i].index1 >> 8 & 0xFF);
                        this.cpoolBytes[n++] = (byte)(cPEntryArray[i].index1 & 0xFF);
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.cpoolBytes[n++] = cPEntryArray[i].tag;
                        if (cPEntryArray[i].index1 <= 65535) {
                            this.internalIndices[n3++] = (char)n;
                        } else {
                            this.externalIndices[n4++] = (char)n;
                        }
                        this.cpoolBytes[n++] = (byte)(cPEntryArray[i].index1 >> 8 & 0xFF);
                        this.cpoolBytes[n++] = (byte)(cPEntryArray[i].index1 & 0xFF);
                        if (cPEntryArray[i].index2 <= 65535) {
                            this.internalIndices[n3++] = (char)n;
                        } else {
                            this.externalIndices[n4++] = (char)n;
                        }
                        this.cpoolBytes[n++] = (byte)(cPEntryArray[i].index2 >> 8 & 0xFF);
                        this.cpoolBytes[n++] = (byte)(cPEntryArray[i].index2 & 0xFF);
                        continue block11;
                    }
                    case 1: {
                        this.cpoolBytes[n++] = cPEntryArray[i].tag;
                        String string = cPEntryArray[i].utf8;
                        int n5 = string.length();
                        this.cpoolBytes[n++] = (byte)(n5 >> 8 & 0xFF);
                        this.cpoolBytes[n++] = (byte)(n5 & 0xFF);
                        for (int j = 0; j < n5; ++j) {
                            PackedCPFragment.tmpBytes[j] = (byte)string.charAt(j);
                        }
                        System.arraycopy(tmpBytes, 0, this.cpoolBytes, n, n5);
                        n += n5;
                        continue block11;
                    }
                    default: {
                        System.err.println("*** PackedAddedCPool : unsupported constant!");
                    }
                }
            }
        }

        public byte[] getRelocatedCPBytes(int n, int n2) {
            int n3;
            char c;
            int n4;
            byte[] byArray = new byte[this.cpoolBytes.length];
            System.arraycopy(this.cpoolBytes, 0, byArray, 0, this.cpoolBytes.length);
            for (n4 = 0; n4 < this.internalIndices.length; ++n4) {
                c = this.internalIndices[n4];
                n3 = (byArray[c] << 8) + byArray[c + '\u0001'];
                byArray[c] = (byte)((n3 += n) >> 8 & 0xFF);
                byArray[c + '\u0001'] = (byte)(n3 & 0xFF);
            }
            for (n4 = 0; n4 < this.externalIndices.length; ++n4) {
                c = this.externalIndices[n4];
                n3 = (byArray[c] << 8) + byArray[c + '\u0001'];
                byArray[c] = (byte)((n3 += n2) >> 8 & 0xFF);
                byArray[c + '\u0001'] = (byte)(n3 & 0xFF);
            }
            return byArray;
        }
    }

    public static class CPEntry {
        String utf8;
        byte tag;
        int index1;
        int index2;

        public CPEntry(int n) {
            this.tag = (byte)n;
        }

        public CPEntry(String string) {
            this.tag = 1;
            this.utf8 = string;
        }

        public void setIndex1(int n) {
            this.index1 = n;
        }

        public void setIndex2(int n) {
            this.index2 = n;
        }
    }
}

