/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Iterator;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaClass;

class ComputedSummary
implements HeapSummary {
    private int bytes;
    private int instances;
    private long time;

    ComputedSummary(HprofHeap hprofHeap) {
        Iterator iterator = hprofHeap.getAllClasses().iterator();
        while (iterator.hasNext()) {
            JavaClass javaClass = (JavaClass)iterator.next();
            this.instances += javaClass.getInstancesCount();
            this.bytes += javaClass.getAllInstancesSize();
        }
        this.time = hprofHeap.dumpBuffer.getTime();
    }

    public long getTime() {
        return this.time;
    }

    public long getTotalAllocatedBytes() {
        return -1L;
    }

    public long getTotalAllocatedInstances() {
        return -1L;
    }

    public int getTotalLiveBytes() {
        return this.bytes;
    }

    public int getTotalLiveInstances() {
        return this.instances;
    }
}

