/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.stp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.profiler.ui.HyperlinkLabel;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsPanel;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MonitorSettingsAdvancedPanel
extends DefaultSettingsPanel
implements HelpCtx.Provider {
    private static final String DO_NOT_OVERRIDE_STRING = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_DoNotOverrideString");
    private static final String CHOOSE_WORKDIR_DIALOG_CAPTION = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_ChooseWorkDirDialogCaption");
    private static final String GLOBAL_SETTINGS_CAPTION = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_GlobalSettingsCaption");
    private static final String OVERRIDE_SETTINGS_CHECKBOX_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_OverrideSettingsCheckboxText");
    private static final String WORKDIR_LABEL_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_WorkDirLabelText");
    private static final String CHOOSE_WORKDIR_LINK_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_ChooseWorkDirLinkText");
    private static final String JAVA_PLATFORM_LABEL_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_JavaPlatformLabelText");
    private static final String JVM_ARGUMENTS_LABEL_TEXT = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"MonitorSettingsAdvancedPanel_JvmArgumentsLabelText");
    private static final String STP_OVERRIDE_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpOverrideTooltip");
    private static final String STP_WORKDIR_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpWorkDirTooltip");
    private static final String STP_JPLATFORM_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpJPlatformTooltip");
    private static final String STP_VMARGS_TOOLTIP = NbBundle.getMessage(MonitorSettingsAdvancedPanel.class, (String)"StpVmArgsTooltip");
    private static final String HELP_CTX_KEY = "MonitorSettings.Advanced.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("MonitorSettings.Advanced.HelpCtx");
    private HyperlinkLabel workingDirectorySelectLink;
    private JCheckBox overrideSettingsCheckbox;
    private JComboBox javaPlatformCombo;
    private JLabel javaPlatformLabel;
    private JLabel vmArgumentsLabel;
    private JLabel workingDirectoryLabel;
    private JPanel globalSettingsPanel;
    private JTextField vmArgumentsTextField;
    private JTextField workingDirectoryTextField;
    private WeakReference<JFileChooser> workingDirectoryChooserReference;

    public MonitorSettingsAdvancedPanel() {
        this.initComponents();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public void setJavaPlatformName(String string) {
        this.updateJavaPlatformCombo(string);
    }

    public String getJavaPlatformName() {
        int n = this.javaPlatformCombo.getSelectedIndex();
        if (n == 0) {
            return null;
        }
        return this.javaPlatformCombo.getSelectedItem().toString();
    }

    public void setOverrideAvailable(boolean bl) {
        this.overrideSettingsCheckbox.setEnabled(bl);
        this.workingDirectoryLabel.setEnabled(bl);
        this.workingDirectoryTextField.setEnabled(bl);
        this.workingDirectorySelectLink.setEnabled(bl);
        this.javaPlatformLabel.setEnabled(bl);
        this.javaPlatformCombo.setEnabled(bl);
        this.vmArgumentsLabel.setEnabled(bl);
        this.vmArgumentsTextField.setEnabled(bl);
    }

    public void setOverrideSettings(boolean bl) {
        this.overrideSettingsCheckbox.setSelected(bl);
        this.updateEnabling();
    }

    public boolean getOverrideSettings() {
        return this.overrideSettingsCheckbox.isSelected();
    }

    public void setVMArguments(String string) {
        this.vmArgumentsTextField.setText(string);
    }

    public String getVMArguments() {
        return this.vmArgumentsTextField.getText().trim();
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectoryTextField.setText(string);
    }

    public String getWorkingDirectory() {
        return this.workingDirectoryTextField.getText().trim();
    }

    public void disableAll() {
        this.overrideSettingsCheckbox.setEnabled(false);
        this.workingDirectoryLabel.setEnabled(false);
        this.workingDirectoryTextField.setEnabled(false);
        this.workingDirectorySelectLink.setEnabled(false);
        this.javaPlatformLabel.setEnabled(false);
        this.javaPlatformCombo.setEnabled(false);
        this.vmArgumentsLabel.setEnabled(false);
        this.vmArgumentsTextField.setEnabled(false);
    }

    public void enableAll() {
        this.overrideSettingsCheckbox.setEnabled(true);
        this.workingDirectoryLabel.setEnabled(true);
        this.workingDirectoryTextField.setEnabled(true);
        this.workingDirectorySelectLink.setEnabled(true);
        this.javaPlatformLabel.setEnabled(true);
        this.javaPlatformCombo.setEnabled(true);
        this.vmArgumentsLabel.setEnabled(true);
        this.vmArgumentsTextField.setEnabled(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFrame jFrame = new JFrame("Tester Frame");
        MonitorSettingsAdvancedPanel monitorSettingsAdvancedPanel = new MonitorSettingsAdvancedPanel();
        monitorSettingsAdvancedPanel.setPreferredSize(new Dimension(375, 255));
        jFrame.getContentPane().add(monitorSettingsAdvancedPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    private JFileChooser getFileChooser() {
        JFileChooser jFileChooser;
        if (this.workingDirectoryChooserReference == null || this.workingDirectoryChooserReference.get() == null) {
            jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.setDialogType(0);
            jFileChooser.setDialogTitle(CHOOSE_WORKDIR_DIALOG_CAPTION);
            this.workingDirectoryChooserReference = new WeakReference<JFileChooser>(jFileChooser);
        } else {
            jFileChooser = (JFileChooser)this.workingDirectoryChooserReference.get();
        }
        return jFileChooser;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.globalSettingsPanel = new JPanel(new GridBagLayout());
        this.globalSettingsPanel.setOpaque(false);
        this.globalSettingsPanel.setBorder(BorderFactory.createTitledBorder(GLOBAL_SETTINGS_CAPTION));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.globalSettingsPanel, gridBagConstraints);
        this.overrideSettingsCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.overrideSettingsCheckbox, (String)OVERRIDE_SETTINGS_CHECKBOX_TEXT);
        this.overrideSettingsCheckbox.setToolTipText(STP_OVERRIDE_TOOLTIP);
        this.overrideSettingsCheckbox.setOpaque(false);
        this.overrideSettingsCheckbox.setSelected(true);
        this.overrideSettingsCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MonitorSettingsAdvancedPanel.this.updateEnabling();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 7, 0, 0);
        this.globalSettingsPanel.add((Component)this.overrideSettingsCheckbox, gridBagConstraints);
        this.workingDirectoryLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.workingDirectoryLabel, (String)WORKDIR_LABEL_TEXT);
        this.workingDirectoryLabel.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryLabel, gridBagConstraints);
        this.workingDirectoryTextField = new JTextField(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.workingDirectoryLabel.setLabelFor(this.workingDirectoryTextField);
        this.workingDirectoryTextField.setToolTipText(STP_WORKDIR_TOOLTIP);
        this.workingDirectoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                MonitorSettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MonitorSettingsAdvancedPanel.this.checkWorkingDirectory();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                MonitorSettingsAdvancedPanel.this.checkWorkingDirectory();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.workingDirectoryTextField, gridBagConstraints);
        Color color = Color.RED;
        String string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        this.workingDirectorySelectLink = new HyperlinkLabel("<a href='#'>" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", "<a href='#' color=\"" + string + "\">" + CHOOSE_WORKDIR_LINK_TEXT + "</a>", new Runnable(){

            public void run() {
                JFileChooser jFileChooser = MonitorSettingsAdvancedPanel.this.getFileChooser();
                jFileChooser.setCurrentDirectory(new File(MonitorSettingsAdvancedPanel.this.workingDirectoryTextField.getText().trim()));
                if (jFileChooser.showOpenDialog(null) == 0) {
                    MonitorSettingsAdvancedPanel.this.workingDirectoryTextField.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.workingDirectorySelectLink.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 4, 0, 3);
        this.globalSettingsPanel.add((Component)((Object)this.workingDirectorySelectLink), gridBagConstraints);
        this.javaPlatformLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.javaPlatformLabel, (String)JAVA_PLATFORM_LABEL_TEXT);
        this.javaPlatformLabel.setToolTipText(STP_JPLATFORM_TOOLTIP);
        this.javaPlatformLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformLabel, gridBagConstraints);
        this.javaPlatformCombo = new JComboBox(new Object[]{DO_NOT_OVERRIDE_STRING}){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.javaPlatformLabel.setLabelFor(this.javaPlatformCombo);
        this.javaPlatformCombo.setToolTipText(STP_JPLATFORM_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.globalSettingsPanel.add((Component)this.javaPlatformCombo, gridBagConstraints);
        this.vmArgumentsLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.vmArgumentsLabel, (String)JVM_ARGUMENTS_LABEL_TEXT);
        this.vmArgumentsLabel.setToolTipText(STP_VMARGS_TOOLTIP);
        this.vmArgumentsLabel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 19, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsLabel, gridBagConstraints);
        this.vmArgumentsTextField = new JTextField(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.vmArgumentsLabel.setLabelFor(this.vmArgumentsTextField);
        this.vmArgumentsTextField.setToolTipText(STP_VMARGS_TOOLTIP);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 8, 0);
        this.globalSettingsPanel.add((Component)this.vmArgumentsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Utils.createFillerPanel(), gridBagConstraints);
    }

    private void updateEnabling() {
        boolean bl = this.overrideSettingsCheckbox.isSelected() && this.overrideSettingsCheckbox.isEnabled();
        this.workingDirectoryLabel.setEnabled(bl);
        this.workingDirectoryTextField.setEnabled(bl);
        this.workingDirectorySelectLink.setEnabled(bl);
        this.javaPlatformLabel.setEnabled(bl);
        this.javaPlatformCombo.setEnabled(bl);
        this.vmArgumentsLabel.setEnabled(bl);
        this.vmArgumentsTextField.setEnabled(bl);
    }

    private void checkWorkingDirectory() {
        String string = this.workingDirectoryTextField.getText().trim();
        if (string.length() == 0 || new File(string).exists()) {
            this.workingDirectoryTextField.setForeground(UIManager.getColor("TextField.foreground"));
        } else {
            this.workingDirectoryTextField.setForeground(Color.RED);
        }
    }

    private void updateJavaPlatformCombo(String string) {
        String[] stringArray = new String[]{DO_NOT_OVERRIDE_STRING};
        this.javaPlatformCombo.setModel(new DefaultComboBoxModel<String>(stringArray));
        if (string != null) {
            this.javaPlatformCombo.setSelectedItem(string);
        } else {
            this.javaPlatformCombo.setSelectedIndex(0);
        }
    }
}

