/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.MessageFormat;
import java.util.List;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;
import org.openide.util.NbBundle;

public class PrimitiveArrayNode
extends ArrayNode {
    private static final String TRUNCATED_STRING = NbBundle.getMessage(PrimitiveArrayNode.class, (String)"PrimitiveArrayNode_TruncatedString");
    private static final String ITEMS_NUMBER_STRING = NbBundle.getMessage(PrimitiveArrayNode.class, (String)"PrimitiveArrayNode_ItemsNumberString");
    private static final String LOOP_TO_STRING = NbBundle.getMessage(PrimitiveArrayNode.class, (String)"PrimitiveArrayNode_LoopToString");
    private static final int MAX_CHAR_ARRAY_STRING_SIZE = 128;

    public PrimitiveArrayNode(PrimitiveArrayInstance primitiveArrayInstance, String string, HeapWalkerNode heapWalkerNode) {
        super((Instance)primitiveArrayInstance, string, heapWalkerNode);
    }

    public PrimitiveArrayNode(PrimitiveArrayInstance primitiveArrayInstance, String string, HeapWalkerNode heapWalkerNode, int n) {
        super((Instance)primitiveArrayInstance, string, heapWalkerNode, n);
    }

    public PrimitiveArrayInstance getInstance() {
        return (PrimitiveArrayInstance)super.getInstance();
    }

    public boolean isPrimitive() {
        return true;
    }

    protected ChildrenComputer getChildrenComputer() {
        return new ChildrenComputer(){

            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] heapWalkerNodeArray;
                block10: {
                    block9: {
                        heapWalkerNodeArray = null;
                        if (PrimitiveArrayNode.this.getMode() != 1) break block9;
                        int n = PrimitiveArrayNode.this.getInstance().getLength();
                        if (n == 0) {
                            heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoItemsNode(PrimitiveArrayNode.this)};
                        } else if (n > HeapWalkerNodeFactory.ITEMS_COLLAPSE_UNIT_SIZE) {
                            int n2 = n;
                            BrowserUtils.GroupingInfo groupingInfo = BrowserUtils.getGroupingInfo(n2);
                            int n3 = groupingInfo.containersCount;
                            int n4 = groupingInfo.collapseUnitSize;
                            heapWalkerNodeArray = new HeapWalkerNode[n3];
                            for (int i = 0; i < n3; ++i) {
                                int n5 = n4 * i;
                                int n6 = Math.min(n5 + n4, n2) - 1;
                                heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createArrayItemContainerNode(PrimitiveArrayNode.this, n5, n6);
                            }
                        } else {
                            List list = PrimitiveArrayNode.this.getInstance().getValues();
                            heapWalkerNodeArray = new HeapWalkerNode[list.size()];
                            for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                                heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createPrimitiveArrayItemNode(PrimitiveArrayNode.this, i, (String)list.get(i));
                            }
                        }
                        break block10;
                    }
                    if (PrimitiveArrayNode.this.getMode() != 2) break block10;
                    List list = PrimitiveArrayNode.this.getInstance().getReferences();
                    if (list.size() == 0) {
                        heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoReferencesNode(PrimitiveArrayNode.this)};
                    } else {
                        heapWalkerNodeArray = new HeapWalkerNode[list.size()];
                        for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                            heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createReferenceNode((Value)list.get(i), PrimitiveArrayNode.this);
                        }
                    }
                }
                return heapWalkerNodeArray;
            }
        };
    }

    protected String computeValue() {
        if (!this.hasInstance()) {
            return super.computeValue();
        }
        if (this.getInstance().getJavaClass().getName().equals("char[]")) {
            List list = this.getInstance().getValues();
            StringBuffer stringBuffer = new StringBuffer();
            int n = list.size();
            boolean bl = false;
            if (n > 128) {
                bl = true;
                n = 128;
            }
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((String)list.get(i));
            }
            if (bl) {
                stringBuffer.append(TRUNCATED_STRING);
            }
            return super.computeValue() + " (\"" + stringBuffer.toString() + "\"" + ")";
        }
        return super.computeValue() + " " + MessageFormat.format(ITEMS_NUMBER_STRING, this.getInstance().getLength());
    }

    public static abstract class RootNode
    extends PrimitiveArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(PrimitiveArrayInstance primitiveArrayInstance, String string, HeapWalkerNode heapWalkerNode) {
            super(primitiveArrayInstance, string, heapWalkerNode);
        }

        public RootNode(PrimitiveArrayInstance primitiveArrayInstance, String string, HeapWalkerNode heapWalkerNode, int n) {
            super(primitiveArrayInstance, string, heapWalkerNode, n);
        }

        public abstract void refreshView();
    }

    public static class ArrayItem
    extends PrimitiveArrayNode
    implements org.netbeans.modules.profiler.heapwalk.model.ArrayItem {
        private int itemIndex;

        public ArrayItem(int n, PrimitiveArrayInstance primitiveArrayInstance, HeapWalkerNode heapWalkerNode) {
            this(n, primitiveArrayInstance, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
        }

        public ArrayItem(int n, PrimitiveArrayInstance primitiveArrayInstance, HeapWalkerNode heapWalkerNode, int n2) {
            super(primitiveArrayInstance, null, heapWalkerNode, n2);
            this.itemIndex = n;
        }

        public int getItemIndex() {
            return this.itemIndex;
        }

        protected String computeName() {
            String string = "[" + this.itemIndex + "]";
            if (this.isLoop()) {
                return string + " " + MessageFormat.format(LOOP_TO_STRING, BrowserUtils.getFullNodeName(this.getLoopTo()));
            }
            return string;
        }

        protected String computeType() {
            if (!this.hasInstance()) {
                return BrowserUtils.getArrayItemType(this.getType());
            }
            return super.computeType();
        }
    }
}

