/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapFactory;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.heapwalk.ClassesListController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.netbeans.modules.profiler.heapwalk.ui.HeapWalkerUI;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class HeapWalker {
    private static final String HEAPWALKER_DEFAULT_NAME = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_HeapWalkerDefaultName");
    private static final String HEAPWALKER_CUSTOM_NAME = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_HeapWalkerCustomName");
    private static final String LOADING_DUMP_MSG = NbBundle.getMessage(ClassesListController.class, (String)"ClassesListController_LoadingDumpMsg");
    private File heapDumpFile;
    private HeapFragmentWalker mainHeapWalker;
    private HeapWalkerUI heapWalkerUI;
    private String heapWalkerName = HEAPWALKER_DEFAULT_NAME;

    public HeapWalker(Heap heap) {
        this.createMainFragment(heap);
    }

    public HeapWalker(File file) throws FileNotFoundException, IOException {
        this(HeapWalker.createHeap(file));
        String string;
        this.heapDumpFile = file;
        String string2 = this.heapDumpFile.getName();
        int n = string2.lastIndexOf(".");
        if (n == -1) {
            string = string2;
        } else {
            string = string2.substring(0, n);
            if (string.startsWith("heapdump-")) {
                String string3 = string.substring("heapdump-".length(), string.length());
                try {
                    long l = Long.parseLong(string3);
                    string = StringUtils.formatUserDate((Date)new Date(l));
                }
                catch (NumberFormatException numberFormatException) {
                    string = string2;
                }
            } else {
                string = string2;
            }
        }
        this.heapWalkerName = MessageFormat.format(HEAPWALKER_CUSTOM_NAME, string);
    }

    public File getHeapDumpFile() {
        return this.heapDumpFile;
    }

    public HeapFragmentWalker getMainHeapWalker() {
        return this.mainHeapWalker;
    }

    public String getName() {
        return this.heapWalkerName;
    }

    public void open() {
        HeapWalkerManager.getDefault().openHeapWalker(this);
    }

    public TopComponent getTopComponent() {
        if (this.heapWalkerUI == null) {
            this.heapWalkerUI = new HeapWalkerUI(this);
        }
        return this.heapWalkerUI;
    }

    void createMainFragment(Heap heap) {
        this.mainHeapWalker = new HeapFragmentWalker(heap, this);
    }

    void createReachableFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    void createRetainedFragment(Instance instance) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Heap createHeap(File file) throws FileNotFoundException, IOException {
        ProgressHandle progressHandle = null;
        try {
            progressHandle = ProgressHandleFactory.createHandle((String)LOADING_DUMP_MSG);
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            Heap heap = HeapFactory.createHeap((File)file);
            heap.getSummary();
            Heap heap2 = heap;
            return heap2;
        }
        finally {
            if (progressHandle != null) {
                progressHandle.finish();
            }
        }
    }
}

