/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.charts.ChartModelListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChartModel;
import org.netbeans.lib.profiler.ui.memory.ActionsHandler;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.HistoryListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class History
implements SynchronousXYChartModel,
ActionsHandler,
ProfilingStateListener {
    private static final int HISTORY_LENGTH = 1024;
    private static final String LIVE_OBJECS = NbBundle.getMessage(History.class, (String)"History_LiveObjects");
    private static final String ALLOCATED_OBJECS = NbBundle.getMessage(History.class, (String)"History_AllocatedObjects");
    private static final String ALLOCATED_SIZE = NbBundle.getMessage(History.class, (String)"History_AllocatedSize");
    private static final String LOGGING_CONFIRMATION_CAPTION = NbBundle.getMessage(History.class, (String)"History_LoggingConfirmationCaption");
    private static final String LOGGING_RESET_MSG = NbBundle.getMessage(History.class, (String)"History_LoggingResetMsg");
    private static final String LOGGING_STOP_MSG = NbBundle.getMessage(History.class, (String)"History_LoggingStopMsg");
    private static History instance = null;
    protected Color[] seriesColors = new Color[]{new Color(255, 127, 127), new Color(127, 63, 191)};
    protected String[] seriesNames1 = new String[]{ALLOCATED_OBJECS, ALLOCATED_SIZE};
    protected String[] seriesNames2 = new String[]{LIVE_OBJECS, ALLOCATED_OBJECS};
    protected int itemCount = 0;
    protected int seriesCount = 2;
    protected long maxXValue = 0L;
    protected long maxYDisplayValue = 0L;
    protected long minXValue = 0L;
    protected long[] maxYValues = new long[this.seriesCount];
    protected long[] minYValues = new long[this.seriesCount];
    ArrayList historyListeners = new ArrayList(4);
    ArrayList listeners = new ArrayList(4);
    int[] history1;
    long[] history2;
    long[] time;
    boolean firstLine = true;
    int current = 0;
    private String className;
    private boolean enabled = false;
    private boolean liveness = false;
    private int historyClassID = -1;

    public History() {
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    public static synchronized History getInstance() {
        if (instance == null) {
            instance = new History();
        }
        return instance;
    }

    public String getClassName() {
        return this.className;
    }

    public int getCurrent() {
        return this.current;
    }

    public int[] getData() {
        return this.history1;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setHistoryClass(int n, String string) {
        if (!this.enabled) {
            this.enabled = true;
            this.history1 = new int[1024];
            this.history2 = new long[1024];
            this.time = new long[1024];
        }
        this.historyClassID = n;
        this.className = StringUtils.userFormClassName((String)string);
        this.current = 0;
        this.firstLine = true;
        for (int i = 0; i < this.history1.length; ++i) {
            this.history1[i] = 0;
            this.time[i] = 0L;
        }
        this.fireHistoryLogging();
    }

    public int getHistoryClassID() {
        return this.historyClassID;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public Color getLimitYColor() {
        return Color.WHITE;
    }

    public long getLimitYValue() {
        return Long.MAX_VALUE;
    }

    public void setLiveness(boolean bl) {
        this.liveness = bl;
    }

    public boolean isLiveness() {
        return this.liveness;
    }

    public long getMaxDisplayYValue(int n) {
        return n == 0 ? this.maxYValues[n] : this.maxYDisplayValue;
    }

    public long getMaxXValue() {
        return this.maxXValue;
    }

    public long getMaxYValue(int n) {
        return this.maxYValues[n];
    }

    public long getMinDisplayYValue(int n) {
        return 0L;
    }

    public long getMinXValue() {
        return this.minXValue;
    }

    public long getMinYValue(int n) {
        return 0L;
    }

    public Color getSeriesColor(int n) {
        return this.seriesColors[n];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int n) {
        if (!this.isLiveness()) {
            return this.seriesNames1[n];
        }
        return this.seriesNames2[n];
    }

    public long getXValue(int n) {
        int n2;
        if (n < 0) {
            return 0L;
        }
        int n3 = n2 = !this.firstLine ? n + this.current : n;
        if (n2 >= this.time.length) {
            n2 -= this.time.length;
        }
        return this.time[n2];
    }

    public long getYValue(int n, int n2) {
        int n3;
        if (n < 0) {
            return 0L;
        }
        int n4 = n3 = !this.firstLine ? n + this.current : n;
        if (n3 >= this.history1.length) {
            n3 -= this.history1.length;
        }
        if (n2 == 0) {
            return this.history1[n3];
        }
        return this.history2[n3];
    }

    public void addChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.add(chartModelListener);
    }

    public void addHistoryListener(HistoryListener historyListener) {
        this.historyListeners.add(historyListener);
    }

    public void instrumentationChanged(int n, int n2) {
    }

    public void performAction(String string, Object[] objectArray) {
        if ("history logging".equals(string)) {
            ProfilerDialogs.DNSAConfirmationChecked dNSAConfirmationChecked;
            ProfilerDialogs.DNSAConfirmationChecked dNSAConfirmationChecked2;
            int n = (Integer)objectArray[0];
            if (this.historyClassID != -1 && (n == this.historyClassID ? !ProfilerDialogs.notify((NotifyDescriptor)(dNSAConfirmationChecked2 = new ProfilerDialogs.DNSAConfirmationChecked("History.historylogging.reset", (Object)MessageFormat.format(LOGGING_RESET_MSG, this.className), LOGGING_CONFIRMATION_CAPTION, 0))).equals(ProfilerDialogs.DNSAConfirmationChecked.YES_OPTION) : !ProfilerDialogs.notify((NotifyDescriptor)(dNSAConfirmationChecked = new ProfilerDialogs.DNSAConfirmationChecked("History.historylogging.stop", (Object)MessageFormat.format(LOGGING_STOP_MSG, this.className), LOGGING_CONFIRMATION_CAPTION, 0))).equals(ProfilerDialogs.DNSAConfirmationChecked.YES_OPTION))) {
                return;
            }
            this.setLiveness((Boolean)objectArray[2]);
            this.setHistoryClass(n, (String)objectArray[1]);
        } else if ("history update".equals(string)) {
            this.update(objectArray[0], objectArray[1]);
        }
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        if (profilingStateEvent.getNewState() == 1) {
            this.enabled = false;
        } else if (profilingStateEvent.getNewState() == 2) {
            this.historyClassID = -1;
        }
    }

    public void removeChartModelListener(ChartModelListener chartModelListener) {
        this.listeners.remove(chartModelListener);
    }

    public void removeHistoryListener(HistoryListener historyListener) {
        this.historyListeners.remove(historyListener);
    }

    public void threadsMonitoringChanged() {
    }

    public void update(Object object, Object object2) {
        if (this.historyClassID > -1 && this.enabled) {
            if (object instanceof int[]) {
                this.history1[this.current] = ((int[])object)[this.historyClassID];
            }
            if (object2 != null) {
                if (object2 instanceof int[]) {
                    this.history2[this.current] = ((int[])object2)[this.historyClassID];
                } else if (object2 instanceof long[]) {
                    this.history2[this.current] = ((long[])object2)[this.historyClassID];
                }
            }
            this.time[this.current] = System.currentTimeMillis();
            ++this.current;
            if (this.current >= this.history1.length) {
                this.current = 0;
                this.firstLine = false;
            }
            int n = this.itemCount = this.firstLine ? this.current : this.history1.length;
            this.minXValue = this.firstLine ? this.time[0] : (this.current < this.time.length - 1 ? this.time[this.current] : this.time[0]);
            this.maxXValue = this.current > 0 ? this.time[this.current - 1] : this.time[this.time.length - 1];
            this.setMinMax();
            this.fireChartChanged();
        }
    }

    protected long getDisplay(long l, long l2) {
        long l3 = l2 - l;
        for (long i = 1L; 10L * l3 > i; i *= 10L) {
            if (i > l3) {
                return i;
            }
            if (2L * i > l3) {
                return 2L * i;
            }
            if (5L * i <= l3) continue;
            return 5L * i;
        }
        return l3;
    }

    protected void setMinMax() {
        int n = this.firstLine ? this.current : this.history1.length;
        int n2 = 0;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            if (this.history1[i] > n2) {
                n2 = this.history1[i];
            }
            if (this.history2[i] <= l) continue;
            l = this.history2[i];
        }
        this.maxYValues[0] = n2;
        this.maxYValues[1] = l;
        this.maxYDisplayValue = this.getDisplay(this.getMinYValue(1), l);
    }

    protected void fireChartChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ChartModelListener)this.listeners.get(i)).chartDataChanged();
        }
    }

    protected void fireHistoryLogging() {
        for (int i = 0; i < this.historyListeners.size(); ++i) {
            ((HistoryListener)this.historyListeners.get(i)).historyLogging();
        }
    }
}

