/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.threads;

import java.awt.Color;
import java.util.HashMap;
import java.util.ResourceBundle;

public class TimeLineUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.threads.Bundle");
    private static final String MINUTES_ABBR = messages.getString("TimeLineUtils_MinutesAbbr");
    private static final String HOURS_ABBR = messages.getString("TimeLineUtils_HoursAbbr");
    private static final String HOURS_LEGEND_ABBR = messages.getString("TimeLineUtils_HoursLegendAbbr");
    private static final String MINUTES_LEGEND_ABBR = messages.getString("TimeLineUtils_MinutesLegendAbbr");
    private static final String SECONDS_LEGEND_ABBR = messages.getString("TimeLineUtils_SecondsLegendAbbr");
    private static final String MILLISECONDS_LEGEND_ABBR = messages.getString("TimeLineUtils_MillisecondsLegendAbbr");
    public static final int MIN_TIMEMARK_STEP = 150;
    public static final Color BASE_TIMELINE_COLOR = new Color(0, 0, 0);
    public static final Color MAIN_TIMELINE_COLOR = new Color(150, 150, 150);
    public static final Color TICK_TIMELINE_COLOR = new Color(230, 230, 230);
    private static final int TIME_FORMAT_UNKNOWN = -1;
    private static final int TIME_FORMAT_MILLIS = 10;
    private static final int TIME_FORMAT_SECONDS = 20;
    private static final int TIME_FORMAT_MINUTES = 30;
    private static final int TIME_FORMAT_HOURS = 40;
    private static final int[] timeUnitsGrid = new int[]{10, 50, 100, 250, 500, 1000, 5000, 10000, 30000, 60000, 180000, 300000, 600000, 3600000, 18000000, 36000000};
    private static final int[] ticksCountGrid = new int[]{10, 5, 10, 5, 5, 10, 5, 10, 6, 6, 6, 5, 10, 6, 5, 10};
    private static final int[] timeUnitsFormat = new int[]{10, 10, 10, 10, 10, 20, 20, 20, 20, 30, 30, 30, 30, 40, 40, 40};
    private static final HashMap timeUnitsToIndex = new HashMap();

    public static String getHoursValue(long l) {
        long l2 = l / 3600000L;
        return "" + l2 + " " + HOURS_ABBR;
    }

    public static String getMillisValue(long l) {
        long l2 = l / 3600000L;
        String string = l2 == 0L ? "" : "" + l2 + ":";
        long l3 = (l %= 3600000L) / 60000L;
        String string2 = (l2 > 0L && l3 < 10L ? "0" + l3 : "" + l3) + ":";
        long l4 = (l %= 60000L) / 1000L;
        String string3 = (l4 < 10L ? "0" + l4 : "" + l4) + ".";
        long l5 = l %= 1000L;
        String string4 = "" + l5;
        if (l5 < 10L) {
            string4 = "0" + string4;
        }
        if (l5 < 100L) {
            string4 = "0" + string4;
        }
        return string + string2 + string3 + string4;
    }

    public static String getMillisValue2(long l) {
        long l2 = l / 3600000L;
        String string = l2 == 0L ? "" : "" + l2 + ":";
        long l3 = (l %= 3600000L) / 60000L;
        String string2 = l2 == 0L && l3 == 0L ? "" : (l2 > 0L && l3 < 10L ? "0" + l3 : "" + l3) + ":";
        long l4 = (l %= 60000L) / 1000L;
        String string3 = (l4 < 10L && string2.length() > 0 ? "0" + l4 : "" + l4) + ".";
        long l5 = l %= 1000L;
        String string4 = "" + l5;
        if (l5 < 10L) {
            string4 = "0" + string4;
        }
        if (l5 < 100L) {
            string4 = "0" + string4;
        }
        return string + string2 + string3 + string4;
    }

    public static String getMinutesValue(long l) {
        long l2 = l / 3600000L;
        String string = l2 == 0L ? "" : "" + l2 + ":";
        long l3 = (l %= 3600000L) / 60000L;
        String string2 = l2 > 0L && l3 < 10L ? "0" + l3 : "" + l3 + " " + MINUTES_ABBR;
        return string + string2;
    }

    public static int getOptimalUnits(float f) {
        for (int i = 0; i < timeUnitsGrid.length - 1; ++i) {
            if (!((float)timeUnitsGrid[i] * f >= 150.0f)) continue;
            return timeUnitsGrid[i];
        }
        return timeUnitsGrid[timeUnitsGrid.length - 1];
    }

    public static String getSecondsValue(long l) {
        long l2 = l / 3600000L;
        String string = l2 == 0L ? "" : "" + l2 + ":";
        long l3 = (l %= 3600000L) / 60000L;
        String string2 = (l2 > 0L && l3 < 10L ? "0" + l3 : "" + l3) + ":";
        long l4 = (l %= 60000L) / 1000L;
        String string3 = l4 < 10L ? "0" + l4 : "" + l4;
        return string + string2 + string3;
    }

    public static int getTicksCount(int n) {
        int n2 = TimeLineUtils.getUnitsIndex(n);
        if (n2 == -1) {
            return 0;
        }
        return ticksCountGrid[n2];
    }

    public static String getTimeMarkMillisString(int n, int n2) {
        int n3 = TimeLineUtils.getTimeUnitsFormat(n2);
        if (n3 != 10) {
            return "";
        }
        n %= 3600000;
        n %= 60000;
        int n4 = n %= 1000;
        String string = "" + n4;
        if (n4 < 10) {
            string = "0" + string;
        }
        if (n4 < 100) {
            string = "0" + string;
        }
        return string;
    }

    public static String getTimeMarkNoMillisString(int n, int n2) {
        int n3 = TimeLineUtils.getTimeUnitsFormat(n2);
        if (n3 == -1) {
            return "";
        }
        if (n3 == 10) {
            n3 = 20;
        }
        return TimeLineUtils.getTimeMarkStringFromFormat(n, n3);
    }

    public static String getTimeMarkString(int n, int n2) {
        int n3 = TimeLineUtils.getTimeUnitsFormat(n2);
        if (n3 == -1) {
            return "";
        }
        return TimeLineUtils.getTimeMarkStringFromFormat(n, n3);
    }

    public static String getUnitsLegend(int n, int n2) {
        int n3;
        String string = TimeLineUtils.getTimeMarkNoMillisString(n, n2);
        if (string.endsWith(MINUTES_ABBR)) {
            return "[" + MINUTES_LEGEND_ABBR + "]";
        }
        if (string.endsWith(HOURS_ABBR)) {
            return "[" + HOURS_LEGEND_ABBR + "]";
        }
        String string2 = "";
        if (!TimeLineUtils.getTimeMarkMillisString(n, n2).equals("")) {
            string2 = "." + MILLISECONDS_LEGEND_ABBR;
        }
        if ((n3 = n / 3600000) != 0) {
            return "[" + HOURS_LEGEND_ABBR + ":" + MINUTES_LEGEND_ABBR + ":" + SECONDS_LEGEND_ABBR + string2 + "]";
        }
        return "[" + MINUTES_LEGEND_ABBR + ":" + SECONDS_LEGEND_ABBR + string2 + "]";
    }

    private static String getTimeMarkStringFromFormat(int n, int n2) {
        switch (n2) {
            case 10: {
                return TimeLineUtils.getMillisValue(n);
            }
            case 20: {
                return TimeLineUtils.getSecondsValue(n);
            }
            case 30: {
                return TimeLineUtils.getMinutesValue(n);
            }
            case 40: {
                return TimeLineUtils.getHoursValue(n);
            }
        }
        return "";
    }

    private static int getTimeUnitsFormat(int n) {
        int n2 = TimeLineUtils.getUnitsIndex(n);
        if (n2 == -1) {
            return -1;
        }
        return timeUnitsFormat[n2];
    }

    private static int getUnitsIndex(int n) {
        Object v = timeUnitsToIndex.get(new Integer(n));
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    static {
        for (int i = 0; i < timeUnitsGrid.length; ++i) {
            timeUnitsToIndex.put(new Integer(timeUnitsGrid[i]), new Integer(i));
        }
    }
}

